/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.code.ReturnObject;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.ReturnWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class Return
extends JumpInstruction {
    public Return() {
        super(null);
    }

    public Return(Value value) {
        super(null, value);
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isReturnVoid() {
        return this.inValues.size() == 0;
    }

    public TypeLatticeElement getReturnType() {
        assert (!this.isReturnVoid());
        return this.returnValue().getTypeLattice();
    }

    public Value returnValue() {
        assert (!this.isReturnVoid());
        return (Value)this.inValues.get(0);
    }

    public com.android.tools.r8.code.Instruction createDexInstruction(DexBuilder builder) {
        if (this.isReturnVoid()) {
            return new ReturnVoid();
        }
        int register = builder.allocatedRegister(this.returnValue(), this.getNumber());
        TypeLatticeElement returnType = this.getReturnType();
        if (returnType.isReference()) {
            return new ReturnObject(register);
        }
        if (returnType.isSingle()) {
            return new com.android.tools.r8.code.Return(register);
        }
        if (returnType.isWide()) {
            return new ReturnWide(register);
        }
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addReturn(this, this.createDexInstruction(builder));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isReturn()) {
            return false;
        }
        Return o = other.asReturn();
        if (this.isReturnVoid()) {
            return o.isReturnVoid();
        }
        return this.getReturnType().isValueTypeCompatible(o.getReturnType());
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Return defines no values.";
        return 0;
    }

    @Override
    public boolean isReturn() {
        return true;
    }

    @Override
    public Return asReturn() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forReturn();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        if (!this.isReturnVoid()) {
            helper.loadInValues(this, it);
        }
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(this.isReturnVoid() ? new CfReturnVoid() : new CfReturn(ValueType.fromTypeLattice(this.getReturnType())));
    }
}

