/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import java.util.HashMap;
import java.util.Map;

public class ArrayFilledDataPayloadResolver {
    private final Map<Integer, FillArrayDataPayload> unresolvedPayload = new HashMap<Integer, FillArrayDataPayload>();
    private final Map<Integer, PayloadData> payloadToData = new HashMap<Integer, PayloadData>();

    public void addPayloadUser(FillArrayData dex) {
        int offset = dex.getOffset();
        int payloadOffset = offset + dex.getPayloadOffset();
        assert (!this.payloadToData.containsKey(payloadOffset));
        this.payloadToData.put(payloadOffset, new PayloadData());
        if (this.unresolvedPayload.containsKey(payloadOffset)) {
            FillArrayDataPayload payload = this.unresolvedPayload.remove(payloadOffset);
            this.resolve(payload);
        }
    }

    public void resolve(FillArrayDataPayload payload) {
        int payloadOffset = payload.getOffset();
        PayloadData data = this.payloadToData.get(payloadOffset);
        if (data == null) {
            this.unresolvedPayload.put(payloadOffset, payload);
            return;
        }
        data.element_width = payload.element_width;
        data.size = payload.size;
        data.data = payload.data;
    }

    public int getElementWidth(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).element_width;
    }

    public long getSize(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).size;
    }

    public short[] getData(int payloadOffset) {
        return this.payloadToData.get((Object)Integer.valueOf((int)payloadOffset)).data;
    }

    public void clear() {
        this.payloadToData.clear();
    }

    private static class PayloadData {
        public int element_width;
        public long size;
        public short[] data;

        private PayloadData() {
        }
    }
}

