/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.conversion.CallGraphBuilder;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.MethodProcessingOrder;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;
import java.util.TreeSet;

public class CallGraph {
    final Set<Node> nodes;

    CallGraph(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public static CallGraphBuilder builder(AppView<AppInfoWithLiveness> appView) {
        return new CallGraphBuilder(appView);
    }

    CallSiteInformation createCallSiteInformation(AppView<AppInfoWithLiveness> appView) {
        return appView.options().isShrinking() ? new CallSiteInformation.CallGraphBasedCallSiteInformation(appView, this) : CallSiteInformation.empty();
    }

    MethodProcessingOrder createMethodProcessingOrder(AppView<?> appView) {
        return new MethodProcessingOrder(appView, this);
    }

    public static class Node
    implements Comparable<Node> {
        public static Node[] EMPTY_ARRAY = new Node[0];
        public final DexEncodedMethod method;
        private int numberOfCallSites = 0;
        private final Set<Node> callees = new TreeSet<Node>();
        private final Set<Node> callers = new TreeSet<Node>();

        public Node(DexEncodedMethod method) {
            this.method = method;
        }

        public void addCallerConcurrently(Node caller) {
            this.addCallerConcurrently(caller, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallerConcurrently(Node caller, boolean likelySpuriousCallEdge) {
            if (caller != this && !likelySpuriousCallEdge) {
                Set<Node> set = this.callers;
                synchronized (set) {
                    this.callers.add(caller);
                    ++this.numberOfCallSites;
                }
                set = caller.callees;
                synchronized (set) {
                    caller.callees.add(this);
                }
            }
            Set<Node> set = this.callers;
            synchronized (set) {
                ++this.numberOfCallSites;
            }
        }

        public void removeCaller(Node caller) {
            this.callers.remove(caller);
            caller.callees.remove(this);
        }

        public void cleanForRemoval() {
            assert (this.callees.isEmpty());
            for (Node caller : this.callers) {
                caller.callees.remove(this);
            }
        }

        public Set<Node> getCallersWithDeterministicOrder() {
            return this.callers;
        }

        public Set<Node> getCalleesWithDeterministicOrder() {
            return this.callees;
        }

        public int getNumberOfCallSites() {
            return this.numberOfCallSites;
        }

        public boolean hasCallee(Node method) {
            return this.callees.contains(method);
        }

        public boolean hasCaller(Node method) {
            return this.callers.contains(method);
        }

        public boolean isLeaf() {
            return this.callees.isEmpty();
        }

        @Override
        public int compareTo(Node other) {
            return this.method.method.slowCompareTo(other.method.method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodNode for: ");
            builder.append(this.method.toSourceString());
            builder.append(" (");
            builder.append(this.callees.size());
            builder.append(" callees, ");
            builder.append(this.callers.size());
            builder.append(" callers");
            builder.append(", invoke count ").append(this.numberOfCallSites);
            builder.append(").\n");
            if (this.callees.size() > 0) {
                builder.append("Callees:\n");
                for (Node call : this.callees) {
                    builder.append("  ");
                    builder.append(call.method.toSourceString());
                    builder.append("\n");
                }
            }
            if (this.callers.size() > 0) {
                builder.append("Callers:\n");
                for (Node caller : this.callers) {
                    builder.append("  ");
                    builder.append(caller.method.toSourceString());
                    builder.append("\n");
                }
            }
            return builder.toString();
        }
    }
}

