/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CallGraphBuilder {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexMethod, CallGraph.Node> nodes = new IdentityHashMap<DexMethod, CallGraph.Node>();
    private final Map<DexMethod, Set<DexEncodedMethod>> possibleTargetsCache = new ConcurrentHashMap<DexMethod, Set<DexEncodedMethod>>();

    CallGraphBuilder(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public CallGraph build(ExecutorService executorService, Timing timing) throws ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!clazz.hasMethods()) continue;
            futures.add(executorService.submit(() -> {
                this.processClass(clazz);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
        assert (this.verifyAllMethodsWithCodeExists());
        timing.begin("Cycle elimination");
        TreeSet<CallGraph.Node> nodesWithDeterministicOrder = Sets.newTreeSet(this.nodes.values());
        CycleEliminator cycleEliminator = new CycleEliminator(nodesWithDeterministicOrder, this.appView.options());
        cycleEliminator.breakCycles();
        timing.end();
        assert (cycleEliminator.breakCycles() == 0);
        return new CallGraph(nodesWithDeterministicOrder);
    }

    private void processClass(DexProgramClass clazz) {
        clazz.forEachMethod(this::processMethod);
    }

    private void processMethod(DexEncodedMethod method) {
        if (method.hasCode()) {
            method.registerCodeReferences(new InvokeExtractor(this.getOrCreateNode(method)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallGraph.Node getOrCreateNode(DexEncodedMethod method) {
        Map<DexMethod, CallGraph.Node> map2 = this.nodes;
        synchronized (map2) {
            return this.nodes.computeIfAbsent(method.method, ignore -> new CallGraph.Node(method));
        }
    }

    private boolean verifyAllMethodsWithCodeExists() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            for (DexEncodedMethod method : clazz.methods()) {
                assert (!method.hasCode() || this.nodes.get(method.method) != null);
            }
        }
        return true;
    }

    public static class CycleEliminator {
        public static final String CYCLIC_FORCE_INLINING_MESSAGE = "Unable to satisfy force inlining constraints due to cyclic force inlining";
        private final Collection<CallGraph.Node> nodes;
        private final InternalOptions options;
        private Deque<CallGraph.Node> stack = new ArrayDeque<CallGraph.Node>();
        private Set<CallGraph.Node> stackSet = Sets.newIdentityHashSet();
        private Set<CallGraph.Node> marked = Sets.newIdentityHashSet();
        private int currentDepth = 0;
        private int maxDepth = 0;
        private int numberOfCycles = 0;

        public CycleEliminator(Collection<CallGraph.Node> nodes, InternalOptions options) {
            this.options = options;
            this.nodes = options.testing.nondeterministicCycleElimination ? this.reorderNodes(new ArrayList<CallGraph.Node>(nodes)) : nodes;
        }

        public int breakCycles() {
            for (CallGraph.Node node : this.nodes) {
                assert (this.currentDepth == 0);
                this.traverse(node);
            }
            int result = this.numberOfCycles;
            this.reset();
            return result;
        }

        private void reset() {
            assert (this.currentDepth == 0);
            assert (this.stack.isEmpty());
            assert (this.stackSet.isEmpty());
            this.marked.clear();
            this.maxDepth = 0;
            this.numberOfCycles = 0;
        }

        private void traverse(CallGraph.Node node) {
            if (this.marked.contains(node)) {
                return;
            }
            this.push(node);
            Collection<CallGraph.Node> callees = node.getCalleesWithDeterministicOrder();
            if (this.options.testing.nondeterministicCycleElimination) {
                callees = this.reorderNodes(new ArrayList<CallGraph.Node>(callees));
            }
            Iterator calleeIterator = callees.iterator();
            while (calleeIterator.hasNext()) {
                boolean thresholdExceeded;
                CallGraph.Node callee = (CallGraph.Node)calleeIterator.next();
                boolean foundCycle = this.stackSet.contains(callee);
                boolean bl = thresholdExceeded = this.currentDepth >= this.options.callGraphCycleEliminatorMaxDepthThreshold && CycleEliminator.edgeRemovalIsSafe(node, callee);
                if (foundCycle || thresholdExceeded) {
                    ++this.numberOfCycles;
                    if (CycleEliminator.edgeRemovalIsSafe(node, callee)) {
                        if (this.options.testing.nondeterministicCycleElimination) {
                            callee.removeCaller(node);
                            continue;
                        }
                        calleeIterator.remove();
                        callee.getCallersWithDeterministicOrder().remove(node);
                        continue;
                    }
                    assert (foundCycle);
                    LinkedList<CallGraph.Node> cycle = this.extractCycle(callee);
                    CallEdge edge = this.findCallEdgeForRemoval(cycle);
                    if (edge != null) {
                        assert (CycleEliminator.edgeRemovalIsSafe(edge.caller, edge.callee));
                        edge.remove();
                    }
                    this.recoverStack(cycle);
                    continue;
                }
                ++this.currentDepth;
                this.traverse(callee);
                --this.currentDepth;
            }
            this.pop(node);
            this.marked.add(node);
        }

        private void push(CallGraph.Node node) {
            this.stack.push(node);
            boolean changed = this.stackSet.add(node);
            assert (changed);
        }

        private void pop(CallGraph.Node node) {
            CallGraph.Node popped = this.stack.pop();
            assert (popped == node);
            boolean changed = this.stackSet.remove(node);
            assert (changed);
        }

        private LinkedList<CallGraph.Node> extractCycle(CallGraph.Node entry) {
            LinkedList<CallGraph.Node> cycle = new LinkedList<CallGraph.Node>();
            do {
                assert (!this.stack.isEmpty());
                cycle.add(this.stack.pop());
            } while (cycle.getLast() != entry);
            return cycle;
        }

        private CallEdge findCallEdgeForRemoval(LinkedList<CallGraph.Node> extractedCycle) {
            CallGraph.Node callee = extractedCycle.getLast();
            for (CallGraph.Node caller : extractedCycle) {
                if (!caller.hasCallee(callee)) {
                    assert (!callee.hasCaller(caller));
                    return null;
                }
                if (CycleEliminator.edgeRemovalIsSafe(caller, callee)) {
                    return new CallEdge(caller, callee);
                }
                callee = caller;
            }
            throw new CompilationError(CYCLIC_FORCE_INLINING_MESSAGE);
        }

        private static boolean edgeRemovalIsSafe(CallGraph.Node caller, CallGraph.Node callee) {
            return !callee.method.getOptimizationInfo().forceInline();
        }

        private void recoverStack(LinkedList<CallGraph.Node> extractedCycle) {
            Iterator<CallGraph.Node> descendingIt = extractedCycle.descendingIterator();
            while (descendingIt.hasNext()) {
                this.stack.push(descendingIt.next());
            }
        }

        private Collection<CallGraph.Node> reorderNodes(List<CallGraph.Node> nodes) {
            assert (this.options.testing.nondeterministicCycleElimination);
            Collections.shuffle(nodes);
            return nodes;
        }

        private static class CallEdge {
            private final CallGraph.Node caller;
            private final CallGraph.Node callee;

            public CallEdge(CallGraph.Node caller, CallGraph.Node callee) {
                this.caller = caller;
                this.callee = callee;
            }

            public void remove() {
                this.callee.removeCaller(this.caller);
            }
        }
    }

    private class InvokeExtractor
    extends UseRegistry {
        private final CallGraph.Node caller;

        InvokeExtractor(CallGraph.Node caller) {
            super(CallGraphBuilder.this.appView.dexItemFactory());
            this.caller = caller;
        }

        private void addClassInitializerTarget(DexClass clazz) {
            assert (clazz != null);
            if (clazz.isProgramClass() && clazz.hasClassInitializer()) {
                this.addTarget(clazz.getClassInitializer(), false);
            }
        }

        private void addClassInitializerTarget(DexType type) {
            assert (type.isClassType());
            DexClass clazz = CallGraphBuilder.this.appView.definitionFor(type);
            if (clazz != null) {
                this.addClassInitializerTarget(clazz);
            }
        }

        private void addTarget(DexEncodedMethod callee, boolean likelySpuriousCallEdge) {
            if (!callee.accessFlags.isAbstract()) {
                assert (callee.isProgramMethod(CallGraphBuilder.this.appView));
                CallGraphBuilder.this.getOrCreateNode(callee).addCallerConcurrently(this.caller, likelySpuriousCallEdge);
            }
        }

        private void processInvoke(Invoke.Type originalType, DexMethod originalMethod) {
            DexEncodedMethod source = this.caller.method;
            DexMethod context = source.method;
            GraphLense.GraphLenseLookupResult result = CallGraphBuilder.this.appView.graphLense().lookupMethod(originalMethod, context, originalType);
            DexMethod method = result.getMethod();
            Invoke.Type type = result.getType();
            if (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL) {
                AppInfo.ResolutionResult resolutionResult = ((AppInfoWithLiveness)CallGraphBuilder.this.appView.appInfo()).resolveMethod(method.holder, method);
                resolutionResult.forEachTarget(target -> this.processInvokeWithDynamicDispatch(type, (DexEncodedMethod)target));
            } else {
                DexEncodedMethod singleTarget = ((AppInfoWithLiveness)CallGraphBuilder.this.appView.appInfo()).lookupSingleTarget(type, method, context.holder);
                if (singleTarget != null) {
                    assert (!source.accessFlags.isBridge() || singleTarget != this.caller.method);
                    DexClass clazz = CallGraphBuilder.this.appView.definitionFor(singleTarget.method.holder);
                    assert (clazz != null);
                    if (clazz.isProgramClass()) {
                        if (type == Invoke.Type.STATIC) {
                            this.addClassInitializerTarget(clazz);
                        }
                        this.addTarget(singleTarget, false);
                    }
                }
            }
        }

        private void processInvokeWithDynamicDispatch(Invoke.Type type, DexEncodedMethod encodedTarget) {
            DexMethod target = encodedTarget.method;
            DexClass clazz = CallGraphBuilder.this.appView.definitionFor(target.holder);
            if (clazz == null) {
                assert (false) : "Unable to lookup holder of `" + target.toSourceString() + "`";
                return;
            }
            if (!((CallGraphBuilder)CallGraphBuilder.this).appView.options().testing.addCallEdgesForLibraryInvokes && clazz.isLibraryClass()) {
                return;
            }
            Set possibleTargets = CallGraphBuilder.this.possibleTargetsCache.computeIfAbsent(target, method -> type == Invoke.Type.INTERFACE ? ((AppInfoWithLiveness)CallGraphBuilder.this.appView.appInfo()).lookupInterfaceTargets((DexMethod)method) : ((AppInfoWithLiveness)CallGraphBuilder.this.appView.appInfo()).lookupVirtualTargets((DexMethod)method));
            if (possibleTargets != null) {
                boolean likelySpuriousCallEdge = possibleTargets.size() >= ((CallGraphBuilder)CallGraphBuilder.this).appView.options().callGraphLikelySpuriousCallEdgeThreshold;
                for (DexEncodedMethod possibleTarget : possibleTargets) {
                    if (!possibleTarget.isProgramMethod(CallGraphBuilder.this.appView)) continue;
                    this.addTarget(possibleTarget, likelySpuriousCallEdge);
                }
            }
        }

        private void processFieldAccess(DexField field) {
            DexEncodedField encodedField;
            if (field.holder.isClassType() && (encodedField = ((AppInfoWithLiveness)CallGraphBuilder.this.appView.appInfo()).resolveField(field)) != null && encodedField.isStatic()) {
                this.addClassInitializerTarget(field.holder);
            }
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            this.processInvoke(Invoke.Type.VIRTUAL, method);
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.processInvoke(Invoke.Type.DIRECT, method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            this.processInvoke(Invoke.Type.STATIC, method);
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            this.processInvoke(Invoke.Type.INTERFACE, method);
            return false;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.processInvoke(Invoke.Type.SUPER, method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            if (type.isClassType()) {
                this.addClassInitializerTarget(type);
            }
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }
}

