/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public abstract class CallSiteInformation {
    public abstract boolean hasSingleCallSite(DexMethod var1);

    public abstract boolean hasDoubleCallSite(DexMethod var1);

    public static CallSiteInformation empty() {
        return EmptyCallSiteInformation.EMPTY_INFO;
    }

    static class CallGraphBasedCallSiteInformation
    extends CallSiteInformation {
        private final Set<DexMethod> singleCallSite = Sets.newIdentityHashSet();
        private final Set<DexMethod> doubleCallSite = Sets.newIdentityHashSet();

        CallGraphBasedCallSiteInformation(AppView<AppInfoWithLiveness> appView, CallGraph graph) {
            for (CallGraph.Node node : graph.nodes) {
                DexEncodedMethod encodedMethod = node.method;
                DexMethod method = encodedMethod.method;
                if (appView.appInfo().isPinned(method) || encodedMethod.isLibraryMethodOverride().isTrue()) continue;
                int numberOfCallSites = node.getNumberOfCallSites();
                if (numberOfCallSites == 1) {
                    this.singleCallSite.add(method);
                    continue;
                }
                if (numberOfCallSites != 2) continue;
                this.doubleCallSite.add(method);
            }
        }

        @Override
        public boolean hasSingleCallSite(DexMethod method) {
            return this.singleCallSite.contains(method);
        }

        @Override
        public boolean hasDoubleCallSite(DexMethod method) {
            return this.doubleCallSite.contains(method);
        }
    }

    private static class EmptyCallSiteInformation
    extends CallSiteInformation {
        private static final EmptyCallSiteInformation EMPTY_INFO = new EmptyCallSiteInformation();

        private EmptyCallSiteInformation() {
        }

        @Override
        public boolean hasSingleCallSite(DexMethod method) {
            return false;
        }

        @Override
        public boolean hasDoubleCallSite(DexMethod method) {
            return false;
        }
    }
}

