/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.cf.CfRegisterAllocator;
import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Inc;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import com.android.tools.r8.ir.optimize.PhiOptimizations;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockMuncher;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CfBuilder {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    private static final int SUFFIX_SHARING_OVERHEAD = 30;
    private static final int IINC_PATTERN_SIZE = 4;
    public final AppView<?> appView;
    private final DexEncodedMethod method;
    private final IRCode code;
    private Map<BasicBlock, CfLabel> labels;
    private Set<CfLabel> emittedLabels;
    private List<CfInstruction> instructions;
    private CfRegisterAllocator registerAllocator;
    private Position currentPosition = Position.none();
    private final Int2ReferenceMap<DebugLocalInfo> emittedLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
    private Int2ReferenceMap<DebugLocalInfo> pendingLocals = null;
    private boolean pendingLocalChanges = false;
    private BasicBlock pendingFrame = null;
    private final List<CfCode.LocalVariableInfo> localVariablesTable = new ArrayList<CfCode.LocalVariableInfo>();
    private final Int2ReferenceMap<CfCode.LocalVariableInfo> openLocalVariables = new Int2ReferenceOpenHashMap<CfCode.LocalVariableInfo>();
    private Map<NewInstance, List<InvokeDirect>> initializers;
    private List<InvokeDirect> thisInitializers;
    private Map<NewInstance, CfLabel> newInstanceLabels;

    public CfBuilder(AppView<?> appView, DexEncodedMethod method, IRCode code) {
        this.appView = appView;
        this.method = method;
        this.code = code;
    }

    public CfCode build(CodeRewriter rewriter) {
        this.computeInitializers();
        TypeVerificationHelper typeVerificationHelper = new TypeVerificationHelper(this.appView, this.code);
        typeVerificationHelper.computeVerificationTypes();
        rewriter.converter.deadCodeRemover.run(this.code);
        this.rewriteNots();
        LoadStoreHelper loadStoreHelper = new LoadStoreHelper(this.appView, this.code, typeVerificationHelper);
        loadStoreHelper.insertLoadsAndStores();
        if (!this.appView.options().testing.disallowLoadStoreOptimization) {
            PhiOptimizations phiOptimizations = new PhiOptimizations();
            boolean reachedFixpoint = false;
            phiOptimizations.optimize(this.code);
            while (!reachedFixpoint) {
                BasicBlockMuncher.optimize(this.code);
                reachedFixpoint = !phiOptimizations.optimize(this.code);
            }
        }
        assert (this.code.isConsistentSSA());
        this.registerAllocator = new CfRegisterAllocator(this.appView, this.code, typeVerificationHelper);
        this.registerAllocator.allocateRegisters();
        loadStoreHelper.insertPhiMoves(this.registerAllocator);
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapseTrivialGotos(this.method, this.code);
            PeepholeOptimizer.removeIdenticalPredecessorBlocks(this.code, this.registerAllocator);
            PeepholeOptimizer.shareIdenticalBlockSuffix(this.code, this.registerAllocator, 30);
        }
        this.rewriteIincPatterns();
        CodeRewriter.collapseTrivialGotos(this.method, this.code);
        DexBuilder.removeRedundantDebugPositions(this.code);
        CfCode code = this.buildCfCode();
        assert (CfBuilder.verifyInvokeInterface(code, this.appView));
        return code;
    }

    private static boolean verifyInvokeInterface(CfCode code, DexDefinitionSupplier definitions) {
        for (CfInstruction instruction : code.instructions) {
            if (!(instruction instanceof CfInvoke)) continue;
            CfInvoke invoke = (CfInvoke)instruction;
            if (!invoke.getMethod().holder.isClassType()) continue;
            DexClass holder = definitions.definitionFor(invoke.getMethod().holder);
            assert (holder == null || holder.isInterface() == invoke.isInterface());
        }
        return true;
    }

    public DexField resolveField(DexField field) {
        DexEncodedField resolvedField = ((AppInfo)this.appView.appInfo()).resolveField(field);
        return resolvedField == null ? field : resolvedField.field;
    }

    private void computeInitializers() {
        assert (this.initializers == null);
        assert (this.thisInitializers == null);
        this.initializers = new HashMap<NewInstance, List<InvokeDirect>>();
        for (BasicBlock block : this.code.blocks) {
            for (Instruction insn : block.getInstructions()) {
                if (insn.isNewInstance()) {
                    this.initializers.put(insn.asNewInstance(), this.computeInitializers(insn.outValue()));
                    continue;
                }
                if (!insn.isArgument() || !this.method.isInstanceInitializer() || !insn.outValue().isThis()) continue;
                this.thisInitializers = this.computeInitializers(insn.outValue());
            }
        }
        assert (!this.method.isInstanceInitializer() || this.thisInitializers != null);
    }

    private List<InvokeDirect> computeInitializers(Value value) {
        ArrayList<InvokeDirect> initializers = new ArrayList<InvokeDirect>();
        for (Instruction user : value.uniqueUsers()) {
            if (!(user instanceof InvokeDirect) || user.inValues().get(0) != value || user.asInvokeDirect().getInvokedMethod().name != this.appView.dexItemFactory().constructorMethodName) continue;
            initializers.add(user.asInvokeDirect());
        }
        return initializers;
    }

    private void rewriteNots() {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isNot()) continue;
                Value inValue = current.inValues().get(0);
                it.previous();
                Value constValue = this.code.createValue(inValue.getTypeLattice());
                ConstNumber newInstruction = new ConstNumber(constValue, -1L);
                newInstruction.setBlock(block);
                newInstruction.setPosition(current.getPosition());
                it.add(newInstruction);
                it.next();
                it.replaceCurrentInstruction(new Xor(current.asNot().type, current.outValue(), inValue, constValue));
            }
        }
    }

    private int stackHeightAtBlockEntry(BasicBlock block) {
        int height = 0;
        for (TypeVerificationHelper.TypeInfo type : this.registerAllocator.getTypesAtBlockEntry((BasicBlock)block).stack) {
            DexType dexType = type.getDexType();
            height += dexType.isDoubleType() || dexType.isLongType() ? 2 : 1;
        }
        return height;
    }

    private CfCode buildCfCode() {
        StackHeightTracker stackHeightTracker = new StackHeightTracker();
        ArrayList<CfTryCatch> tryCatchRanges = new ArrayList<CfTryCatch>();
        this.labels = new HashMap<BasicBlock, CfLabel>(this.code.blocks.size());
        this.emittedLabels = new HashSet<CfLabel>(this.code.blocks.size());
        this.newInstanceLabels = new HashMap<NewInstance, CfLabel>(this.initializers.size());
        this.instructions = new ArrayList<CfInstruction>();
        ListIterator<BasicBlock> blockIterator = this.code.listIterator();
        BasicBlock block = blockIterator.next();
        CfLabel tryCatchStart = null;
        CatchHandlers<BasicBlock> tryCatchHandlers = CatchHandlers.EMPTY_BASIC_BLOCK;
        boolean previousFallthrough = false;
        do {
            JumpInstruction exit;
            CatchHandlers<BasicBlock> handlers;
            if (!tryCatchHandlers.equals(handlers = block.getCatchHandlers())) {
                if (!tryCatchHandlers.isEmpty()) {
                    CfLabel tryCatchEnd = this.getLabel(block);
                    tryCatchRanges.add(CfTryCatch.fromBuilder(tryCatchStart, tryCatchEnd, tryCatchHandlers, this));
                    this.emitLabel(tryCatchEnd);
                }
                if (!handlers.isEmpty()) {
                    tryCatchStart = this.getLabel(block);
                    this.emitLabel(tryCatchStart);
                }
                tryCatchHandlers = handlers;
            }
            BasicBlock nextBlock = blockIterator.hasNext() ? blockIterator.next() : null;
            if (block.getPredecessors().size() > (previousFallthrough ? 1 : 0)) {
                this.pendingFrame = block;
                this.emitLabel(this.getLabel(block));
            }
            boolean fallthrough = (exit = block.exit()).isGoto() && exit.asGoto().getTarget() == nextBlock || exit.isIf() && exit.fallthroughBlock() == nextBlock;
            Int2ReferenceMap<DebugLocalInfo> locals = block.getLocalsAtEntry();
            if (locals == null) {
                assert (this.pendingLocals == null);
            } else {
                this.pendingLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(locals);
                this.pendingLocalChanges = true;
            }
            stackHeightTracker.setHeight(this.stackHeightAtBlockEntry(block));
            this.buildCfInstructions(block, nextBlock, fallthrough, stackHeightTracker);
            assert (!block.exit().isReturn() || stackHeightTracker.isEmpty());
            block = nextBlock;
            previousFallthrough = fallthrough;
        } while (block != null);
        if (!this.openLocalVariables.isEmpty()) {
            CfLabel endLabel = this.ensureLabel();
            for (CfCode.LocalVariableInfo info : this.openLocalVariables.values()) {
                info.setEnd(endLabel);
                this.localVariablesTable.add(info);
            }
        }
        return new CfCode(stackHeightTracker.maxHeight, this.registerAllocator.registersUsed(), this.instructions, tryCatchRanges, this.localVariablesTable);
    }

    private static boolean isNopInstruction(Instruction instruction, BasicBlock nextBlock) {
        return instruction.isArgument() || instruction.isMoveException() || instruction.isDebugLocalsChange() || instruction.isMoveException() || instruction.isGoto() && instruction.asGoto().getTarget() == nextBlock;
    }

    private boolean hasMaterializingInstructions(BasicBlock block, BasicBlock nextBlock) {
        if (block == null) {
            return false;
        }
        for (Instruction instruction : block.getInstructions()) {
            if (CfBuilder.isNopInstruction(instruction, nextBlock)) continue;
            return true;
        }
        return false;
    }

    private void rewriteIincPatterns() {
        for (BasicBlock block : this.code.blocks) {
            ListIterator<Inc> it = block.getInstructions().listIterator();
            while (4 <= block.getInstructions().size() - it.nextIndex()) {
                ConstNumber constNumber;
                Load load;
                Instruction loadOrConst1 = (Instruction)it.next();
                if (!loadOrConst1.isLoad() && !loadOrConst1.isConstNumber()) continue;
                if (loadOrConst1.isLoad()) {
                    load = loadOrConst1.asLoad();
                    constNumber = ((Instruction)it.next()).asConstNumber();
                } else {
                    load = ((Instruction)it.next()).asLoad();
                    constNumber = loadOrConst1.asConstNumber();
                }
                Add add = ((Instruction)it.next()).asAdd();
                Store store = ((Instruction)it.next()).asStore();
                it.previous();
                it.previous();
                it.previous();
                it.previous();
                if (load == null || constNumber == null || add == null || store == null || constNumber.outValue().getTypeLattice() != TypeLatticeElement.INT) {
                    it.next();
                    continue;
                }
                int increment = constNumber.getIntValue();
                if (increment < -128 || 127 < increment) {
                    it.next();
                    continue;
                }
                if (this.getLocalRegister(load.src()) != this.getLocalRegister(store.outValue())) {
                    it.next();
                    continue;
                }
                Position position = add.getPosition();
                if (position != load.getPosition() || position != constNumber.getPosition() || position != store.getPosition()) continue;
                it.remove();
                it.next();
                it.remove();
                it.next();
                it.remove();
                it.next();
                Inc inc = new Inc(store.outValue(), load.inValues().get(0), increment);
                inc.setPosition(position);
                inc.setBlock(block);
                it.set(inc);
            }
        }
    }

    private void buildCfInstructions(BasicBlock block, BasicBlock nextBlock, boolean fallthrough, StackHeightTracker stack) {
        if (this.pendingFrame != null) {
            boolean advancesPC = this.hasMaterializingInstructions(block, nextBlock);
            assert (advancesPC || nextBlock != null);
            if (advancesPC) {
                this.addFrame(this.pendingFrame);
                this.pendingFrame = null;
            }
        }
        InstructionIterator it = block.iterator();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (fallthrough && instruction.isGoto()) {
                assert (block.exit() == instruction);
                return;
            }
            for (int i = instruction.inValues().size() - 1; i >= 0; --i) {
                if (!instruction.inValues().get(i).isValueOnStack()) continue;
                stack.pop(instruction.inValues().get(i));
            }
            if (instruction.outValue() != null) {
                Value outValue = instruction.outValue();
                if (outValue instanceof StackValue) {
                    stack.push(outValue);
                }
                if (outValue instanceof StackValues) {
                    for (StackValue outVal : ((StackValues)outValue).getStackValues()) {
                        stack.push(outVal);
                    }
                }
            }
            if (instruction.isDebugLocalsChange()) {
                if (!instruction.asDebugLocalsChange().apply(this.pendingLocals)) continue;
                this.pendingLocalChanges = true;
                continue;
            }
            if (instruction.isNewInstance()) {
                this.newInstanceLabels.put(instruction.asNewInstance(), this.ensureLabel());
            }
            this.updatePositionAndLocals(instruction);
            instruction.buildCf(this);
        }
    }

    private void updatePositionAndLocals(Instruction instruction) {
        boolean didPositionChange;
        Position position = instruction.getPosition();
        boolean didLocalsChange = this.localsChanged();
        boolean bl = didPositionChange = !(!position.isSome() || position == this.currentPosition || this.currentPosition.isNone() && position.synthetic && position.callerPosition == null || !this.appView.options().debug && !instruction.instructionTypeCanThrow());
        if (!didLocalsChange && !didPositionChange) {
            return;
        }
        CfLabel label = this.ensureLabel();
        if (didLocalsChange) {
            this.updateLocals(label);
        }
        if (didPositionChange) {
            this.add(new CfPosition(label, position));
            this.currentPosition = position;
        }
    }

    private void updateLocals(CfLabel label) {
        int localIndex;
        Int2ReferenceSortedMap<DebugLocalInfo> ending = DebugLocalInfo.endingLocals(this.emittedLocals, this.pendingLocals);
        Int2ReferenceSortedMap<DebugLocalInfo> starting = DebugLocalInfo.startingLocals(this.emittedLocals, this.pendingLocals);
        assert (!ending.isEmpty() || !starting.isEmpty());
        for (Int2ReferenceMap.Entry entry : ending.int2ReferenceEntrySet()) {
            localIndex = entry.getIntKey();
            CfCode.LocalVariableInfo info = (CfCode.LocalVariableInfo)this.openLocalVariables.remove(localIndex);
            info.setEnd(label);
            this.localVariablesTable.add(info);
            DebugLocalInfo removed = (DebugLocalInfo)this.emittedLocals.remove(localIndex);
            assert (removed == entry.getValue());
        }
        if (!starting.isEmpty()) {
            for (Int2ReferenceMap.Entry entry : starting.int2ReferenceEntrySet()) {
                localIndex = entry.getIntKey();
                assert (!this.emittedLocals.containsKey(localIndex));
                assert (!this.openLocalVariables.containsKey(localIndex));
                this.openLocalVariables.put(localIndex, new CfCode.LocalVariableInfo(localIndex, (DebugLocalInfo)entry.getValue(), label));
                this.emittedLocals.put(localIndex, (DebugLocalInfo)entry.getValue());
            }
        }
        this.pendingLocalChanges = false;
    }

    private boolean localsChanged() {
        if (!this.pendingLocalChanges) {
            return false;
        }
        this.pendingLocalChanges = !DebugLocalInfo.localsInfoMapsEqual(this.emittedLocals, this.pendingLocals);
        return this.pendingLocalChanges;
    }

    private CfLabel ensureLabel() {
        CfInstruction last = this.getLastInstruction();
        if (last instanceof CfLabel) {
            return (CfLabel)last;
        }
        CfLabel label = new CfLabel();
        this.add(label);
        return label;
    }

    private CfInstruction getLastInstruction() {
        return this.instructions.isEmpty() ? null : this.instructions.get(this.instructions.size() - 1);
    }

    private void addFrame(BasicBlock block) {
        List<Object> stackTypes;
        List<TypeVerificationHelper.TypeInfo> stack = this.registerAllocator.getTypesAtBlockEntry((BasicBlock)block).stack;
        if (block.entry().isMoveException()) {
            assert (stack.isEmpty());
            StackValue exception = (StackValue)block.entry().outValue();
            stackTypes = Collections.singletonList(this.getFrameType(block, exception.getTypeInfo()));
        } else {
            stackTypes = new ArrayList(stack.size());
            for (TypeVerificationHelper.TypeInfo typeInfo : stack) {
                stackTypes.add(this.getFrameType(block, typeInfo));
            }
        }
        Int2ReferenceMap<TypeVerificationHelper.TypeInfo> locals = this.registerAllocator.getTypesAtBlockEntry((BasicBlock)block).registers;
        Int2ReferenceAVLTreeMap<CfFrame.FrameType> mapping = new Int2ReferenceAVLTreeMap<CfFrame.FrameType>();
        for (Int2ReferenceMap.Entry entry : locals.int2ReferenceEntrySet()) {
            mapping.put(entry.getIntKey(), this.getFrameType(block, (TypeVerificationHelper.TypeInfo)entry.getValue()));
        }
        CfFrame frame = new CfFrame(mapping, stackTypes);
        boolean bl = this.localsChanged();
        if (bl) {
            CfLabel label = this.ensureLabel();
            this.updateLocals(label);
        }
        this.instructions.add(frame);
    }

    private CfFrame.FrameType getFrameType(BasicBlock liveBlock, TypeVerificationHelper.TypeInfo typeInfo) {
        if (typeInfo instanceof TypeVerificationHelper.InitializedTypeInfo) {
            return CfFrame.FrameType.initialized(typeInfo.getDexType());
        }
        CfFrame.FrameType type = this.findAllocator(liveBlock, typeInfo);
        return type != null ? type : CfFrame.FrameType.initialized(typeInfo.getDexType());
    }

    private CfFrame.FrameType findAllocator(BasicBlock liveBlock, TypeVerificationHelper.TypeInfo typeInfo) {
        CfFrame.FrameType res;
        Instruction definition;
        if (typeInfo instanceof TypeVerificationHelper.NewInstanceInfo) {
            definition = ((TypeVerificationHelper.NewInstanceInfo)typeInfo).newInstance;
            res = CfFrame.FrameType.uninitializedNew(this.newInstanceLabels.get(definition));
        } else if (typeInfo instanceof TypeVerificationHelper.ThisInstanceInfo) {
            definition = ((TypeVerificationHelper.ThisInstanceInfo)typeInfo).thisArgument;
            res = CfFrame.FrameType.uninitializedThis();
        } else {
            throw new Unreachable("Unexpected type info: " + typeInfo);
        }
        BasicBlock definitionBlock = definition.getBlock();
        HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
        ArrayDeque<BasicBlock> toVisit = new ArrayDeque<BasicBlock>();
        List<InvokeDirect> valueInitializers = definition.isArgument() ? this.thisInitializers : this.initializers.get(definition.asNewInstance());
        for (InvokeDirect initializer : valueInitializers) {
            BasicBlock initializerBlock = initializer.getBlock();
            if (initializerBlock == liveBlock) {
                return res;
            }
            if (initializerBlock == definitionBlock || !visited.add(initializerBlock)) continue;
            toVisit.addLast(initializerBlock);
        }
        while (!toVisit.isEmpty()) {
            BasicBlock block = (BasicBlock)toVisit.removeLast();
            for (BasicBlock predecessor : block.getPredecessors()) {
                if (predecessor == liveBlock) {
                    return res;
                }
                if (predecessor == definitionBlock || !visited.add(predecessor)) continue;
                toVisit.addLast(predecessor);
            }
        }
        return null;
    }

    private void emitLabel(CfLabel label) {
        if (!this.emittedLabels.contains(label)) {
            this.emittedLabels.add(label);
            this.instructions.add(label);
        }
    }

    public CfLabel getLabel(BasicBlock target) {
        return this.labels.computeIfAbsent(target, block -> new CfLabel());
    }

    public int getLocalRegister(Value value) {
        return this.registerAllocator.getRegisterForValue(value);
    }

    public void add(CfInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void addArgument(Argument argument) {
    }

    private static class StackHeightTracker {
        int maxHeight = 0;
        int height = 0;

        private StackHeightTracker() {
        }

        boolean isEmpty() {
            return this.height == 0;
        }

        void push(Value value) {
            assert (value instanceof StackValue);
            this.height += value.requiredRegisters();
            this.maxHeight = Math.max(this.maxHeight, this.height);
        }

        void pop(Value value) {
            assert (value.isValueOnStack());
            this.height -= value.requiredRegisters();
        }

        void setHeight(int height) {
            assert (height <= this.maxHeight);
            this.height = height;
        }
    }
}

