/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.base.Supplier;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.analysis.InitializedClassesOnNormalExitAnalysis;
import com.android.tools.r8.ir.analysis.TypeChecker;
import com.android.tools.r8.ir.analysis.constant.SparseConditionalConstantPropagation;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.AlwaysMaterializingDefinition;
import com.android.tools.r8.ir.code.AlwaysMaterializingUser;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.MethodProcessingOrder;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackDelayed;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.desugar.CovariantReturnTypeAnnotationTransformer;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.Java8MethodRewriter;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.desugar.NestBasedAccessDesugaringRewriter;
import com.android.tools.r8.ir.desugar.StringConcatRewriter;
import com.android.tools.r8.ir.desugar.TwrCloseResourceRewriter;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ConstantCanonicalizer;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Devirtualizer;
import com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import com.android.tools.r8.ir.optimize.IdempotentFunctionCallCanonicalizer;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MemberValuePropagation;
import com.android.tools.r8.ir.optimize.NonNullTracker;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import com.android.tools.r8.ir.optimize.RedundantFieldLoadElimination;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.ir.optimize.ServiceLoaderRewriter;
import com.android.tools.r8.ir.optimize.UninstantiatedTypeOptimization;
import com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import com.android.tools.r8.ir.optimize.staticizer.ClassStaticizer;
import com.android.tools.r8.ir.optimize.string.StringOptimizer;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.naming.IdentifierNameStringMarker;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.MainDexClasses;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IRConverter {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    public final AppView<?> appView;
    public final Set<DexType> mainDexClasses;
    private final Timing timing;
    private final Outliner outliner;
    private final ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization;
    private final DynamicTypeOptimization dynamicTypeOptimization;
    private final StringConcatRewriter stringConcatRewriter;
    private final LambdaRewriter lambdaRewriter;
    private final NestBasedAccessDesugaringRewriter nestBasedAccessDesugaringRewriter;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final TwrCloseResourceRewriter twrCloseResourceRewriter;
    private final Java8MethodRewriter java8MethodRewriter;
    private final LambdaMerger lambdaMerger;
    private final ClassInliner classInliner;
    private final ClassStaticizer classStaticizer;
    private final InternalOptions options;
    private final CfgPrinter printer;
    private final CodeRewriter codeRewriter;
    private final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final NonNullTracker nonNullTracker;
    private final Inliner inliner;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final Devirtualizer devirtualizer;
    private final CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer;
    private final StringOptimizer stringOptimizer;
    private final UninstantiatedTypeOptimization uninstantiatedTypeOptimization;
    private final TypeChecker typeChecker;
    private final IdempotentFunctionCallCanonicalizer idempotentFunctionCallCanonicalizer;
    private final ServiceLoaderRewriter serviceLoaderRewriter;
    final DeadCodeRemover deadCodeRemover;
    private final OptimizationFeedbackDelayed delayedOptimizationFeedback = new OptimizationFeedbackDelayed();
    private final OptimizationFeedback ignoreOptimizationFeedback = new OptimizationFeedbackIgnore();
    private final OptimizationFeedback simpleOptimizationFeedback = new OptimizationFeedbackSimple();
    private DexString highestSortingString;
    private List<Action> onWaveDoneActions = null;

    public IRConverter(AppView<?> appView, Timing timing, CfgPrinter printer, MainDexClasses mainDexClasses) {
        assert (((AppInfo)appView.appInfo()).hasLiveness() || appView.graphLense().isIdentityLense());
        assert (appView.options() != null);
        assert (appView.options().programConsumer != null);
        this.timing = timing != null ? timing : new Timing("internal");
        this.appView = appView;
        this.options = appView.options();
        this.printer = printer;
        this.mainDexClasses = mainDexClasses.getClasses();
        this.codeRewriter = new CodeRewriter(appView, this);
        this.classInitializerDefaultsOptimization = this.options.debug ? null : new ClassInitializerDefaultsOptimization(appView, this);
        this.stringConcatRewriter = new StringConcatRewriter(appView);
        this.lambdaRewriter = this.options.enableDesugaring ? new LambdaRewriter(appView, this) : null;
        this.interfaceMethodRewriter = this.options.isInterfaceMethodDesugaringEnabled() ? new InterfaceMethodRewriter(appView, this) : null;
        this.twrCloseResourceRewriter = this.options.enableDesugaring && this.enableTwrCloseResourceDesugaring() ? new TwrCloseResourceRewriter(appView, this) : null;
        this.java8MethodRewriter = this.options.enableDesugaring ? new Java8MethodRewriter(appView, this) : null;
        this.lambdaMerger = this.options.enableLambdaMerging ? new LambdaMerger(appView) : null;
        this.covariantReturnTypeAnnotationTransformer = this.options.processCovariantReturnTypeAnnotations ? new CovariantReturnTypeAnnotationTransformer(this, appView.dexItemFactory()) : null;
        this.stringOptimizer = new StringOptimizer(appView);
        NonNullTracker nonNullTracker = this.nonNullTracker = this.options.enableNonNullTracking ? new NonNullTracker(appView) : null;
        if (appView.enableWholeProgramOptimizations()) {
            assert (((AppInfo)appView.appInfo()).hasLiveness());
            assert (appView.rootSet() != null);
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
            this.classInliner = this.options.enableClassInlining && this.options.enableInlining ? new ClassInliner(this.lambdaRewriter) : null;
            this.classStaticizer = this.options.enableClassStaticizer ? new ClassStaticizer(appViewWithLiveness, this) : null;
            this.dynamicTypeOptimization = this.options.enableDynamicTypeOptimization ? new DynamicTypeOptimization(appViewWithLiveness) : null;
            this.lensCodeRewriter = new LensCodeRewriter(appViewWithLiveness, this.lambdaRewriter);
            this.inliner = new Inliner(appViewWithLiveness, mainDexClasses, this.lensCodeRewriter);
            this.outliner = new Outliner(appViewWithLiveness, this);
            this.memberValuePropagation = this.options.enableValuePropagation ? new MemberValuePropagation(appViewWithLiveness) : null;
            this.identifierNameStringMarker = !appInfoWithLiveness.identifierNameStrings.isEmpty() && this.options.isMinifying() ? new IdentifierNameStringMarker(appViewWithLiveness) : null;
            this.devirtualizer = this.options.enableDevirtualization ? new Devirtualizer(appViewWithLiveness) : null;
            this.uninstantiatedTypeOptimization = this.options.enableUninstantiatedTypeOptimization ? new UninstantiatedTypeOptimization(appViewWithLiveness) : null;
            this.typeChecker = new TypeChecker(appView.withLiveness());
            this.serviceLoaderRewriter = this.options.enableServiceLoaderRewriting ? new ServiceLoaderRewriter() : null;
            this.nestBasedAccessDesugaringRewriter = null;
        } else {
            this.classInliner = null;
            this.classStaticizer = null;
            this.dynamicTypeOptimization = null;
            this.inliner = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
            this.uninstantiatedTypeOptimization = null;
            this.typeChecker = null;
            this.serviceLoaderRewriter = null;
            this.nestBasedAccessDesugaringRewriter = this.options.enableNestBasedAccessDesugaring ? new NestBasedAccessDesugaringRewriter(appView) : null;
        }
        this.deadCodeRemover = new DeadCodeRemover(appView, this.codeRewriter);
        this.idempotentFunctionCallCanonicalizer = new IdempotentFunctionCallCanonicalizer(appView.dexItemFactory());
    }

    public Set<DexCallSite> getDesugaredCallSites() {
        if (this.lambdaRewriter != null) {
            return this.lambdaRewriter.getDesugaredCallSites();
        }
        return Collections.emptySet();
    }

    public IRConverter(AppView<?> appView) {
        this(appView, null, null, MainDexClasses.NONE);
    }

    public IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer) {
        this(AppView.createForD8(appInfo, options), timing, printer, MainDexClasses.NONE);
    }

    private boolean enableTwrCloseResourceDesugaring() {
        return this.enableTryWithResourcesDesugaring() && !this.options.canUseTwrCloseResourceMethod();
    }

    private boolean enableTryWithResourcesDesugaring() {
        switch (this.options.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseSuppressedExceptions();
            }
        }
        throw new Unreachable();
    }

    private boolean removeLambdaDeserializationMethods() {
        if (this.lambdaRewriter != null) {
            return this.lambdaRewriter.removeLambdaDeserializationMethods(((AppInfo)this.appView.appInfo()).classes());
        }
        return false;
    }

    private void analyzeNests() {
        if (this.nestBasedAccessDesugaringRewriter != null) {
            this.nestBasedAccessDesugaringRewriter.analyzeNests();
        }
    }

    private void synthetizeNestConstructor(DexApplication.Builder<?> builder) {
        if (this.nestBasedAccessDesugaringRewriter != null) {
            this.nestBasedAccessDesugaringRewriter.synthetizeNestConstructor(builder);
        }
    }

    private void synthesizeLambdaClasses(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.adjustAccessibility();
            this.lambdaRewriter.synthesizeLambdaClasses(builder, executorService);
        }
    }

    private void staticizeClasses(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        if (this.classStaticizer != null) {
            this.classStaticizer.staticizeCandidates(feedback, executorService);
        }
    }

    private void collectStaticizerCandidates(DexApplication application) {
        if (this.classStaticizer != null) {
            this.classStaticizer.collectCandidates(application);
        }
    }

    private void desugarInterfaceMethods(DexApplication.Builder<?> builder, InterfaceMethodRewriter.Flavor includeAllResources, ExecutorService executorService) throws ExecutionException {
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.desugarInterfaceMethods(builder, includeAllResources, executorService);
        }
    }

    private void synthesizeTwrCloseResourceUtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.twrCloseResourceRewriter != null) {
            this.twrCloseResourceRewriter.synthesizeUtilityClass(builder, executorService, this.options);
        }
    }

    private void synthesizeJava8UtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.java8MethodRewriter != null) {
            this.java8MethodRewriter.synthesizeUtilityClass(builder, executorService, this.options);
        }
    }

    private void processCovariantReturnTypeAnnotations(DexApplication.Builder<?> builder) {
        if (this.covariantReturnTypeAnnotationTransformer != null) {
            this.covariantReturnTypeAnnotationTransformer.process(builder);
        }
    }

    public DexApplication convertToDex(DexApplication application, ExecutorService executor) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.analyzeNests();
        this.timing.begin("IR conversion");
        this.convertClassesToDex(application.classes(), executor);
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.synthetizeNestConstructor(builder);
        this.synthesizeLambdaClasses(builder, executor);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.ExcludeDexResources, executor);
        this.synthesizeTwrCloseResourceUtilityClass(builder, executor);
        this.synthesizeJava8UtilityClass(builder, executor);
        this.processCovariantReturnTypeAnnotations(builder);
        this.handleSynthesizedClassMapping(builder);
        this.timing.end();
        return builder.build();
    }

    private void handleSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        if (this.options.intermediate) {
            this.updateSynthesizedClassMapping(builder);
        }
        this.updateMainDexListWithSynthesizedClassMap(builder);
        if (!this.options.intermediate) {
            this.clearSynthesizedClassMapping(builder);
        }
    }

    private void updateMainDexListWithSynthesizedClassMap(DexApplication.Builder<?> builder) {
        Set<DexType> inputMainDexList = builder.getMainDexList();
        if (!inputMainDexList.isEmpty()) {
            Map programClasses = builder.getProgramClasses().stream().collect(Collectors.toMap(programClass -> programClass.type, Function.identity()));
            ArrayList<DexType> synthesized = new ArrayList<DexType>();
            for (DexType dexType : inputMainDexList) {
                DexProgramClass programClass2 = (DexProgramClass)programClasses.get(dexType);
                if (programClass2 == null) continue;
                synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(programClass2, builder.dexItemFactory));
            }
            builder.addToMainDexList(synthesized);
        }
    }

    private void clearSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        for (DexProgramClass programClass : builder.getProgramClasses()) {
            programClass.annotations = programClass.annotations.getWithout(builder.dexItemFactory.annotationSynthesizedClassMap);
        }
    }

    private void updateSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        ArrayListMultimap<DexProgramClass, DexProgramClass> originalToSynthesized = ArrayListMultimap.create();
        for (DexProgramClass dexProgramClass2 : builder.getSynthesizedClasses()) {
            for (DexProgramClass original : dexProgramClass2.getSynthesizedFrom()) {
                originalToSynthesized.put(original, dexProgramClass2);
            }
        }
        for (Map.Entry entry : originalToSynthesized.asMap().entrySet()) {
            DexProgramClass original = (DexProgramClass)entry.getKey();
            TreeSet<DexType> synthesized = new TreeSet<DexType>(DexType::slowCompareTo);
            ((Collection)entry.getValue()).stream().map(dexProgramClass -> dexProgramClass.type).forEach(synthesized::add);
            synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(original, builder.dexItemFactory));
            DexAnnotation updatedAnnotation = DexAnnotation.createAnnotationSynthesizedClassMap(synthesized, builder.dexItemFactory);
            original.annotations = original.annotations.getWithAddedOrReplaced(updatedAnnotation);
        }
    }

    private void convertClassesToDex(Iterable<DexProgramClass> classes, ExecutorService executor) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (DexProgramClass clazz : classes) {
            futures.add(executor.submit(() -> this.convertMethodsToDex(clazz)));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void convertMethodsToDex(DexProgramClass clazz) {
        boolean isReachabilitySensitive = clazz.hasReachabilitySensitiveAnnotation(this.options.itemFactory);
        for (DexEncodedMethod method2 : clazz.directMethods()) {
            if (!method2.isClassInitializer()) continue;
            method2.getMutableOptimizationInfo().setReachabilitySensitive(isReachabilitySensitive);
            this.convertMethodToDex(method2);
            break;
        }
        clazz.forEachMethod(method -> {
            if (!method.isClassInitializer()) {
                method.getMutableOptimizationInfo().setReachabilitySensitive(isReachabilitySensitive);
                this.convertMethodToDex((DexEncodedMethod)method);
            }
        });
    }

    private void convertMethodToDex(DexEncodedMethod method) {
        boolean matchesMethodFilter;
        assert (this.options.isGeneratingDex());
        if (method.getCode() != null && (matchesMethodFilter = this.options.methodMatchesFilter(method))) {
            if (!this.options.passthroughDexCode || !method.getCode().isDexCode()) {
                this.rewriteCode(method, this.simpleOptimizationFeedback, x -> true, CallSiteInformation.empty(), Outliner::noProcessing);
            }
            this.updateHighestSortingStrings(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication optimize(DexApplication application) throws ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.optimize(application, executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public DexApplication optimize(DexApplication application, ExecutorService executorService) throws ExecutionException {
        AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
        if (this.options.isShrinking()) {
            assert (!this.removeLambdaDeserializationMethods());
        } else {
            this.removeLambdaDeserializationMethods();
        }
        this.computeReachabilitySensitivity(application);
        this.collectLambdaMergingCandidates(application);
        this.collectStaticizerCandidates(application);
        this.printPhase("Primary optimization pass");
        GraphLense graphLenseForIR = this.appView.graphLense();
        OptimizationFeedbackDelayed feedback = this.delayedOptimizationFeedback;
        this.timing.begin("Build call graph");
        CallGraph callGraph = CallGraph.builder(this.appView.withLiveness()).build(executorService, this.timing);
        CallSiteInformation callSiteInformation = callGraph.createCallSiteInformation(appViewWithLiveness);
        MethodProcessingOrder methodProcessingOrder = callGraph.createMethodProcessingOrder(this.appView);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        BiConsumer<IRCode, DexEncodedMethod> outlineHandler = this.outliner == null ? Outliner::noProcessing : this.outliner.identifyCandidateMethods();
        methodProcessingOrder.forEachMethod((method, isProcessedConcurrently) -> this.processMethod((DexEncodedMethod)method, feedback, (Predicate<DexEncodedMethod>)isProcessedConcurrently, callSiteInformation, outlineHandler), this::waveStart, this::waveDone, executorService);
        this.timing.end();
        assert (graphLenseForIR == this.appView.graphLense());
        if (this.inliner != null) {
            this.printPhase("Double caller inlining");
            assert (graphLenseForIR == this.appView.graphLense());
            this.inliner.processDoubleInlineCallers(this, executorService, feedback);
            feedback.updateVisibleOptimizationInfo();
            assert (graphLenseForIR == this.appView.graphLense());
        }
        if (!this.options.isGeneratingClassFiles()) {
            this.printPhase("Class staticizer post processing");
            this.staticizeClasses(feedback, executorService);
        }
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.printPhase("Lambda class synthesis");
        this.synthesizeLambdaClasses(builder, executorService);
        this.printPhase("Interface method desugaring");
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.IncludeAllResources, executorService);
        this.printPhase("Twr close resource utility class synthesis");
        this.synthesizeTwrCloseResourceUtilityClass(builder, executorService);
        this.synthesizeJava8UtilityClass(builder, executorService);
        this.handleSynthesizedClassMapping(builder);
        this.printPhase("Lambda merging finalization");
        this.finalizeLambdaMerging(application, feedback, builder, executorService);
        if (this.outliner != null) {
            this.printPhase("Outlining");
            this.timing.begin("IR conversion phase 2");
            if (this.outliner.selectMethodsForOutlining()) {
                this.forEachSelectedOutliningMethod(executorService, (code, method) -> {
                    this.printMethod((IRCode)code, "IR before outlining (SSA)", null);
                    this.outliner.identifyOutlineSites((IRCode)code, (DexEncodedMethod)method);
                });
                DexProgramClass outlineClass = this.outliner.buildOutlinerClass(this.computeOutlineClassType());
                ((AppInfo)this.appView.appInfo()).addSynthesizedClass(outlineClass);
                this.optimizeSynthesizedClass(outlineClass, executorService);
                this.forEachSelectedOutliningMethod(executorService, (code, method) -> {
                    this.outliner.applyOutliningCandidate((IRCode)code, (DexEncodedMethod)method);
                    this.printMethod((IRCode)code, "IR after outlining (SSA)", null);
                    this.finalizeIR((DexEncodedMethod)method, (IRCode)code, this.ignoreOptimizationFeedback);
                });
                assert (this.outliner.checkAllOutlineSitesFoundAgain());
                builder.addSynthesizedClass(outlineClass, true);
                this.clearDexMethodCompilationState(outlineClass);
            }
            this.timing.end();
        }
        this.clearDexMethodCompilationState();
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInFields();
        }
        assert (((AppInfo)this.appView.appInfo()).getSynthesizedClassesForSanityCheck().containsAll(builder.getSynthesizedClasses()) && builder.getSynthesizedClasses().containsAll(((AppInfo)this.appView.appInfo()).getSynthesizedClassesForSanityCheck()));
        return builder.build();
    }

    private void waveStart() {
        this.onWaveDoneActions = Collections.synchronizedList(new ArrayList());
    }

    private void waveDone() {
        this.delayedOptimizationFeedback.updateVisibleOptimizationInfo();
        this.onWaveDoneActions.forEach(Action::execute);
        this.onWaveDoneActions = null;
    }

    public void addWaveDoneAction(Action action) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            throw new Unreachable("addWaveDoneAction() should never be used in D8.");
        }
        if (!this.isInWave()) {
            throw new Unreachable("Attempt to call addWaveDoneAction() outside of wave.");
        }
        this.onWaveDoneActions.add(action);
    }

    public boolean isInWave() {
        return this.onWaveDoneActions != null;
    }

    private void computeReachabilitySensitivity(DexApplication application) {
        application.classes().forEach(c -> {
            if (c.hasReachabilitySensitiveAnnotation(this.options.itemFactory)) {
                c.methods().forEach(m -> m.getMutableOptimizationInfo().setReachabilitySensitive(true));
            }
        });
    }

    private void forEachSelectedOutliningMethod(ExecutorService executorService, BiConsumer<IRCode, DexEncodedMethod> consumer) throws ExecutionException {
        assert (!this.options.skipIR);
        Set<DexEncodedMethod> methods = this.outliner.getMethodsSelectedForOutlining();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexEncodedMethod method : methods) {
            futures.add(executorService.submit(() -> {
                IRCode code = method.buildIR(this.appView, ((AppInfo)this.appView.appInfo()).originFor(method.method.holder));
                assert (code != null);
                assert (!method.getCode().isOutlineCode());
                this.codeRewriter.rewriteMoveResult(code);
                this.deadCodeRemover.run(code);
                consumer.accept(code, method);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void collectLambdaMergingCandidates(DexApplication application) {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.collectGroupCandidates(application, this.appView.withLiveness());
        }
    }

    private void finalizeLambdaMerging(DexApplication application, OptimizationFeedback feedback, DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.applyLambdaClassMapping(application, this, feedback, builder, executorService);
        }
    }

    private void clearDexMethodCompilationState() {
        ((AppInfo)this.appView.appInfo()).classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    public void replaceCodeForTesting(DexEncodedMethod method, IRCode code) {
        assert (code.isConsistentSSA());
        code.traceBlocks();
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
    }

    private DexType computeOutlineClassType() {
        String name;
        DexType result;
        int count = 0;
        do {
            name = "com.android.tools.r8.GeneratedOutlineSupport" + (count == 0 ? "" : Integer.toString(count));
            ++count;
        } while (this.appView.definitionFor(result = this.appView.dexItemFactory().createType(DescriptorUtils.javaTypeToDescriptor(name))) != null);
        ((AppInfo)this.appView.appInfo()).registerNewType(result, this.appView.dexItemFactory().objectType);
        return result;
    }

    public void optimizeSynthesizedClass(DexProgramClass clazz, ExecutorService executorService) throws ExecutionException {
        Set<DexEncodedMethod> methods = Sets.newIdentityHashSet();
        clazz.forEachMethod(methods::add);
        this.optimizeSynthesizedMethodsConcurrently(methods, executorService);
    }

    public void optimizeSynthesizedClasses(Collection<DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        Set<DexEncodedMethod> methods = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(methods::add);
        }
        this.optimizeSynthesizedMethodsConcurrently(methods, executorService);
    }

    public void optimizeSynthesizedMethod(DexEncodedMethod method) {
        if (!method.isProcessed()) {
            this.processMethod(method, this.delayedOptimizationFeedback, Predicates.alwaysFalse(), CallSiteInformation.empty(), Outliner::noProcessing);
        }
    }

    public void optimizeSynthesizedMethodsConcurrently(Collection<DexEncodedMethod> methods, ExecutorService executorService) throws ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexEncodedMethod method : methods) {
            futures.add(executorService.submit(() -> {
                this.processMethod(method, this.delayedOptimizationFeedback, methods::contains, CallSiteInformation.empty(), Outliner::noProcessing);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    public void processMethod(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        Code code = method.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(method);
        if (code != null && matchesMethodFilter) {
            this.rewriteCode(method, feedback, isProcessedConcurrently, callSiteInformation, outlineHandler);
        } else {
            method.markProcessed(Inliner.ConstraintWithTarget.NEVER);
        }
    }

    private static void invertConditionalsForTesting(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.exit().isIf()) continue;
            block.exit().asIf().invert();
        }
    }

    private void rewriteCode(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        boolean isDebugMode;
        if (this.options.verbose) {
            this.options.reporter.info(new StringDiagnostic("Processing: " + method.toSourceString()));
        }
        if (this.options.skipIR) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        IRCode code = method.buildIR(this.appView, ((AppInfo)this.appView.appInfo()).originFor(method.method.holder));
        if (code == null) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        this.printC1VisualizerHeader(method);
        String previous = this.printMethod(code, "Initial IR (SSA)", null);
        if (this.options.testing.irModifier != null) {
            this.options.testing.irModifier.accept(code);
        }
        if (this.options.canHaveArtStringNewInitBug()) {
            CodeRewriter.ensureDirectStringNewToInit(code, this.appView.dexItemFactory());
        }
        boolean bl = isDebugMode = this.options.debug || method.getOptimizationInfo().isReachabilitySensitive();
        if (isDebugMode) {
            this.codeRewriter.simplifyDebugLocals(code);
        }
        if (!method.isProcessed()) {
            if (this.lensCodeRewriter != null) {
                this.lensCodeRewriter.rewrite(code, method);
            } else {
                assert (this.appView.graphLense().isIdentityLense());
                if (this.lambdaRewriter != null && this.options.testing.desugarLambdasThroughLensCodeRewriter()) {
                    this.lambdaRewriter.desugarLambdas(method, code);
                    assert (code.isConsistentSSA());
                }
            }
        }
        if (this.typeChecker != null && !this.typeChecker.check(code)) {
            assert (this.appView.enableWholeProgramOptimizations());
            assert (this.options.testing.allowTypeErrors);
            StringDiagnostic warning = new StringDiagnostic("The method `" + method.toSourceString() + "` does not type check and will be assumed to be unreachable.");
            this.options.reporter.warning(warning);
            this.finalizeEmptyThrowingCode(method, feedback);
            return;
        }
        assert (code.verifyTypes(this.appView));
        if (this.serviceLoaderRewriter != null) {
            assert (((AppInfo)this.appView.appInfo()).hasLiveness());
            ServiceLoaderRewriter.rewrite(code, this.appView.withLiveness());
        }
        if (this.classStaticizer != null) {
            this.classStaticizer.fixupMethodCode(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after class staticizer (SSA)", previous);
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInMethod(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.memberValuePropagation != null) {
            this.memberValuePropagation.rewriteWithConstantValues(code, method.method.holder, isProcessedConcurrently);
        }
        if (this.options.enableSwitchMapRemoval) {
            assert (this.appView.enableWholeProgramOptimizations());
            this.codeRewriter.removeSwitchMaps(code);
        }
        if (this.options.disableAssertions) {
            this.codeRewriter.disableAssertions(this.appView, method, code, feedback);
        }
        previous = this.printMethod(code, "IR after disable assertions (SSA)", previous);
        if (this.nonNullTracker != null) {
            this.nonNullTracker.addNonNull(code);
            assert (code.isConsistentSSA());
        }
        if (this.dynamicTypeOptimization != null) {
            assert (this.appView.enableWholeProgramOptimizations());
            this.dynamicTypeOptimization.insertAssumeDynamicTypeInstructions(code);
        }
        previous = this.printMethod(code, "IR after null tracking (SSA)", previous);
        if (!isDebugMode && this.options.enableInlining && this.inliner != null) {
            this.inliner.performInlining(method, code, isProcessedConcurrently, callSiteInformation);
        }
        previous = this.printMethod(code, "IR after inlining (SSA)", previous);
        if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
            ReflectionOptimizer.rewriteGetClass(this.appView.withLiveness(), code);
        }
        if (!isDebugMode) {
            if (this.options.enableNameReflectionOptimization || this.options.testing.forceNameReflectionOptimization) {
                this.stringOptimizer.rewriteClassGetName(this.appView, code);
            }
            this.stringOptimizer.computeTrivialOperationsOnConstString(code);
            this.stringOptimizer.removeTrivialConversions(code);
            assert (code.isConsistentSSA());
        }
        if (this.devirtualizer != null) {
            assert (code.verifyTypes(this.appView));
            this.devirtualizer.devirtualizeInvokeInterface(code, method.method.holder);
        }
        if (this.uninstantiatedTypeOptimization != null) {
            this.uninstantiatedTypeOptimization.rewrite(code);
        }
        assert (code.verifyTypes(this.appView));
        this.codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
        this.codeRewriter.rewriteLongCompareAndRequireNonNull(code, this.options);
        this.codeRewriter.commonSubexpressionElimination(code);
        this.codeRewriter.simplifyArrayConstruction(code);
        this.codeRewriter.rewriteMoveResult(code);
        this.codeRewriter.splitRangeInvokeConstants(code);
        new SparseConditionalConstantPropagation(code).run();
        this.codeRewriter.rewriteSwitch(code);
        this.codeRewriter.processMethodsNeverReturningNormally(code);
        this.codeRewriter.simplifyIf(code);
        new RedundantFieldLoadElimination(this.appView, code).run();
        if (this.options.testing.invertConditionals) {
            IRConverter.invertConditionalsForTesting(code);
        }
        if (this.nonNullTracker != null) {
            this.nonNullTracker.computeNonNullParamOnNormalExits(feedback, code);
            assert (code.isConsistentSSA());
        }
        if (this.nonNullTracker != null || this.dynamicTypeOptimization != null) {
            this.codeRewriter.removeAssumeInstructions(code);
        }
        if (this.classInitializerDefaultsOptimization != null && !isDebugMode) {
            this.classInitializerDefaultsOptimization.optimize(method, code);
        }
        this.deadCodeRemover.run(code);
        assert (code.isConsistentSSA());
        if (this.options.enableDesugaring && this.enableTryWithResourcesDesugaring()) {
            this.codeRewriter.rewriteThrowableAddAndGetSuppressed(code);
        }
        if (this.java8MethodRewriter != null) {
            this.java8MethodRewriter.desugar(code);
        }
        this.stringConcatRewriter.desugarStringConcats(method.method, code);
        if (this.options.testing.desugarLambdasThroughLensCodeRewriter()) {
            assert (!this.options.enableDesugaring || this.lambdaRewriter.verifyNoLambdasToDesugar(code));
        } else if (this.lambdaRewriter != null) {
            this.lambdaRewriter.desugarLambdas(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after lambda desugaring (SSA)", previous);
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR before class inlining (SSA)", previous);
        if (this.classInliner != null) {
            assert (this.options.enableInlining && this.inliner != null);
            this.classInliner.processMethodCode(this.appView.withLiveness(), this.codeRewriter, this.stringOptimizer, method, code, isProcessedConcurrently, this.inliner, Suppliers.memoize(() -> this.inliner.createDefaultOracle(method, code, isProcessedConcurrently, callSiteInformation, 0x3FFFFFFF, 0x3FFFFFFF)));
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after class inlining (SSA)", previous);
        if (this.nestBasedAccessDesugaringRewriter != null) {
            this.nestBasedAccessDesugaringRewriter.rewriteNestBasedAccesses(method, code, this.appView);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after nest based access desugaring (SSA)", previous);
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.rewriteMethodReferences(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after interface method rewriting (SSA)", previous);
        if (this.twrCloseResourceRewriter != null) {
            this.twrCloseResourceRewriter.rewriteMethodCode(code);
        }
        previous = this.printMethod(code, "IR after twr close resource rewriter (SSA)", previous);
        if (this.lambdaMerger != null) {
            this.lambdaMerger.processMethodCode(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after lambda merger (SSA)", previous);
        if (this.options.outline.enabled) {
            outlineHandler.accept(code, method);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after outline handler (SSA)", previous);
        if (!this.options.isGeneratingClassFiles()) {
            ConstantCanonicalizer.canonicalize(this.appView, code);
            this.codeRewriter.useDedicatedConstantForLitInstruction(code);
            this.codeRewriter.shortenLiveRanges(code);
        }
        this.idempotentFunctionCallCanonicalizer.canonicalize(code);
        previous = this.printMethod(code, "IR after idempotent function call canonicalization (SSA)", previous);
        if (this.options.methodMatchesLogArgumentsFilter(method)) {
            this.codeRewriter.logArgumentTypes(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after argument type logging (SSA)", previous);
        if (this.classStaticizer != null) {
            this.classStaticizer.examineMethodCode(method, code);
        }
        if (this.appView.enableWholeProgramOptimizations() && !((AppInfo)this.appView.appInfo()).withLiveness().isPinned(method.method)) {
            this.codeRewriter.identifyClassInlinerEligibility(method, code, feedback);
            this.codeRewriter.identifyParameterUsages(method, code, feedback);
            this.codeRewriter.identifyReturnsArgument(method, code, feedback);
            this.codeRewriter.identifyTrivialInitializer(method, code, feedback);
            if (this.options.enableInlining && this.inliner != null) {
                this.codeRewriter.identifyInvokeSemanticsForInlining(method, code, this.appView, feedback);
            }
            this.computeDynamicReturnType(feedback, method, code);
            this.computeInitializedClassesOnNormalExit(feedback, method, code);
            this.computeMayHaveSideEffects(feedback, method, code);
            this.computeNonNullParamOrThrow(feedback, method, code);
        }
        previous = this.printMethod(code, "IR after computation of optimization info summary (SSA)", previous);
        if (this.options.canHaveNumberConversionRegisterAllocationBug()) {
            this.codeRewriter.workaroundNumberConversionRegisterAllocationBug(code);
        }
        if (method.getOptimizationInfo().useIdentifierNameString()) {
            feedback.markUseIdentifierNameString(method);
        } else assert (Streams.stream(code.instructionIterator()).noneMatch(Instruction::isDexItemBasedConstString));
        this.printMethod(code, "Optimized IR (SSA)", previous);
        this.finalizeIR(method, code, feedback);
    }

    private void computeNonNullParamOrThrow(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (method.getOptimizationInfo().getNonNullParamOrThrow() != null) {
            return;
        }
        List<Value> arguments = code.collectArguments();
        BitSet paramsCheckedForNull = new BitSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument = arguments.get(index);
            if (!argument.isUsed() || !CodeRewriter.checksNullBeforeSideEffect(code, argument, this.appView)) continue;
            paramsCheckedForNull.set(index);
        }
        if (paramsCheckedForNull.length() > 0) {
            BitSet hintFromMetadata;
            KotlinInfo kotlinInfo;
            DexMethod originalSignature = this.appView.graphLense().getOriginalMethodSignature(method.method);
            DexClass originalHolder = this.appView.definitionFor(this.appView.graphLense().lookupType(originalSignature.holder));
            if (!(originalHolder.hasKotlinInfo() && (kotlinInfo = originalHolder.getKotlinInfo()).hasNonNullParameterHints() && (hintFromMetadata = kotlinInfo.lookupNonNullParameterHint(originalSignature.name.toString(), originalSignature.proto.toDescriptorString())) != null && hintFromMetadata.length() > 0 && paramsCheckedForNull.equals(hintFromMetadata))) {
                // empty if block
            }
            feedback.setNonNullParamOrThrow(method, paramsCheckedForNull);
        }
    }

    private void computeDynamicReturnType(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (this.dynamicTypeOptimization != null) {
            DexType staticReturnTypeRaw = method.method.proto.returnType;
            if (!staticReturnTypeRaw.isReferenceType()) {
                return;
            }
            TypeLatticeElement dynamicReturnType = this.dynamicTypeOptimization.computeDynamicReturnType(method, code);
            if (dynamicReturnType == null) {
                return;
            }
            TypeLatticeElement staticReturnType = TypeLatticeElement.fromDexType(staticReturnTypeRaw, Nullability.maybeNull(), this.appView);
            if (dynamicReturnType.strictlyLessThan(staticReturnType, this.appView)) {
                feedback.methodReturnsObjectOfType(method, dynamicReturnType);
            }
        }
    }

    private void computeInitializedClassesOnNormalExit(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        Set<DexType> initializedClasses;
        if (this.options.enableInitializedClassesAnalysis && ((AppInfo)this.appView.appInfo()).hasLiveness() && (initializedClasses = InitializedClassesOnNormalExitAnalysis.computeInitializedClassesOnNormalExit(appViewWithLiveness = this.appView.withLiveness(), code)) != null && !initializedClasses.isEmpty()) {
            feedback.methodInitializesClassesOnNormalExit(method, initializedClasses);
        }
    }

    private void computeMayHaveSideEffects(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (this.options.enableSideEffectAnalysis && !((AppInfo)this.appView.appInfo()).withLiveness().mayHaveSideEffects.containsKey(method.method)) {
            boolean mayHaveSideEffects;
            boolean bl = mayHaveSideEffects = method.accessFlags.isSynchronized() || this.appView.dexItemFactory().isConstructor(method.method) && this.hasNonTrivialFinalizeMethod(method.method.holder) || Streams.stream(code.instructions()).anyMatch(instruction -> instruction.instructionMayHaveSideEffects(this.appView, method.method.holder));
            if (!mayHaveSideEffects) {
                feedback.methodMayNotHaveSideEffects(method);
            }
        }
    }

    private boolean hasNonTrivialFinalizeMethod(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz != null) {
            if (clazz.isProgramClass()) {
                AppInfo.ResolutionResult resolutionResult = ((AppInfo)this.appView.appInfo()).resolveMethodOnClass(type, this.appView.dexItemFactory().objectMethods.finalize);
                for (DexEncodedMethod target : resolutionResult.asListOfTargets()) {
                    if (target.method == this.appView.dexItemFactory().objectMethods.finalize) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void finalizeIR(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        code.traceBlocks();
        if (this.options.isGeneratingClassFiles()) {
            this.finalizeToCf(method, code, feedback);
        } else {
            assert (this.options.isGeneratingDex());
            this.finalizeToDex(method, code, feedback);
        }
    }

    private void finalizeEmptyThrowingCode(DexEncodedMethod method, OptimizationFeedback feedback) {
        assert (this.options.isGeneratingClassFiles() || this.options.isGeneratingDex());
        Code emptyThrowingCode = this.options.isGeneratingClassFiles() ? method.buildEmptyThrowingCfCode() : method.buildEmptyThrowingDexCode();
        method.setCode(emptyThrowingCode);
        feedback.markProcessed(method, Inliner.ConstraintWithTarget.ALWAYS);
    }

    private void finalizeToCf(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        assert (!method.getCode().isDexCode());
        CfBuilder builder = new CfBuilder(this.appView, method, code);
        CfCode result = builder.build(this.codeRewriter);
        method.setCode(result);
        this.markProcessed(method, code, feedback);
    }

    private void finalizeToDex(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        CodeRewriter.disableDex2OatInliningForSelfRecursiveMethods(this.appView, code);
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
        this.updateHighestSortingStrings(method);
        this.printMethod(code, "Final IR (non-SSA)", null);
        this.markProcessed(method, code, feedback);
    }

    private void markProcessed(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Inliner.ConstraintWithTarget state = !this.options.enableInlining || this.inliner == null || method.getOptimizationInfo().isReachabilitySensitive() ? Inliner.ConstraintWithTarget.NEVER : this.inliner.computeInliningConstraint(code, method);
        feedback.markProcessed(method, state);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        DexString highestSortingReferencedString = method.getCode().asDexCode().highestSortingString;
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.slowCompareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method) {
        this.deadCodeRemover.run(code);
        this.materializeInstructionBeforeLongOperationsWorkaround(code);
        this.workaroundForwardingInitializerBug(code);
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(this.appView, code);
        registerAllocator.allocateRegisters();
        if (this.options.canHaveExceptionTargetingLoopHeaderBug()) {
            this.codeRewriter.workaroundExceptionTargetingLoopHeaderBug(code);
        }
        this.printMethod(code, "After register allocation (non-SSA)", null);
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapseTrivialGotos(method, code);
            PeepholeOptimizer.optimize(code, registerAllocator);
        }
        CodeRewriter.removeUnneededMovesOnExitingPaths(code, registerAllocator);
        CodeRewriter.collapseTrivialGotos(method, code);
        return registerAllocator;
    }

    private void workaroundForwardingInitializerBug(IRCode code) {
        if (!this.options.canHaveForwardingInitInliningBug()) {
            return;
        }
        if (!code.method.isInstanceInitializer()) {
            return;
        }
        DexTypeList paramTypes = code.method.method.proto.parameters;
        if (paramTypes.size() != 3 || paramTypes.values[0] != this.options.itemFactory.doubleType || paramTypes.values[1] != this.options.itemFactory.doubleType || !paramTypes.values[2].isClassType()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            Instruction superConstructorCall = it.nextUntil(i -> i.isInvokeDirect() && i.asInvokeDirect().getInvokedMethod().name == this.options.itemFactory.constructorMethodName && i.asInvokeDirect().arguments().size() == 4 && i.asInvokeDirect().arguments().stream().allMatch(Value::isArgument));
            if (superConstructorCall == null) continue;
            IRConverter.ensureInstructionBefore(code, superConstructorCall, it);
            break;
        }
    }

    private void materializeInstructionBeforeLongOperationsWorkaround(IRCode code) {
        if (!this.options.canHaveDex2OatLinkedListBug()) {
            return;
        }
        DexItemFactory factory = this.options.itemFactory;
        Supplier<DexMethod> javaLangLangSignum = Suppliers.memoize(() -> factory.createMethod(factory.createString("Ljava/lang/Long;"), factory.createString("signum"), factory.intDescriptor, new DexString[]{factory.longDescriptor}));
        for (BasicBlock block : code.blocks) {
            Instruction secondMaterializing;
            InstructionListIterator it = block.listIterator();
            Instruction firstMaterializing = it.nextUntil(IRConverter::isNotPseudoInstruction);
            if (!IRConverter.isLongMul(firstMaterializing) || !IRConverter.isLongAddOrSub(secondMaterializing = it.nextUntil(IRConverter::isNotPseudoInstruction)) || IRConverter.isFallthoughTarget(block)) continue;
            Value outOfMul = firstMaterializing.outValue();
            for (Value inOfAddOrSub : secondMaterializing.inValues()) {
                if (!IRConverter.isAliasOf(inOfAddOrSub, outOfMul)) continue;
                it = block.listIterator();
                it.nextUntil(i -> i == firstMaterializing);
                Value longValue = firstMaterializing.inValues().get(0);
                InvokeStatic invokeLongSignum = new InvokeStatic((DexMethod)javaLangLangSignum.get(), null, Collections.singletonList(longValue));
                this.ensureThrowingInstructionBefore(code, firstMaterializing, it, invokeLongSignum);
                return;
            }
        }
    }

    private static boolean isAliasOf(Value usedValue, Value definingValue) {
        while (usedValue != definingValue) {
            Instruction definition = usedValue.definition;
            if (definition == null || !definition.isMove()) {
                return false;
            }
            usedValue = definition.asMove().src();
        }
        return true;
    }

    private static boolean isNotPseudoInstruction(Instruction instruction) {
        return !instruction.isDebugInstruction() && !instruction.isMove();
    }

    private static boolean isLongMul(Instruction instruction) {
        return instruction != null && instruction.isMul() && instruction.asBinop().getNumericType() == NumericType.LONG && instruction.outValue() != null;
    }

    private static boolean isLongAddOrSub(Instruction instruction) {
        return instruction != null && (instruction.isAdd() || instruction.isSub()) && instruction.asBinop().getNumericType() == NumericType.LONG;
    }

    private static boolean isFallthoughTarget(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }

    private void ensureThrowingInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it, Instruction instruction) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        BasicBlock block = check.getBlock();
        if (block.hasCatchHandlers()) {
            BasicBlock split = it.split(code);
            assert (split.hasCatchHandlers());
            assert (!block.hasCatchHandlers());
            it = block.listIterator(block.getInstructions().size() - 1);
        }
        instruction.setPosition(addBefore.getPosition());
        it.add(instruction);
    }

    private static void ensureInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        Value fixitValue = code.createValue(TypeLatticeElement.INT);
        AlwaysMaterializingDefinition fixitDefinition = new AlwaysMaterializingDefinition(fixitValue);
        fixitDefinition.setBlock(addBefore.getBlock());
        fixitDefinition.setPosition(addBefore.getPosition());
        it.add(fixitDefinition);
        AlwaysMaterializingUser fixitUser = new AlwaysMaterializingUser(fixitValue);
        fixitUser.setBlock(addBefore.getBlock());
        fixitUser.setPosition(addBefore.getPosition());
        it.add(fixitUser);
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    private void printPhase(String phase) {
        if (!this.options.extensiveLoggingFilter.isEmpty()) {
            System.out.println("Entering phase: " + phase);
        }
    }

    private String printMethod(IRCode code, String title, String previous) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
        if (this.options.extensiveLoggingFilter.contains(code.method.method.toSourceString())) {
            String current = code.toString();
            System.out.println();
            System.out.println("-----------------------------------------------------------------------");
            System.out.println(title);
            System.out.println("-----------------------------------------------------------------------");
            if (previous != null && previous.equals(current)) {
                System.out.println("Unchanged");
            } else {
                System.out.println(current);
            }
            System.out.println("-----------------------------------------------------------------------");
            return current;
        }
        return previous;
    }
}

