/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.IROrdering;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.ThrowingBiConsumer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public class MethodProcessingOrder {
    private final Deque<Collection<DexEncodedMethod>> waves;

    MethodProcessingOrder(AppView<?> appView, CallGraph callGraph) {
        this.waves = MethodProcessingOrder.createWaves(appView, callGraph);
    }

    public static Deque<Collection<DexEncodedMethod>> createWaves(AppView<?> appView, CallGraph callGraph) {
        IROrdering shuffle = appView.options().testing.irOrdering;
        ArrayDeque<Collection<DexEncodedMethod>> waves = new ArrayDeque<Collection<DexEncodedMethod>>();
        Set<CallGraph.Node> nodes = callGraph.nodes;
        while (!nodes.isEmpty()) {
            waves.addLast(shuffle.order((Collection<DexEncodedMethod>)MethodProcessingOrder.extractLeaves(nodes)));
        }
        return waves;
    }

    private static Set<DexEncodedMethod> extractLeaves(Set<CallGraph.Node> nodes) {
        Set<DexEncodedMethod> leaves = Sets.newIdentityHashSet();
        Set<CallGraph.Node> removed = Sets.newIdentityHashSet();
        Iterator<CallGraph.Node> nodeIterator = nodes.iterator();
        while (nodeIterator.hasNext()) {
            CallGraph.Node node = nodeIterator.next();
            if (!node.isLeaf()) continue;
            leaves.add(node.method);
            nodeIterator.remove();
            removed.add(node);
        }
        removed.forEach(CallGraph.Node::cleanForRemoval);
        return leaves;
    }

    public <E extends Exception> void forEachMethod(ThrowingBiConsumer<DexEncodedMethod, Predicate<DexEncodedMethod>, E> consumer, Action waveStart, Action waveDone, ExecutorService executorService) throws ExecutionException {
        while (!this.waves.isEmpty()) {
            Collection<DexEncodedMethod> wave = this.waves.removeFirst();
            assert (wave.size() > 0);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            waveStart.execute();
            for (DexEncodedMethod method : wave) {
                futures.add(executorService.submit(() -> {
                    consumer.accept(method, wave::contains);
                    return null;
                }));
            }
            ThreadUtils.awaitFutures(futures);
            waveDone.execute();
        }
    }
}

