/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.graph.UpdatableOptimizationInfo;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class OptimizationFeedbackDelayed
implements OptimizationFeedback {
    private final Map<DexEncodedMethod, UpdatableOptimizationInfo> optimizationInfos = new IdentityHashMap<DexEncodedMethod, UpdatableOptimizationInfo>();
    private final Map<DexEncodedMethod, Inliner.ConstraintWithTarget> processed = new IdentityHashMap<DexEncodedMethod, Inliner.ConstraintWithTarget>();

    private synchronized UpdatableOptimizationInfo getOptimizationInfoForUpdating(DexEncodedMethod method) {
        UpdatableOptimizationInfo info = this.optimizationInfos.get(method);
        if (info != null) {
            return info;
        }
        info = method.getOptimizationInfo().mutableCopy();
        this.optimizationInfos.put(method, info);
        return info;
    }

    @Override
    public synchronized void methodInitializesClassesOnNormalExit(DexEncodedMethod method, Set<DexType> initializedClasses) {
        this.getOptimizationInfoForUpdating(method).markInitializesClassesOnNormalExit(initializedClasses);
    }

    @Override
    public synchronized void methodReturnsArgument(DexEncodedMethod method, int argument) {
        this.getOptimizationInfoForUpdating(method).markReturnsArgument(argument);
    }

    @Override
    public synchronized void methodReturnsConstantNumber(DexEncodedMethod method, long value) {
        this.getOptimizationInfoForUpdating(method).markReturnsConstantNumber(value);
    }

    @Override
    public synchronized void methodReturnsConstantString(DexEncodedMethod method, DexString value) {
        this.getOptimizationInfoForUpdating(method).markReturnsConstantString(value);
    }

    @Override
    public synchronized void methodReturnsObjectOfType(DexEncodedMethod method, TypeLatticeElement type) {
        this.getOptimizationInfoForUpdating(method).markReturnsObjectOfType(type);
    }

    @Override
    public synchronized void methodNeverReturnsNull(DexEncodedMethod method) {
        this.getOptimizationInfoForUpdating(method).markNeverReturnsNull();
    }

    @Override
    public synchronized void methodNeverReturnsNormally(DexEncodedMethod method) {
        this.getOptimizationInfoForUpdating(method).markNeverReturnsNormally();
    }

    @Override
    public synchronized void methodMayNotHaveSideEffects(DexEncodedMethod method) {
        this.getOptimizationInfoForUpdating(method).markMayNotHaveSideEffects();
    }

    @Override
    public synchronized void markProcessed(DexEncodedMethod method, Inliner.ConstraintWithTarget state) {
        this.processed.put(method, state);
    }

    @Override
    public synchronized void markUseIdentifierNameString(DexEncodedMethod method) {
        this.getOptimizationInfoForUpdating(method).markUseIdentifierNameString();
    }

    @Override
    public synchronized void markCheckNullReceiverBeforeAnySideEffect(DexEncodedMethod method, boolean mark) {
        this.getOptimizationInfoForUpdating(method).markCheckNullReceiverBeforeAnySideEffect(mark);
    }

    @Override
    public synchronized void markTriggerClassInitBeforeAnySideEffect(DexEncodedMethod method, boolean mark) {
        this.getOptimizationInfoForUpdating(method).markTriggerClassInitBeforeAnySideEffect(mark);
    }

    @Override
    public synchronized void setClassInlinerEligibility(DexEncodedMethod method, DexEncodedMethod.ClassInlinerEligibility eligibility) {
        this.getOptimizationInfoForUpdating(method).setClassInlinerEligibility(eligibility);
    }

    @Override
    public synchronized void setTrivialInitializer(DexEncodedMethod method, DexEncodedMethod.TrivialInitializer info) {
        this.getOptimizationInfoForUpdating(method).setTrivialInitializer(info);
    }

    @Override
    public synchronized void setInitializerEnablingJavaAssertions(DexEncodedMethod method) {
        this.getOptimizationInfoForUpdating(method).setInitializerEnablingJavaAssertions();
    }

    @Override
    public synchronized void setParameterUsages(DexEncodedMethod method, ParameterUsagesInfo parameterUsagesInfo) {
        this.getOptimizationInfoForUpdating(method).setParameterUsages(parameterUsagesInfo);
    }

    @Override
    public synchronized void setNonNullParamOrThrow(DexEncodedMethod method, BitSet facts) {
        this.getOptimizationInfoForUpdating(method).setNonNullParamOrThrow(facts);
    }

    @Override
    public synchronized void setNonNullParamOnNormalExits(DexEncodedMethod method, BitSet facts) {
        this.getOptimizationInfoForUpdating(method).setNonNullParamOnNormalExits(facts);
    }

    public void updateVisibleOptimizationInfo() {
        IteratorUtils.removeIf(this.optimizationInfos.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        IteratorUtils.removeIf(this.processed.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        this.optimizationInfos.forEach(DexEncodedMethod::setOptimizationInfo);
        this.processed.forEach(DexEncodedMethod::markProcessed);
        this.optimizationInfos.clear();
        this.processed.clear();
    }
}

