/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.origin.SynthesizedOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class NestBasedAccessDesugaring {
    private static final String NEST_ACCESS_NAME_PREFIX = "-$$Nest$";
    private static final String NEST_ACCESS_METHOD_NAME_PREFIX = "-$$Nest$m";
    private static final String NEST_ACCESS_STATIC_METHOD_NAME_PREFIX = "-$$Nest$sm";
    private static final String NEST_ACCESS_FIELD_GET_NAME_PREFIX = "-$$Nest$fget";
    private static final String NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX = "-$$Nest$sfget";
    private static final String NEST_ACCESS_FIELD_PUT_NAME_PREFIX = "-$$Nest$fput";
    private static final String NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX = "-$$Nest$sfput";
    public static final String NEST_CONSTRUCTOR_NAME = "-$$Nest$Constructor";
    private static final String FULL_NEST_CONTRUCTOR_NAME = "L-$$Nest$Constructor;";
    protected final AppView<?> appView;
    private final HashMap<DexEncodedMethod, DexEncodedMethod> bridges = new HashMap();
    private final HashMap<DexFieldWithAccess, DexEncodedMethod> fieldBridges = new HashMap();
    private final HashMap<DexEncodedMethod, DexProgramClass> deferredBridgesToAdd = new HashMap();
    private DexProgramClass nestConstructor;

    public NestBasedAccessDesugaring(AppView<?> appView) {
        this.appView = appView;
    }

    public void analyzeNests() {
        List<List<DexType>> liveNests = this.computeLiveNests();
        this.processLiveNests(liveNests);
        this.addDeferredBridges();
    }

    public void synthetizeNestConstructor(DexApplication.Builder<?> builder) {
        if (this.nestConstructor != null) {
            ((AppInfo)this.appView.appInfo()).addSynthesizedClass(this.nestConstructor);
            builder.addSynthesizedClass(this.nestConstructor, true);
        }
    }

    private void addDeferredBridges() {
        for (Map.Entry<DexEncodedMethod, DexProgramClass> entry : this.deferredBridgesToAdd.entrySet()) {
            entry.getValue().addMethod(entry.getKey());
        }
    }

    private void processLiveNests(List<List<DexType>> liveNests) {
        for (List<DexType> nest : liveNests) {
            for (DexType type : nest) {
                DexClass clazz = this.appView.definitionFor(type);
                if (clazz == null) {
                    throw this.abortCompilationDueToIncompleteNest(nest);
                }
                NestBasedAccessDesugaringUseRegistry registry = new NestBasedAccessDesugaringUseRegistry(nest, clazz);
                for (DexEncodedMethod method : clazz.methods()) {
                    method.registerCodeReferences(registry);
                }
            }
        }
    }

    private RuntimeException abortCompilationDueToIncompleteNest(List<DexType> nest) {
        ArrayList<String> programClassesFromNest = new ArrayList<String>();
        ArrayList<String> unavailableClasses = new ArrayList<String>();
        ArrayList<String> otherClasses = new ArrayList<String>();
        for (DexType type : nest) {
            DexClass clazz = this.appView.definitionFor(type);
            if (clazz == null) {
                unavailableClasses.add(type.getName());
                continue;
            }
            if (clazz.isProgramClass()) {
                programClassesFromNest.add(type.getName());
                continue;
            }
            assert (clazz.isLibraryClass() || clazz.isClasspathClass());
            otherClasses.add(type.getName());
        }
        StringBuilder stringBuilder = new StringBuilder("Classes ").append(String.join((CharSequence)", ", programClassesFromNest)).append(" requires its nest mates ").append(String.join((CharSequence)", ", unavailableClasses)).append(" to be on program or class path for compilation to succeed)");
        if (!otherClasses.isEmpty()) {
            stringBuilder.append("(Classes ").append(String.join((CharSequence)", ", otherClasses)).append(" from the same nest were available).");
        }
        throw new CompilationError(stringBuilder.toString());
    }

    private List<List<DexType>> computeLiveNests() {
        ArrayList<List<DexType>> liveNests = new ArrayList<List<DexType>>();
        HashSet<DexType> computedNestHosts = new HashSet<DexType>();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            DexProgramClass host;
            DexType hostType;
            if (!clazz.isInANest() || computedNestHosts.contains(hostType = clazz.isNestHost() ? clazz.type : clazz.getNestHostClassAttribute().getNestHost())) continue;
            computedNestHosts.add(hostType);
            DexClass dexClass = host = clazz.isNestHost() ? clazz : this.appView.definitionFor(clazz.getNestHostClassAttribute().getNestHost());
            if (host == null) {
                throw this.abortCompilationDueToMissingNestHost(clazz);
            }
            ArrayList<DexType> classesInNest = new ArrayList<DexType>();
            for (NestMemberClassAttribute nestmate : host.getNestMembersClassAttributes()) {
                classesInNest.add(nestmate.getNestMember());
            }
            classesInNest.add(host.type);
            liveNests.add(classesInNest);
        }
        return liveNests;
    }

    private RuntimeException abortCompilationDueToMissingNestHost(DexProgramClass compiledClass) {
        String nestHostName = compiledClass.getNestHostClassAttribute().getNestHost().getName();
        throw new CompilationError("Class " + compiledClass.type.getName() + " requires its nest host " + nestHostName + " to be on program or class path for compilation to succeed.");
    }

    protected abstract void shouldRewriteCalls(DexMethod var1, DexMethod var2);

    protected abstract void shouldRewriteInitializers(DexMethod var1, DexMethod var2);

    protected abstract void shouldRewriteStaticGetFields(DexField var1, DexMethod var2);

    protected abstract void shouldRewriteStaticPutFields(DexField var1, DexMethod var2);

    protected abstract void shouldRewriteInstanceGetFields(DexField var1, DexMethod var2);

    protected abstract void shouldRewriteInstancePutFields(DexField var1, DexMethod var2);

    private RuntimeException abortCompilationDueToBridgeRequiredOnLibraryClass(DexClass compiledClass, DexClass libraryClass) {
        throw new CompilationError("Class " + compiledClass.type.getName() + " requires the insertion of a bridge on the library class " + libraryClass.type.getName() + " which is impossible.");
    }

    private DexString methodBridgeName(DexEncodedMethod method) {
        String methodName = method.method.name.toString();
        String fullName = method.isStatic() ? NEST_ACCESS_STATIC_METHOD_NAME_PREFIX + methodName : NEST_ACCESS_METHOD_NAME_PREFIX + methodName;
        return this.appView.dexItemFactory().createString(fullName);
    }

    private DexString fieldBridgeName(DexFieldWithAccess access) {
        String fullName;
        String fieldName = ((DexFieldWithAccess)access).field.field.name.toString();
        if (access.isInstanceGet()) {
            fullName = NEST_ACCESS_FIELD_GET_NAME_PREFIX + fieldName;
        } else if (access.isStaticGet()) {
            fullName = NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX + fieldName;
        } else if (access.isInstancePut()) {
            fullName = NEST_ACCESS_FIELD_PUT_NAME_PREFIX + fieldName;
        } else {
            assert (access.isStaticPut());
            fullName = NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX + fieldName;
        }
        return this.appView.dexItemFactory().createString(fullName);
    }

    private DexProgramClass ensureNestConstructorClass() {
        if (this.nestConstructor != null) {
            return this.nestConstructor;
        }
        this.nestConstructor = new DexProgramClass(this.appView.dexItemFactory().createType(FULL_NEST_CONTRUCTOR_NAME), null, new SynthesizedOrigin("Nest based access desugaring", this.getClass()), ClassAccessFlags.fromDexAccessFlags(4113), this.appView.dexItemFactory().objectType, DexTypeList.empty(), this.appView.dexItemFactory().createString("nest"), null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, this.appView.dexItemFactory().getSkipNameValidationForTesting());
        return this.nestConstructor;
    }

    public static final class DexFieldWithAccess {
        private final DexEncodedField field;
        private final boolean isGet;

        public DexFieldWithAccess(DexEncodedField field, boolean isGet) {
            this.field = field;
            this.isGet = isGet;
        }

        public int hashCode() {
            return Objects.hash(this.field, this.isGet);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            DexFieldWithAccess other = (DexFieldWithAccess)o;
            return this.isGet == other.isGet && this.field == other.field;
        }

        public boolean isGet() {
            return this.isGet;
        }

        public boolean isStatic() {
            return this.field.accessFlags.isStatic();
        }

        public boolean isPut() {
            return !this.isGet();
        }

        public boolean isInstance() {
            return !this.isStatic();
        }

        public boolean isStaticGet() {
            return this.isStatic() && this.isGet();
        }

        public boolean isStaticPut() {
            return this.isStatic() && this.isPut();
        }

        public boolean isInstanceGet() {
            return this.isInstance() && this.isGet();
        }

        public boolean isInstancePut() {
            return this.isInstance() && this.isPut();
        }

        public DexType getType() {
            return this.field.field.type;
        }

        public DexType getHolder() {
            return this.field.field.holder;
        }

        public DexField getField() {
            return this.field.field;
        }

        public int bridgeParameterCount() {
            if (this.isGet() && this.isStatic()) {
                return 0;
            }
            if (this.isPut() && this.isInstance()) {
                return 2;
            }
            return 1;
        }
    }

    private class NestBasedAccessDesugaringUseRegistry
    extends UseRegistry {
        private final List<DexType> nest;
        private final DexClass currentClass;

        NestBasedAccessDesugaringUseRegistry(List<DexType> nest, DexClass currentClass) {
            super(NestBasedAccessDesugaring.this.appView.options().itemFactory);
            this.nest = nest;
            this.currentClass = currentClass;
        }

        private boolean registerInvoke(DexMethod method) {
            if (method.holder == this.currentClass.type || !this.nest.contains(method.holder)) {
                return false;
            }
            DexEncodedMethod target = NestBasedAccessDesugaring.this.appView.definitionFor(method);
            if (target == null || !target.accessFlags.isPrivate()) {
                return false;
            }
            DexEncodedMethod bridge = NestBasedAccessDesugaring.this.bridges.computeIfAbsent(target, k -> {
                DexEncodedMethod localBridge;
                DexClass holder = NestBasedAccessDesugaring.this.appView.definitionFor(method.holder);
                DexEncodedMethod dexEncodedMethod = localBridge = target.isInstanceInitializer() ? target.toInitializerForwardingBridge(holder, NestBasedAccessDesugaring.this.appView, NestBasedAccessDesugaring.this.ensureNestConstructorClass()) : target.toStaticForwardingBridge(holder, NestBasedAccessDesugaring.this.appView, NestBasedAccessDesugaring.this.methodBridgeName(target));
                if (holder.isProgramClass()) {
                    NestBasedAccessDesugaring.this.deferredBridgesToAdd.put(localBridge, holder.asProgramClass());
                } else if (holder.isLibraryClass()) {
                    throw NestBasedAccessDesugaring.this.abortCompilationDueToBridgeRequiredOnLibraryClass(this.currentClass, holder);
                }
                return localBridge;
            });
            if (this.currentClass.isProgramClass()) {
                if (target.isInstanceInitializer()) {
                    NestBasedAccessDesugaring.this.shouldRewriteInitializers(method, bridge.method);
                } else {
                    NestBasedAccessDesugaring.this.shouldRewriteCalls(method, bridge.method);
                }
            }
            return true;
        }

        private boolean registerFieldAccess(DexField field, boolean isGet) {
            if (field.holder == this.currentClass.type || !this.nest.contains(field.holder)) {
                return false;
            }
            DexEncodedField target = NestBasedAccessDesugaring.this.appView.definitionFor(field);
            if (target == null || !target.accessFlags.isPrivate()) {
                return false;
            }
            DexFieldWithAccess key = new DexFieldWithAccess(target, isGet);
            DexEncodedMethod bridge = NestBasedAccessDesugaring.this.fieldBridges.computeIfAbsent(key, k -> {
                DexClass holder = NestBasedAccessDesugaring.this.appView.definitionFor(field.holder);
                DexEncodedMethod localBridge = DexEncodedMethod.createFieldAccessorBridge(key, holder, NestBasedAccessDesugaring.this.appView, NestBasedAccessDesugaring.this.fieldBridgeName(key));
                if (holder.isProgramClass()) {
                    NestBasedAccessDesugaring.this.deferredBridgesToAdd.put(localBridge, holder.asProgramClass());
                } else if (holder.isLibraryClass()) {
                    throw NestBasedAccessDesugaring.this.abortCompilationDueToBridgeRequiredOnLibraryClass(this.currentClass, holder);
                }
                return localBridge;
            });
            if (this.currentClass.isProgramClass()) {
                if (isGet) {
                    if (target.isStatic()) {
                        NestBasedAccessDesugaring.this.shouldRewriteStaticGetFields(field, bridge.method);
                    } else {
                        NestBasedAccessDesugaring.this.shouldRewriteInstanceGetFields(field, bridge.method);
                    }
                } else if (target.isStatic()) {
                    NestBasedAccessDesugaring.this.shouldRewriteStaticPutFields(field, bridge.method);
                } else {
                    NestBasedAccessDesugaring.this.shouldRewriteInstancePutFields(field, bridge.method);
                }
            }
            return true;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerFieldAccess(field, false);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerFieldAccess(field, true);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerFieldAccess(field, true);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerFieldAccess(field, false);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }
}

