/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.NestBasedAccessDesugaring;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;

public class NestBasedAccessDesugaringRewriter
extends NestBasedAccessDesugaring {
    private Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
    private Map<DexMethod, DexMethod> initializerMap = new IdentityHashMap<DexMethod, DexMethod>();
    private final Map<DexField, DexMethod> staticGetToMethodMap = new IdentityHashMap<DexField, DexMethod>();
    private final Map<DexField, DexMethod> staticPutToMethodMap = new IdentityHashMap<DexField, DexMethod>();
    private final Map<DexField, DexMethod> instanceGetToMethodMap = new IdentityHashMap<DexField, DexMethod>();
    private final Map<DexField, DexMethod> instancePutToMethodMap = new IdentityHashMap<DexField, DexMethod>();

    public NestBasedAccessDesugaringRewriter(AppView<?> appView) {
        super(appView);
    }

    @Override
    protected void shouldRewriteCalls(DexMethod method, DexMethod bridge) {
        this.methodMap.put(method, bridge);
    }

    @Override
    protected void shouldRewriteInitializers(DexMethod method, DexMethod bridge) {
        this.initializerMap.put(method, bridge);
    }

    @Override
    protected void shouldRewriteStaticGetFields(DexField field, DexMethod bridge) {
        this.staticGetToMethodMap.put(field, bridge);
    }

    @Override
    protected void shouldRewriteStaticPutFields(DexField field, DexMethod bridge) {
        this.staticPutToMethodMap.put(field, bridge);
    }

    @Override
    protected void shouldRewriteInstanceGetFields(DexField field, DexMethod bridge) {
        this.instanceGetToMethodMap.put(field, bridge);
    }

    @Override
    protected void shouldRewriteInstancePutFields(DexField field, DexMethod bridge) {
        this.instancePutToMethodMap.put(field, bridge);
    }

    private void rewriteFieldAccess(Instruction instruction, InstructionListIterator instructions, DexMethod method, Map<DexField, DexMethod> fieldToMethodMap) {
        DexField field = instruction.asFieldInstruction().getField();
        DexMethod newTarget = fieldToMethodMap.get(field);
        if (newTarget != null && method != newTarget) {
            instructions.replaceCurrentInstruction(new InvokeStatic(newTarget, instruction.outValue(), instruction.inValues()));
        }
    }

    public void rewriteNestBasedAccesses(DexEncodedMethod encodedMethod, IRCode code, AppView<?> appView) {
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeMethod() && !instruction.isInvokeSuper()) {
                    InvokeMethod invokeMethod = instruction.asInvokeMethod();
                    DexMethod methodCalled = invokeMethod.getInvokedMethod();
                    DexMethod newTarget = this.methodMap.get(methodCalled);
                    if (newTarget != null && encodedMethod.method != newTarget) {
                        instructions.replaceCurrentInstruction(new InvokeStatic(newTarget, invokeMethod.outValue(), invokeMethod.arguments()));
                        continue;
                    }
                    newTarget = this.initializerMap.get(methodCalled);
                    if (newTarget == null || encodedMethod.method == newTarget) continue;
                    instructions.previous();
                    Value extraNullValue = instructions.insertConstNullInstruction(code, appView.options());
                    instructions.next();
                    ArrayList<Value> parameters = new ArrayList<Value>(invokeMethod.arguments());
                    parameters.add(extraNullValue);
                    instructions.replaceCurrentInstruction(new InvokeDirect(newTarget, invokeMethod.outValue(), parameters));
                    continue;
                }
                if (instruction.isInstanceGet()) {
                    this.rewriteFieldAccess(instruction, instructions, encodedMethod.method, this.instanceGetToMethodMap);
                    continue;
                }
                if (instruction.isInstancePut()) {
                    this.rewriteFieldAccess(instruction, instructions, encodedMethod.method, this.instancePutToMethodMap);
                    continue;
                }
                if (instruction.isStaticGet()) {
                    this.rewriteFieldAccess(instruction, instructions, encodedMethod.method, this.staticGetToMethodMap);
                    continue;
                }
                if (!instruction.isStaticPut()) continue;
                this.rewriteFieldAccess(instruction, instructions, encodedMethod.method, this.staticPutToMethodMap);
            }
        }
    }
}

