/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.IdentityHashMap;
import java.util.Map;

public class NestedPrivateMethodLense
extends GraphLense.NestedGraphLense {
    private final AppView<?> appView;
    private final Map<DexField, DexMethod> staticGetToMethodMap;
    private final Map<DexField, DexMethod> staticPutToMethodMap;
    private final Map<DexField, DexMethod> instanceGetToMethodMap;
    private final Map<DexField, DexMethod> instancePutToMethodMap;

    public NestedPrivateMethodLense(AppView<?> appView, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, Map<DexField, DexMethod> staticGetToMethodMap, Map<DexField, DexMethod> staticPutToMethodMap, Map<DexField, DexMethod> instanceGetToMethodMap, Map<DexField, DexMethod> instancePutToMethodMap, GraphLense previousLense) {
        super(ImmutableMap.of(), methodMap, fieldMap, null, null, previousLense, appView.dexItemFactory());
        this.appView = appView;
        this.staticGetToMethodMap = staticGetToMethodMap;
        this.staticPutToMethodMap = staticPutToMethodMap;
        this.instanceGetToMethodMap = instanceGetToMethodMap;
        this.instancePutToMethodMap = instancePutToMethodMap;
    }

    @Override
    public DexMethod lookupStaticGetFieldForMethod(DexField field) {
        return this.staticGetToMethodMap.get(field);
    }

    @Override
    public DexMethod lookupStaticPutFieldForMethod(DexField field) {
        return this.staticPutToMethodMap.get(field);
    }

    @Override
    public DexMethod lookupInstanceGetFieldForMethod(DexField field) {
        return this.instanceGetToMethodMap.get(field);
    }

    @Override
    public DexMethod lookupInstancePutFieldForMethod(DexField field) {
        return this.instancePutToMethodMap.get(field);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return false;
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        DexMethod previousContext = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(context, context) : context;
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, previousContext, type);
        DexMethod newMethod = (DexMethod)this.methodMap.get(previous.getMethod());
        if (newMethod == null) {
            return previous;
        }
        if (newMethod == context) {
            return previous;
        }
        return new GraphLense.GraphLenseLookupResult(newMethod, Invoke.Type.STATIC);
    }

    public static Builder builder(AppView<?> appView) {
        return new Builder(appView);
    }

    public static class Builder
    extends GraphLense.Builder {
        private final AppView<? extends AppInfo> appView;
        private final Map<DexField, DexMethod> staticGetToMethodMap = new IdentityHashMap<DexField, DexMethod>();
        private final Map<DexField, DexMethod> staticPutToMethodMap = new IdentityHashMap<DexField, DexMethod>();
        private final Map<DexField, DexMethod> instanceGetToMethodMap = new IdentityHashMap<DexField, DexMethod>();
        private final Map<DexField, DexMethod> instancePutToMethodMap = new IdentityHashMap<DexField, DexMethod>();

        protected Builder(AppView<? extends AppInfo> appView) {
            this.appView = appView;
        }

        public void mapInstanceGet(DexField field, DexMethod method) {
            this.instanceGetToMethodMap.put(field, method);
        }

        public void mapInstancePut(DexField field, DexMethod method) {
            this.instancePutToMethodMap.put(field, method);
        }

        public void mapStaticGet(DexField field, DexMethod method) {
            this.staticGetToMethodMap.put(field, method);
        }

        public void mapStaticPut(DexField field, DexMethod method) {
            this.staticPutToMethodMap.put(field, method);
        }

        public GraphLense build(GraphLense previousLense) {
            if (this.methodMap.isEmpty() && this.fieldMap.isEmpty()) {
                return previousLense;
            }
            return new NestedPrivateMethodLense(this.appView, this.methodMap, this.fieldMap, this.staticGetToMethodMap, this.staticPutToMethodMap, this.instanceGetToMethodMap, this.instancePutToMethodMap, previousLense);
        }
    }
}

