/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.synthetic.TemplateMethodCode;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.utils.InternalOptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class TwrCloseResourceRewriter {
    public static final String UTILITY_CLASS_NAME = "$r8$twr$utility";
    public static final String UTILITY_CLASS_DESCRIPTOR = "L$r8$twr$utility;";
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexMethod twrCloseResourceMethod;
    private final Set<DexProgramClass> referencingClasses = Sets.newConcurrentHashSet();

    public TwrCloseResourceRewriter(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexType twrUtilityClass = dexItemFactory.createType(UTILITY_CLASS_DESCRIPTOR);
        DexProto twrCloseResourceProto = dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.throwableType, dexItemFactory.objectType);
        this.twrCloseResourceMethod = dexItemFactory.createMethod(twrUtilityClass, twrCloseResourceProto, dexItemFactory.twrCloseResourceMethodName);
    }

    public void rewriteMethodCode(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        Object appInfo = this.appView.appInfo();
        while (iterator2.hasNext()) {
            InvokeStatic invoke;
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isInvokeStatic() || !TwrCloseResourceRewriter.isSynthesizedCloseResourceMethod((invoke = instruction.asInvokeStatic()).getInvokedMethod(), this.appView)) continue;
            assert (invoke.outValue() == null);
            assert (invoke.inValues().size() == 2);
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.twrCloseResourceMethod, null, invoke.inValues()));
            this.referencingClasses.add(((AppInfo)appInfo).definitionFor(code.method.method.holder).asProgramClass());
        }
    }

    public static boolean isSynthesizedCloseResourceMethod(DexMethod method, AppView<?> appView) {
        DexMethod original = appView.graphLense().getOriginalMethodSignature(method);
        assert (original != null);
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return original.name == dexItemFactory.twrCloseResourceMethodName && original.proto == dexItemFactory.twrCloseResourceMethodProto;
    }

    public void synthesizeUtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService, InternalOptions options) throws ExecutionException {
        if (this.referencingClasses.isEmpty()) {
            return;
        }
        CloseResourceMethodCode code = new CloseResourceMethodCode(options, this.twrCloseResourceMethod);
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        DexEncodedMethod method = new DexEncodedMethod(this.twrCloseResourceMethod, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code);
        DexProgramClass utilityClass = new DexProgramClass(this.twrCloseResourceMethod.holder, null, new SynthesizedOrigin("twr utility class", this.getClass()), ClassAccessFlags.fromSharedAccessFlags(4097), this.appView.dexItemFactory().objectType, DexTypeList.empty(), null, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, new DexEncodedMethod[]{method}, DexEncodedMethod.EMPTY_ARRAY, this.appView.dexItemFactory().getSkipNameValidationForTesting(), this.referencingClasses);
        code.setUpContext(utilityClass);
        Object appInfo = this.appView.appInfo();
        boolean addToMainDexList = this.referencingClasses.stream().anyMatch(clazz -> appInfo.isInMainDexList(clazz.type));
        ((AppInfo)appInfo).addSynthesizedClass(utilityClass);
        this.converter.optimizeSynthesizedClass(utilityClass, executorService);
        builder.addSynthesizedClass(utilityClass, addToMainDexList);
    }

    private static final class CloseResourceMethodCode
    extends TemplateMethodCode {
        private static final String TEMPLATE_METHOD_NAME = "closeResourceImpl";
        private static final String TEMPLATE_METHOD_DESC = "(Ljava/lang/Throwable;Ljava/lang/Object;)V";

        CloseResourceMethodCode(InternalOptions options, DexMethod method) {
            super(options, method, TEMPLATE_METHOD_NAME, TEMPLATE_METHOD_DESC);
        }

        public static void closeResourceImpl(Throwable throwable, Object resource) throws Throwable {
            block7: {
                try {
                    if (resource instanceof AutoCloseable) {
                        ((AutoCloseable)resource).close();
                        break block7;
                    }
                    try {
                        Method method = resource.getClass().getMethod("close", new Class[0]);
                        method.invoke(resource, new Object[0]);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        throw new AssertionError(resource.getClass() + " does not have a close() method.", e);
                    }
                    catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException e) {
                        throw new AssertionError("Fail to call close() on " + resource.getClass(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                catch (Throwable e) {
                    throw throwable != null ? throwable : e;
                }
            }
        }
    }
}

