/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import java.util.Set;

public class AssumeDynamicTypeRemover {
    private final AppView<?> appView;
    private final IRCode code;
    private final Set<Value> affectedValues = Sets.newIdentityHashSet();
    private final Set<Assume<Assume.DynamicTypeAssumption>> assumeDynamicTypeInstructionsToRemove = Sets.newIdentityHashSet();
    private boolean mayHaveIntroducedTrivialPhi = false;

    public AssumeDynamicTypeRemover(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
    }

    public boolean mayHaveIntroducedTrivialPhi() {
        return this.mayHaveIntroducedTrivialPhi;
    }

    public void markForRemoval(Assume<Assume.DynamicTypeAssumption> assumeDynamicTypeInstruction) {
        this.assumeDynamicTypeInstructionsToRemove.add(assumeDynamicTypeInstruction);
    }

    public void markUsersForRemoval(Value value) {
        for (Instruction user : value.uniqueUsers()) {
            if (!user.isAssumeDynamicType()) continue;
            assert (value.numberOfAllUsers() == 1) : "Expected value flowing into Assume<DynamicTypeAssumption> instruction to have a unique user.";
            this.markForRemoval(user.asAssumeDynamicType());
        }
    }

    public void removeIfMarked(Assume<Assume.DynamicTypeAssumption> assumeDynamicTypeInstruction, InstructionListIterator instructionIterator) {
        if (this.assumeDynamicTypeInstructionsToRemove.remove(assumeDynamicTypeInstruction)) {
            Value inValue = assumeDynamicTypeInstruction.src();
            Value outValue = assumeDynamicTypeInstruction.outValue();
            if (!outValue.getTypeLattice().equals(inValue.getTypeLattice())) {
                this.affectedValues.addAll(outValue.affectedValues());
            }
            if (outValue.numberOfPhiUsers() > 0) {
                this.mayHaveIntroducedTrivialPhi = true;
            }
            outValue.replaceUsers(inValue);
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    public void removeMarkedInstructions() {
        if (!this.assumeDynamicTypeInstructionsToRemove.isEmpty()) {
            for (BasicBlock block : this.code.blocks) {
                InstructionListIterator instructionIterator = block.listIterator();
                while (instructionIterator.hasNext()) {
                    Instruction instruction = (Instruction)instructionIterator.next();
                    if (!instruction.isAssumeDynamicType()) continue;
                    this.removeIfMarked(instruction.asAssumeDynamicType(), instructionIterator);
                }
            }
        }
    }

    public void finish() {
        if (!this.affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView, this.code.method).narrowing(this.affectedValues);
        }
    }
}

