/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassInitializerDefaultsOptimization {
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexItemFactory dexItemFactory;
    private WaveDoneAction waveDoneAction = null;

    public ClassInitializerDefaultsOptimization(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        this.dexItemFactory = appView.dexItemFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(DexEncodedMethod method, IRCode code) {
        if (!method.isClassInitializer()) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(method.method.holder);
        if (clazz == null) {
            return;
        }
        Set<StaticPut> unnecessaryStaticPuts = Sets.newIdentityHashSet();
        Collection<StaticPut> finalFieldPuts = this.computeUnnecessaryStaticPuts(code, clazz, unnecessaryStaticPuts);
        if (unnecessaryStaticPuts.isEmpty()) {
            return;
        }
        IdentityHashMap<DexEncodedField, DexValue> fieldsWithStaticValues = new IdentityHashMap<DexEncodedField, DexValue>();
        for (StaticPut put : finalFieldPuts) {
            DexEncodedField field2 = ((AppInfo)this.appView.appInfo()).resolveField(put.getField());
            DexType fieldType = field2.field.type;
            Value inValue = put.inValue();
            if (fieldType == this.dexItemFactory.stringType) {
                fieldsWithStaticValues.put(field2, this.getDexStringValue(inValue, method.method.holder));
                continue;
            }
            if (fieldType.isClassType() || fieldType.isArrayType()) {
                if (inValue.isZero()) {
                    fieldsWithStaticValues.put(field2, DexValue.DexValueNull.NULL);
                    continue;
                }
                throw new Unreachable("Unexpected default value for field type " + fieldType + ".");
            }
            ConstNumber cnst = inValue.getConstInstruction().asConstNumber();
            if (fieldType == this.dexItemFactory.booleanType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueBoolean.create(cnst.getBooleanValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.byteType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueByte.create((byte)cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.shortType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueShort.create((short)cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.intType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueInt.create(cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.longType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueLong.create(cnst.getLongValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.floatType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueFloat.create(cnst.getFloatValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.doubleType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueDouble.create(cnst.getDoubleValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.charType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueChar.create((char)cnst.getIntValue()));
                continue;
            }
            throw new Unreachable("Unexpected field type " + fieldType + ".");
        }
        Set<Instruction> unnecessaryInstructions = Sets.newIdentityHashSet();
        InstructionIterator instructionIterator = code.instructionIterator();
        while (instructionIterator.hasNext()) {
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!instruction.isStaticPut() || !unnecessaryStaticPuts.contains(instruction.asStaticPut())) continue;
            Value inValue = instruction.asStaticPut().inValue();
            instructionIterator.removeOrReplaceByDebugLocalRead();
            if (inValue.numberOfAllUsers() > 0) continue;
            if (inValue.isConstString()) {
                unnecessaryInstructions.add(inValue.definition);
                continue;
            }
            if (inValue.isPhi() || !inValue.definition.isInvokeVirtual()) continue;
            unnecessaryInstructions.add(inValue.definition);
        }
        if (unnecessaryInstructions.size() > 0) {
            IteratorUtils.removeIf(code.instructionIterator(), unnecessaryInstructions::contains);
        }
        if (this.appView.enableWholeProgramOptimizations() && this.converter.isInWave()) {
            if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
                AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
                AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
                Set<DexField> candidates = finalFieldPuts.stream().map(FieldInstruction::getField).map(field -> appInfoWithLiveness.resolveField((DexField)field).field).filter(appInfoWithLiveness::isStaticFieldWrittenOnlyInEnclosingStaticInitializer).collect(Collectors.toSet());
                for (Instruction instruction : code.instructions()) {
                    StaticPut staticPutInstruction;
                    DexField field3;
                    DexEncodedField encodedField;
                    if (!instruction.isStaticPut() || (encodedField = appInfoWithLiveness.resolveField(field3 = (staticPutInstruction = instruction.asStaticPut()).getField())) == null) continue;
                    candidates.remove(encodedField.field);
                }
                ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization = this;
                synchronized (classInitializerDefaultsOptimization) {
                    if (this.waveDoneAction == null) {
                        this.waveDoneAction = new WaveDoneAction(fieldsWithStaticValues, candidates);
                        this.converter.addWaveDoneAction(() -> {
                            this.waveDoneAction.execute();
                            this.waveDoneAction = null;
                        });
                    } else {
                        this.waveDoneAction.join(fieldsWithStaticValues, candidates);
                    }
                }
            } else assert (false);
        } else {
            fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
    }

    private DexValue getDexStringValue(Value inValue, DexType holder) {
        if (inValue.isConstant()) {
            if (inValue.isConstNumber()) {
                assert (inValue.isZero());
                return DexValue.DexValueNull.NULL;
            }
            if (inValue.isConstString()) {
                ConstString cnst = inValue.getConstInstruction().asConstString();
                return new DexValue.DexValueString(cnst.getValue());
            }
            if (inValue.isDexItemBasedConstString()) {
                DexItemBasedConstString cnst = inValue.getConstInstruction().asDexItemBasedConstString();
                assert (!cnst.getClassNameComputationInfo().needsToComputeClassName());
                return new DexValue.DexItemBasedValueString(cnst.getItem(), cnst.getClassNameComputationInfo());
            }
            assert (false);
            return null;
        }
        InvokeVirtual invoke = inValue.definition.asInvokeVirtual();
        return this.getDexStringValueForInvoke(invoke.getInvokedMethod(), holder);
    }

    private DexValue getDexStringValueForInvoke(DexMethod invokedMethod, DexType holder) {
        DexClass clazz = this.appView.definitionFor(holder);
        if (clazz == null) {
            assert (false);
            return null;
        }
        if (this.appView.options().isMinifying() && this.appView.rootSet().mayBeMinified(holder, this.appView)) {
            if (invokedMethod == this.dexItemFactory.classMethods.getName) {
                return new DexValue.DexItemBasedValueString(holder, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
                return new DexValue.DexItemBasedValueString(holder, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
                return new DexValue.DexItemBasedValueString(holder, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
                // empty if block
            }
            assert (false);
            return null;
        }
        String descriptor = holder.toDescriptorString();
        DexString name = null;
        if (invokedMethod == this.dexItemFactory.classMethods.getName) {
            name = ReflectionOptimizer.computeClassName(descriptor, clazz, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, this.dexItemFactory);
        } else if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
            name = ReflectionOptimizer.computeClassName(descriptor, clazz, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, this.dexItemFactory);
        } else if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
            name = ReflectionOptimizer.computeClassName(descriptor, clazz, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, this.dexItemFactory);
        } else if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
            // empty if block
        }
        if (name != null) {
            return new DexValue.DexValueString(name);
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StaticPut> computeUnnecessaryStaticPuts(IRCode code, DexClass clazz, Set<StaticPut> puts) {
        IdentityHashMap<DexField, StaticPut> finalFieldPut = Maps.newIdentityHashMap();
        Set<DexField> isReadBefore = Sets.newIdentityHashSet();
        int color = code.reserveMarkingColor();
        try {
            BasicBlock block = code.entryBlock();
            while (!block.isMarked(color) && block.getPredecessors().size() <= 1) {
                block.mark(color);
                InstructionListIterator it = block.listIterator();
                while (it.hasNext()) {
                    Collection<StaticPut> collection;
                    Object field;
                    Instruction instruction = (Instruction)it.next();
                    if (instruction.isStaticGet()) {
                        StaticGet get = instruction.asStaticGet();
                        field = ((AppInfo)this.appView.appInfo()).resolveField(get.getField());
                        if (field != null && ((DexEncodedField)field).field.holder == clazz.type) {
                            isReadBefore.add(((DexEncodedField)field).field);
                            continue;
                        }
                        if (!instruction.instructionMayHaveSideEffects(this.appView, clazz.type)) continue;
                        Collection<StaticPut> collection2 = finalFieldPut.values();
                        return collection2;
                    }
                    if (instruction.isStaticPut()) {
                        StaticPut put = instruction.asStaticPut();
                        if (put.getField().holder != clazz.type) {
                            field = finalFieldPut.values();
                            return field;
                        }
                        field = put.getField();
                        if (clazz.definesStaticField((DexField)field)) {
                            if (isReadBefore.contains(field) || put.inValue().isDexItemBasedConstStringThatNeedsToComputeClassName()) continue;
                            if (put.inValue().isConstant()) {
                                if ((((DexField)field).type.isClassType() || ((DexField)field).type.isArrayType()) && put.inValue().isZero()) {
                                    finalFieldPut.put(put.getField(), put);
                                    puts.add(put);
                                    continue;
                                }
                                if (!((DexField)field).type.isPrimitiveType() && ((DexField)field).type != this.dexItemFactory.stringType) continue;
                                finalFieldPut.put(put.getField(), put);
                                puts.add(put);
                                continue;
                            }
                            if (!this.isClassNameConstantOf(clazz, put)) continue;
                            finalFieldPut.put(put.getField(), put);
                            puts.add(put);
                            continue;
                        }
                        Collection<StaticPut> collection3 = finalFieldPut.values();
                        return collection3;
                    }
                    if (instruction.instructionMayHaveSideEffects(this.appView, clazz.type)) {
                        collection = finalFieldPut.values();
                        return collection;
                    }
                    if (this.isClassNameConstantOf(clazz, instruction)) continue;
                    if (!instruction.isInvoke() || instruction.asInvoke().outValue() == null) continue;
                    collection = finalFieldPut.values();
                    return collection;
                }
                if (!block.exit().isGoto()) continue;
                block = block.exit().asGoto().getTarget();
            }
        }
        finally {
            code.returnMarkingColor(color);
        }
        return finalFieldPut.values();
    }

    private boolean isClassNameConstantOf(DexClass clazz, StaticPut put) {
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        if (put.inValue().definition != null) {
            return this.isClassNameConstantOf(clazz, put.inValue().definition);
        }
        return false;
    }

    private boolean isClassNameConstantOf(DexClass clazz, Instruction instruction) {
        if (instruction.isInvokeVirtual()) {
            InvokeVirtual invoke = instruction.asInvokeVirtual();
            if (!this.dexItemFactory.classMethods.isReflectiveNameLookup(invoke.getInvokedMethod())) {
                return false;
            }
            Value inValue = invoke.inValues().get(0);
            return !inValue.isPhi() && inValue.definition.isConstClass() && inValue.definition.asConstClass().getValue() == clazz.type;
        }
        return false;
    }

    private class WaveDoneAction
    implements Action {
        private final Map<DexEncodedField, DexValue> fieldsWithStaticValues;
        private final Set<DexField> noLongerWrittenFields;

        public WaveDoneAction(Map<DexEncodedField, DexValue> fieldsWithStaticValues, Set<DexField> noLongerWrittenFields) {
            this.fieldsWithStaticValues = fieldsWithStaticValues;
            this.noLongerWrittenFields = noLongerWrittenFields;
        }

        public synchronized void join(Map<DexEncodedField, DexValue> fieldsWithStaticValues, Set<DexField> noLongerWrittenFields) {
            this.fieldsWithStaticValues.putAll(fieldsWithStaticValues);
            this.noLongerWrittenFields.addAll(noLongerWrittenFields);
        }

        @Override
        public void execute() {
            AppView<AppInfoWithLiveness> appViewWithLiveness = ClassInitializerDefaultsOptimization.this.appView.withLiveness();
            appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().withoutStaticFieldsWrites(this.noLongerWrittenFields));
            this.fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
    }
}

