/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class DeadCodeRemover {
    private final AppView<?> appView;
    private final CodeRewriter codeRewriter;

    public DeadCodeRemover(AppView<?> appView, CodeRewriter codeRewriter) {
        this.appView = appView;
        this.codeRewriter = codeRewriter;
    }

    public void run(IRCode code) {
        this.removeUnneededCatchHandlers(code);
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        do {
            worklist.addAll(code.blocks);
            BasicBlock block = (BasicBlock)worklist.poll();
            while (block != null) {
                this.removeDeadInstructions(worklist, code, block);
                this.removeDeadPhis(worklist, code, block);
                block = (BasicBlock)worklist.poll();
            }
        } while (this.removeUnneededCatchHandlers(code));
        assert (code.isConsistentSSA());
        this.codeRewriter.rewriteMoveResult(code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = null;
        if (value.isPhi()) {
            block = value.asPhi().getBlock();
        } else if (value.definition.hasBlock()) {
            block = value.definition.getBlock();
        }
        if (block != null) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
    }

    private void removeDeadPhis(Queue<BasicBlock> worklist, IRCode code, BasicBlock block) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(this.appView, code)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
    }

    private void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block) {
        InstructionListIterator iterator2 = block.listIterator(block.getInstructions().size());
        while (iterator2.hasPrevious()) {
            Value outValue;
            Instruction current = (Instruction)iterator2.previous();
            if (current.isInvoke() && current.outValue() != null && !current.outValue().isUsed()) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(this.appView, code) || (outValue = current.outValue()) != null && !outValue.isDead(this.appView, code)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            if (outValue != null) {
                outValue.clearUsers();
            }
            iterator2.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean removeUnneededCatchHandlers(IRCode code) {
        boolean mayHaveIntroducedUnreachableBlocks = false;
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            if (block.canThrow()) {
                Collection<CatchHandlers.CatchHandler<BasicBlock>> deadCatchHandlers;
                if (!this.appView.enableWholeProgramOptimizations() || (deadCatchHandlers = this.getDeadCatchHandlers(block)).isEmpty()) continue;
                for (CatchHandlers.CatchHandler catchHandler : deadCatchHandlers) {
                    ((BasicBlock)catchHandler.target).unlinkCatchHandlerForGuard(catchHandler.guard);
                }
                mayHaveIntroducedUnreachableBlocks = true;
                continue;
            }
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock basicBlock : handlers.getUniqueTargets()) {
                basicBlock.unlinkCatchHandler();
                mayHaveIntroducedUnreachableBlocks = true;
            }
        }
        if (mayHaveIntroducedUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
        assert (code.isConsistentGraph());
        return mayHaveIntroducedUnreachableBlocks;
    }

    private Collection<CatchHandlers.CatchHandler<BasicBlock>> getDeadCatchHandlers(BasicBlock block) {
        AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)this.appView.appInfo()).withLiveness();
        ImmutableList.Builder builder = ImmutableList.builder();
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        for (int i = 0; i < catchHandlers.size(); ++i) {
            DexClass clazz;
            DexType guard = catchHandlers.getGuards().get(i);
            BasicBlock target = catchHandlers.getAllTargets().get(i);
            boolean isSubsumedByPreviousGuard = false;
            for (int j = 0; j < i; ++j) {
                DexType previousGuard = catchHandlers.getGuards().get(j);
                if (!this.appView.isSubtype(guard, previousGuard).isTrue()) continue;
                isSubsumedByPreviousGuard = true;
                break;
            }
            if (isSubsumedByPreviousGuard) {
                builder.add(new CatchHandlers.CatchHandler<BasicBlock>(guard, target));
                continue;
            }
            if (appInfoWithLiveness == null || !this.appView.options().enableUninstantiatedTypeOptimization || (clazz = this.appView.definitionFor(guard)) == null || !clazz.isProgramClass() || appInfoWithLiveness.isInstantiatedDirectlyOrIndirectly(guard)) continue;
            builder.add(new CatchHandlers.CatchHandler<BasicBlock>(guard, target));
        }
        return builder.build();
    }
}

