/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.function.Predicate;

public class DynamicTypeOptimization {
    private final AppView<AppInfoWithLiveness> appView;

    public DynamicTypeOptimization(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public void insertAssumeDynamicTypeInstructions(IRCode code) {
        this.insertAssumeDynamicTypeInstructionsInBlocks(code, code.listIterator(), Predicates.alwaysTrue());
    }

    public void insertAssumeDynamicTypeInstructionsInBlocks(IRCode code, ListIterator<BasicBlock> blockIterator, Predicate<BasicBlock> blockTester) {
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            this.insertAssumeDynamicTypeInstructionsInBlock(code, blockIterator, block);
        }
    }

    private void insertAssumeDynamicTypeInstructionsInBlock(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
        InstructionListIterator instructionIterator = block.listIterator();
        while (instructionIterator.hasNext()) {
            TypeLatticeElement dynamicReturnType;
            DexEncodedMethod singleTarget;
            DexType staticReturnTypeRaw;
            InvokeMethod invoke;
            Value outValue;
            Instruction current = (Instruction)instructionIterator.next();
            if (!current.isInvokeMethod() || (outValue = (invoke = current.asInvokeMethod()).outValue()) == null || !(staticReturnTypeRaw = invoke.getInvokedMethod().proto.returnType).isReferenceType() || (singleTarget = invoke.lookupSingleTarget(this.appView, code.method.method.holder)) == null || (dynamicReturnType = singleTarget.getOptimizationInfo().getDynamicReturnType()) == null || !dynamicReturnType.strictlyLessThan(outValue.getTypeLattice(), this.appView)) continue;
            BasicBlock insertionBlock = block.hasCatchHandlers() ? instructionIterator.split(code, blockIterator) : block;
            Value specializedOutValue = code.createValue(outValue.getTypeLattice(), outValue.getLocalInfo());
            outValue.replaceUsers(specializedOutValue);
            Assume<Assume.DynamicTypeAssumption> assumeInstruction = Assume.createAssumeDynamicTypeInstruction(dynamicReturnType, specializedOutValue, outValue, invoke, this.appView);
            assumeInstruction.setPosition(this.appView.options().debug ? invoke.getPosition() : Position.none());
            if (insertionBlock == block) {
                instructionIterator.add(assumeInstruction);
                continue;
            }
            insertionBlock.listIterator().add(assumeInstruction);
        }
    }

    public TypeLatticeElement computeDynamicReturnType(DexEncodedMethod method, IRCode code) {
        assert (method.method.proto.returnType.isReferenceType());
        ArrayList<TypeLatticeElement> returnedTypes = new ArrayList<TypeLatticeElement>();
        for (BasicBlock block : code.blocks) {
            JumpInstruction exitInstruction = block.exit();
            if (!exitInstruction.isReturn()) continue;
            returnedTypes.add(exitInstruction.asReturn().getReturnType());
        }
        return returnedTypes.isEmpty() ? null : TypeLatticeElement.join(returnedTypes, this.appView);
    }
}

