/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.Map;

public class EnumOrdinalMapCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps = new IdentityHashMap<DexType, Reference2IntMap<DexField>>();

    public EnumOrdinalMapCollector(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public AppInfoWithLiveness run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.processClasses(clazz);
        }
        if (!this.ordinalsMaps.isEmpty()) {
            return this.appView.appInfo().addEnumOrdinalMaps(this.ordinalsMaps);
        }
        return this.appView.appInfo();
    }

    private void processClasses(DexProgramClass clazz) {
        if (!clazz.accessFlags.isEnum() || clazz.isNotProgramClass() || !clazz.hasClassInitializer()) {
            return;
        }
        DexEncodedMethod initializer = clazz.getClassInitializer();
        IRCode code = initializer.getCode().buildIR(initializer, this.appView, clazz.origin);
        Reference2IntArrayMap<DexField> ordinalsMap = new Reference2IntArrayMap<DexField>();
        ordinalsMap.defaultReturnValue(-1);
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction newInstance;
            Instruction insn = (Instruction)it.next();
            if (!insn.isStaticPut()) continue;
            StaticPut staticPut = insn.asStaticPut();
            if (staticPut.getField().type != clazz.type || (newInstance = staticPut.inValue().definition) == null || !newInstance.isNewInstance()) continue;
            Instruction ordinal = null;
            for (Instruction ctorCall : newInstance.outValue().uniqueUsers()) {
                if (!ctorCall.isInvokeDirect()) continue;
                InvokeDirect invoke = ctorCall.asInvokeDirect();
                if (!this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) || invoke.arguments().size() < 3) continue;
                ordinal = invoke.arguments().get((int)2).definition;
                break;
            }
            if (ordinal == null || !ordinal.isConstNumber()) {
                return;
            }
            if (ordinalsMap.put(staticPut.getField(), ordinal.asConstNumber().getIntValue()) == -1) continue;
            return;
        }
        this.ordinalsMaps.put(clazz.type, ordinalsMap);
    }
}

