/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IdempotentFunctionCallCanonicalizer {
    private static final int MAX_CANONICALIZED_CALL = 7;
    private final Set<DexMethod> idempotentMethods;

    public IdempotentFunctionCallCanonicalizer(DexItemFactory factory) {
        ImmutableSet.Builder idempotentMethodsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : factory.primitiveToBoxed.entrySet()) {
            DexType primitive = (DexType)entry.getKey();
            DexType boxed = (DexType)entry.getValue();
            idempotentMethodsBuilder.add(factory.createMethod(boxed.descriptor, factory.valueOfMethodName, boxed.descriptor, new DexString[]{primitive.descriptor}));
        }
        this.idempotentMethods = idempotentMethodsBuilder.build();
    }

    public void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List> returnValues = new Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List>(new Hash.Strategy<InvokeMethod>(){

            @Override
            public int hashCode(InvokeMethod o) {
                return o.getInvokedMethod().hashCode() * 31 + o.inValues().hashCode();
            }

            @Override
            public boolean equals(InvokeMethod a, InvokeMethod b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b) && a.inValues().equals(b.inValues());
            }
        });
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                InvokeMethod invoke;
                Instruction current = (Instruction)it.next();
                if (!current.isInvokeMethod() || !this.idempotentMethods.contains((invoke = current.asInvokeMethod()).getInvokedMethod()) || invoke.outValue() == null || current.outValue().hasLocalInfo()) continue;
                assert (!current.inValues().isEmpty());
                boolean invocationCanBeMovedToEntryBlock = true;
                for (Value in : current.inValues()) {
                    if (!in.isPhi() && in.definition.isConstInstruction() && in.definition.getBlock().getNumber() == 0) continue;
                    invocationCanBeMovedToEntryBlock = false;
                    break;
                }
                if (!invocationCanBeMovedToEntryBlock) continue;
                List oldReturnValues = returnValues.computeIfAbsent(invoke, k -> new ArrayList());
                oldReturnValues.add(current.outValue());
            }
        }
        if (returnValues.isEmpty()) {
            return;
        }
        HashMap deadInvocations = Maps.newHashMap();
        ObjectSortedSet entries = returnValues.object2ObjectEntrySet();
        entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(7L).forEach(entry -> {
            InvokeMethod invoke = (InvokeMethod)entry.getKey();
            Value canonicalizedValue = code.createValue(invoke.outValue().getTypeLattice(), invoke.outValue().getLocalInfo());
            Invoke canonicalizedInvoke = Invoke.create(invoke.getType(), invoke.getInvokedMethod(), null, canonicalizedValue, invoke.inValues());
            IdempotentFunctionCallCanonicalizer.insertCanonicalizedInvoke(code, canonicalizedInvoke);
            for (Value oldOutValue : (List)entry.getValue()) {
                deadInvocations.put(oldOutValue.definition.asInvokeMethod(), canonicalizedValue);
            }
        });
        if (!deadInvocations.isEmpty()) {
            for (BasicBlock block : code.blocks) {
                InstructionListIterator it = block.listIterator();
                while (it.hasNext()) {
                    InvokeMethod invoke;
                    Instruction current = (Instruction)it.next();
                    if (!current.isInvokeMethod() || !deadInvocations.containsKey(invoke = current.asInvokeMethod())) continue;
                    Value newOutValue = (Value)deadInvocations.get(invoke);
                    assert (newOutValue != null);
                    invoke.outValue().replaceUsers(newOutValue);
                    it.removeOrReplaceByDebugLocalRead();
                }
            }
        }
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private static void insertCanonicalizedInvoke(IRCode code, Invoke canonicalizedInvoke) {
        BasicBlock entryBlock = code.entryBlock();
        int numberOfInValuePassed = 0;
        InstructionListIterator it = entryBlock.listIterator();
        while (it.hasNext()) {
            Instruction current = (Instruction)it.next();
            if (current.hasOutValue() && canonicalizedInvoke.inValues().contains(current.outValue())) {
                ++numberOfInValuePassed;
            }
            if (numberOfInValuePassed != canonicalizedInvoke.inValues().size()) continue;
            canonicalizedInvoke.setPosition(current.getPosition());
            break;
        }
        it.add(canonicalizedInvoke);
    }
}

