/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardMemberRule;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;

public class MemberValuePropagation {
    private final AppView<AppInfoWithLiveness> appView;

    public MemberValuePropagation(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private boolean mayPropagateValueFor(DexEncodedField field) {
        return field.isProgramField(this.appView) ? this.appView.appInfo().mayPropagateValueFor(field.field) : this.appView.appInfo().assumedValues.containsKey(field.field);
    }

    private boolean mayPropagateValueFor(DexEncodedMethod method) {
        return method.isProgramMethod(this.appView) ? this.appView.appInfo().mayPropagateValueFor(method.method) : this.appView.appInfo().assumedValues.containsKey(method.method);
    }

    private ProguardMemberRuleLookup lookupMemberRule(DexDefinition definition) {
        if (definition == null) {
            return null;
        }
        DexReference reference = definition.toReference();
        ProguardMemberRule rule = this.appView.appInfo().noSideEffects.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_NO_SIDE_EFFECTS, rule);
        }
        rule = this.appView.appInfo().assumedValues.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_VALUES, rule);
        }
        return null;
    }

    private Instruction constantReplacementFromProguardRule(ProguardMemberRule rule, IRCode code, Instruction instruction) {
        Instruction replacement = null;
        TypeLatticeElement typeLattice = instruction.outValue().getTypeLattice();
        if (rule != null && rule.hasReturnValue() && rule.getReturnValue().isSingleValue()) {
            replacement = MemberValuePropagation.createConstNumberReplacement(code, rule.getReturnValue().getSingleValue(), typeLattice, instruction.getLocalInfo());
        }
        if (replacement == null && rule != null && rule.hasReturnValue() && rule.getReturnValue().isField()) {
            DexField field = rule.getReturnValue().getField();
            assert (typeLattice == TypeLatticeElement.fromDexType(field.type, Nullability.maybeNull(), this.appView));
            DexEncodedField staticField = this.appView.appInfo().lookupStaticTarget(field.holder, field);
            if (staticField != null) {
                Value value = code.createValue(typeLattice, instruction.getLocalInfo());
                replacement = staticField.getStaticValue().asConstInstruction(false, value, this.appView.options());
                if (replacement.isDexItemBasedConstString()) {
                    code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
                }
            } else {
                throw new CompilationError(field.holder.toSourceString() + "." + field.name.toString() + " used in assumevalues rule does not exist.");
            }
        }
        return replacement;
    }

    private static ConstNumber createConstNumberReplacement(IRCode code, long constant, TypeLatticeElement typeLattice, DebugLocalInfo debugLocalInfo) {
        assert (!typeLattice.isReference() || constant == 0L);
        Value returnedValue = code.createValue(typeLattice.isReference() ? TypeLatticeElement.NULL : typeLattice, debugLocalInfo);
        return new ConstNumber(returnedValue, constant);
    }

    private ConstString createConstStringReplacement(IRCode code, DexString constant, TypeLatticeElement typeLattice, DebugLocalInfo debugLocalInfo) {
        assert (typeLattice.isClassType());
        assert (this.appView.isSubtype(this.appView.dexItemFactory().stringType, typeLattice.asClassTypeLatticeElement().getClassType()).isTrue());
        Value returnedValue = code.createValue(typeLattice, debugLocalInfo);
        ConstString instruction = new ConstString(returnedValue, constant, BasicBlock.ThrowingInfo.defaultForConstString(this.appView.options()));
        assert (!instruction.instructionInstanceCanThrow());
        return instruction;
    }

    private void setValueRangeFromProguardRule(ProguardMemberRule rule, Value value) {
        if (rule.hasReturnValue() && rule.getReturnValue().isValueRange()) {
            assert (!rule.getReturnValue().isSingleValue());
            value.setValueRange(rule.getReturnValue().getValueRange());
        }
    }

    private boolean tryConstantReplacementFromProguard(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, Instruction current, ProguardMemberRuleLookup lookup) {
        Instruction replacement = this.constantReplacementFromProguardRule(lookup.rule, code, current);
        if (replacement == null) {
            this.setValueRangeFromProguardRule(lookup.rule, current.outValue());
            return false;
        }
        affectedValues.add(replacement.outValue());
        if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS) {
            iterator2.replaceCurrentInstruction(replacement);
        } else {
            assert (lookup.type == RuleType.ASSUME_VALUES);
            if (current.outValue() != null) {
                assert (replacement.outValue() != null);
                current.outValue().replaceUsers(replacement.outValue());
            }
            replacement.setPosition(current.getPosition());
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator().add(replacement);
            } else {
                iterator2.add(replacement);
            }
        }
        return true;
    }

    private void rewriteInvokeMethodWithConstantValues(IRCode code, DexType callingContext, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod current) {
        DexMethod invokedMethod = current.getInvokedMethod();
        DexType invokedHolder = invokedMethod.holder;
        if (!invokedHolder.isClassType()) {
            return;
        }
        DexEncodedMethod definition = current.lookupSingleTarget(this.appView, callingContext);
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(definition);
        if (lookup == null) {
            DexEncodedMethod target = this.appView.definitionFor(invokedMethod);
            lookup = this.lookupMemberRule(target);
        }
        boolean invokeReplaced = false;
        if (lookup != null) {
            boolean outValueNullOrNotUsed;
            boolean bl = outValueNullOrNotUsed = current.outValue() == null || !current.outValue().isUsed();
            if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS && outValueNullOrNotUsed) {
                iterator2.removeOrReplaceByDebugLocalRead();
                invokeReplaced = true;
            } else if (!outValueNullOrNotUsed) {
                invokeReplaced = this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup);
            }
        }
        if (invokeReplaced || current.outValue() == null) {
            return;
        }
        DexEncodedMethod target = current.lookupSingleTarget(this.appView, callingContext);
        if (target == null || !this.mayPropagateValueFor(target)) {
            return;
        }
        if (target.getOptimizationInfo().returnsConstant()) {
            ConstInstruction replacement;
            if (target.getOptimizationInfo().returnsConstantNumber()) {
                long constant = target.getOptimizationInfo().getReturnedConstantNumber();
                replacement = MemberValuePropagation.createConstNumberReplacement(code, constant, current.outValue().getTypeLattice(), current.getLocalInfo());
            } else {
                assert (target.getOptimizationInfo().returnsConstantString());
                DexString constant = target.getOptimizationInfo().getReturnedConstantString();
                replacement = this.createConstStringReplacement(code, constant, current.outValue().getTypeLattice(), current.getLocalInfo());
            }
            affectedValues.add(replacement.outValue());
            current.outValue().replaceUsers(replacement.outValue());
            current.setOutValue(null);
            replacement.setPosition(current.getPosition());
            current.moveDebugValues(replacement);
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator().add(replacement);
            } else {
                iterator2.add(replacement);
            }
            return;
        }
        if (target.getOptimizationInfo().neverReturnsNull() && current.outValue().getTypeLattice().isReference() && current.outValue().canBeNull()) {
            this.insertAssumeNotNull(code, affectedValues, blocks, iterator2, current);
        }
    }

    private void rewriteStaticGetWithConstantValues(IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, StaticGet current) {
        DexClass holderDefinition;
        DexField field = current.getField();
        DexEncodedField target = this.appView.appInfo().lookupStaticTarget(field.holder, field);
        if (target == null || !this.mayPropagateValueFor(target)) {
            return;
        }
        Instruction replacement = target.valueAsConstInstruction(this.appView.appInfo(), current.dest(), this.appView.options());
        if (replacement != null) {
            affectedValues.add(replacement.outValue());
            iterator2.replaceCurrentInstruction(replacement);
            if (replacement.isDexItemBasedConstString()) {
                code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
            }
            return;
        }
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(target);
        if (lookup != null && lookup.type == RuleType.ASSUME_VALUES && this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup)) {
            return;
        }
        if (current.dest() != null && (holderDefinition = this.appView.definitionFor(field.holder)) != null && holderDefinition.accessFlags.isFinal() && !field.holder.initializationOfParentTypesMayHaveSideEffects(this.appView.appInfo())) {
            DexEncodedMethod.TrivialInitializer info;
            Value outValue = current.dest();
            DexEncodedMethod classInitializer = holderDefinition.getClassInitializer();
            if (classInitializer != null && !isProcessedConcurrently.test(classInitializer) && (info = classInitializer.getOptimizationInfo().getTrivialInitializerInfo()) != null && ((DexEncodedMethod.TrivialInitializer.TrivialClassInitializer)info).field == field && !this.appView.appInfo().isPinned(field) && outValue.getTypeLattice().isReference() && outValue.canBeNull()) {
                this.insertAssumeNotNull(code, affectedValues, blocks, iterator2, current);
            }
        }
    }

    private void insertAssumeNotNull(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, Instruction current) {
        Value knownToBeNonNullValue = current.outValue();
        Set<Value> affectedUsers = knownToBeNonNullValue.affectedValues();
        TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
        Value nonNullValue = code.createValue(typeLattice.asReferenceTypeLatticeElement().asNotNull(), knownToBeNonNullValue.getLocalInfo());
        knownToBeNonNullValue.replaceUsers(nonNullValue);
        Assume<Assume.NonNullAssumption> nonNull = Assume.createAssumeNonNullInstruction(nonNullValue, knownToBeNonNullValue, current, this.appView);
        nonNull.setPosition(this.appView.options().debug ? current.getPosition() : Position.none());
        if (current.getBlock().hasCatchHandlers()) {
            iterator2.split(code, blocks).listIterator().add(nonNull);
        } else {
            iterator2.add(nonNull);
        }
        affectedValues.addAll(affectedUsers);
    }

    public void rewriteWithConstantValues(IRCode code, DexType callingContext, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod()) {
                    this.rewriteInvokeMethodWithConstantValues(code, callingContext, affectedValues, blocks, iterator2, current.asInvokeMethod());
                    continue;
                }
                if (!current.isStaticGet()) continue;
                this.rewriteStaticGetWithConstantValues(code, isProcessedConcurrently, affectedValues, blocks, iterator2, current.asStaticGet());
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView, code.method).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    private static class ProguardMemberRuleLookup {
        final RuleType type;
        final ProguardMemberRule rule;

        ProguardMemberRuleLookup(RuleType type, ProguardMemberRule rule) {
            this.type = type;
            this.rule = rule;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProguardMemberRuleLookup)) {
                return false;
            }
            ProguardMemberRuleLookup otherLookup = (ProguardMemberRuleLookup)other;
            return this.type == otherLookup.type && this.rule == otherLookup.rule;
        }

        public int hashCode() {
            return this.type.ordinal() * 31 + this.rule.hashCode();
        }
    }

    private static enum RuleType {
        NONE,
        ASSUME_NO_SIDE_EFFECTS,
        ASSUME_VALUES;

    }
}

