/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.utils.MethodSignatureEquivalence;

public class MethodPoolCollection
extends MemberPoolCollection<DexMethod> {
    public MethodPoolCollection(AppView<? extends AppInfoWithSubtyping> appView) {
        super(appView, MethodSignatureEquivalence.get());
    }

    @Override
    Runnable computeMemberPoolForClass(DexClass clazz) {
        return () -> {
            DexClass superClazz;
            MemberPoolCollection.MemberPool methodPool = this.memberPools.computeIfAbsent(clazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
            clazz.forEachMethod(encodedMethod -> {
                if (!encodedMethod.isPrivateMethod() || encodedMethod.isStatic()) {
                    methodPool.seen(this.equivalence.wrap(encodedMethod.method));
                }
            });
            if (clazz.superType != null && (superClazz = this.appView.definitionFor(clazz.superType)) != null) {
                MemberPoolCollection.MemberPool superPool = this.memberPools.computeIfAbsent(superClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
                superPool.linkSubtype(methodPool);
                methodPool.linkSupertype(superPool);
            }
            if (clazz.isInterface()) {
                for (DexType subtype : ((AppInfoWithSubtyping)this.appView.appInfo()).allImmediateSubtypes(clazz.type)) {
                    DexClass subClazz = this.appView.definitionFor(subtype);
                    if (subClazz == null) continue;
                    MemberPoolCollection.MemberPool childPool = this.memberPools.computeIfAbsent(subClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
                    methodPool.linkSubtype(childPool);
                    childPool.linkInterface(methodPool);
                }
            }
        };
    }
}

