/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServiceLoaderRewriter {
    public static void rewrite(IRCode code, AppView<? extends AppInfoWithLiveness> appView) {
        DexItemFactory factory = appView.dexItemFactory();
        InstructionIterator instructionIterator = code.instructionIterator();
        while (instructionIterator.hasNext()) {
            boolean isGetClassLoaderOnConstClassOrNull;
            Value argument;
            InvokeStatic serviceLoaderLoad;
            Value serviceLoaderLoadOut;
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!instruction.isInvokeStatic() || instruction.asInvokeStatic().getInvokedMethod() != factory.serviceLoaderMethods.loadWithClassLoader || (serviceLoaderLoadOut = (serviceLoaderLoad = instruction.asInvokeStatic()).outValue()).numberOfAllUsers() != 1 || serviceLoaderLoadOut.numberOfPhiUsers() != 0 || !serviceLoaderLoadOut.singleUniqueUser().isInvokeVirtual() || serviceLoaderLoadOut.singleUniqueUser().asInvokeVirtual().getInvokedMethod() != factory.serviceLoaderMethods.iterator || (argument = serviceLoaderLoad.inValues().get(0).getAliasedValue()).isPhi() || !argument.definition.isConstClass()) continue;
            ConstClass constClass = serviceLoaderLoad.inValues().get(0).getAliasedValue().getConstInstruction().asConstClass();
            if (appView.appInfo().isPinned(constClass.getValue()) || !appView.appServices().allServiceTypes().contains(constClass.getValue())) continue;
            InvokeVirtual classLoaderInvoke = serviceLoaderLoad.inValues().get((int)1).definition.asInvokeVirtual();
            boolean bl = isGetClassLoaderOnConstClassOrNull = serviceLoaderLoad.inValues().get(1).getTypeLattice().isNullType() || classLoaderInvoke != null && classLoaderInvoke.inValues().size() == 1 && classLoaderInvoke.getReceiver().getAliasedValue().isConstClass() && classLoaderInvoke.getReceiver().getAliasedValue().getConstInstruction().asConstClass().getValue() == constClass.getValue();
            if (!isGetClassLoaderOnConstClassOrNull) continue;
            List<DexType> dexTypes = appView.appServices().serviceImplementationsFor(constClass.getValue());
            ArrayList<DexClass> classes = new ArrayList<DexClass>(dexTypes.size());
            boolean seenNull = false;
            for (DexType serviceImpl : dexTypes) {
                DexClass serviceImplClazz = appView.definitionFor(serviceImpl);
                if (serviceImplClazz == null) {
                    seenNull = true;
                }
                classes.add(serviceImplClazz);
            }
            if (seenNull) continue;
            new Rewriter(appView, code, instructionIterator, serviceLoaderLoad).perform(classLoaderInvoke, constClass.getValue(), classes);
        }
    }

    private static class Rewriter {
        private final AppView appView;
        private final DexItemFactory factory;
        private final IRCode code;
        private final InvokeStatic serviceLoaderLoad;
        private InstructionIterator iterator;
        private MemberType memberType;
        private Value valueArray;
        private int index = 0;

        public Rewriter(AppView appView, IRCode code, InstructionIterator iterator2, InvokeStatic serviceLoaderLoad) {
            this.appView = appView;
            this.factory = appView.dexItemFactory();
            this.iterator = iterator2;
            this.code = code;
            this.serviceLoaderLoad = serviceLoaderLoad;
        }

        public void perform(InvokeVirtual classLoaderInvoke, DexType dexType, List<DexClass> classes) {
            assert (this.valueArray == null);
            assert (this.memberType == null);
            if (classLoaderInvoke != null) {
                this.clearGetClassLoader(classLoaderInvoke);
                this.iterator.nextUntil(i -> i == this.serviceLoaderLoad);
            }
            InvokeVirtual serviceLoaderIterator = this.serviceLoaderLoad.outValue().singleUniqueUser().asInvokeVirtual();
            this.iterator.replaceCurrentInstruction(this.code.createConstNull());
            ConstNumber arrayLength = this.code.createIntConstant(classes.size());
            arrayLength.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(arrayLength);
            DexType arrayType = this.factory.createArrayType(1, dexType);
            TypeLatticeElement arrayLatticeElement = TypeLatticeElement.fromDexType(arrayType, Nullability.definitelyNotNull(), this.appView);
            this.valueArray = this.code.createValue(arrayLatticeElement);
            NewArrayEmpty newArrayEmpty = new NewArrayEmpty(this.valueArray, arrayLength.outValue(), arrayType);
            newArrayEmpty.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(newArrayEmpty);
            this.memberType = MemberType.fromDexType(dexType);
            classes.forEach(this::addNewServiceAndPutInArray);
            Value vArrayAsList = this.code.createValue(TypeLatticeElement.fromDexType(this.factory.listType, Nullability.definitelyNotNull(), this.appView));
            InvokeStatic arraysAsList = new InvokeStatic(this.factory.utilArraysMethods.asList, vArrayAsList, ImmutableList.of(this.valueArray));
            arraysAsList.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(arraysAsList);
            this.iterator.nextUntil(x -> x == serviceLoaderIterator);
            DexMethod method = this.factory.createMethod(this.factory.listType, this.factory.createProto(this.factory.iteratorType, new DexType[0]), "iterator");
            InvokeInterface arrayIterator = new InvokeInterface(method, serviceLoaderIterator.outValue(), ImmutableList.of(vArrayAsList));
            this.iterator.replaceCurrentInstruction(arrayIterator);
        }

        private void addNewServiceAndPutInArray(DexClass clazz) {
            ConstNumber indexInArray = this.code.createIntConstant(this.index++);
            indexInArray.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(indexInArray);
            TypeLatticeElement clazzLatticeElement = TypeLatticeElement.fromDexType(clazz.type, Nullability.definitelyNotNull(), this.appView);
            Value vInstance = this.code.createValue(clazzLatticeElement);
            NewInstance newInstance = new NewInstance(clazz.type, vInstance);
            newInstance.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(newInstance);
            DexMethod method = clazz.getDefaultInitializer().method;
            assert (method.getArity() == 0);
            InvokeDirect invokeDirect = new InvokeDirect(method, null, Collections.singletonList(vInstance));
            invokeDirect.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(invokeDirect);
            ArrayPut put = new ArrayPut(this.memberType, this.valueArray, indexInArray.outValue(), vInstance);
            put.setPosition(this.serviceLoaderLoad.getPosition());
            this.iterator.add(put);
        }

        private void clearGetClassLoader(InvokeVirtual classLoaderInvoke) {
            while (this.iterator.hasPrevious()) {
                Instruction instruction = (Instruction)this.iterator.previous();
                if (instruction != classLoaderInvoke) continue;
                this.iterator.replaceCurrentInstruction(this.code.createConstNull());
                break;
            }
        }
    }
}

