/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SwitchMapCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexString switchMapPrefix;
    private final DexType intArrayType;
    private final Map<DexField, Int2ReferenceMap<DexField>> switchMaps = new IdentityHashMap<DexField, Int2ReferenceMap<DexField>>();

    public SwitchMapCollector(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.switchMapPrefix = appView.dexItemFactory().createString("$SwitchMap$");
        this.intArrayType = appView.dexItemFactory().createType("[I");
    }

    public AppInfoWithLiveness run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.processClasses(clazz);
        }
        if (!this.switchMaps.isEmpty()) {
            return this.appView.appInfo().addSwitchMaps(this.switchMaps);
        }
        return this.appView.appInfo();
    }

    private void processClasses(DexProgramClass clazz) {
        if (!clazz.accessFlags.isSynthetic() && !clazz.hasClassInitializer()) {
            return;
        }
        List<DexEncodedField> switchMapFields = clazz.staticFields().stream().filter(this::maybeIsSwitchMap).collect(Collectors.toList());
        if (!switchMapFields.isEmpty()) {
            IRCode initializer = clazz.getClassInitializer().buildIR(this.appView, clazz.origin);
            switchMapFields.forEach(field -> this.extractSwitchMap((DexEncodedField)field, initializer));
        }
    }

    private void extractSwitchMap(DexEncodedField encodedField, IRCode initializer) {
        Instruction insn;
        DexField field = encodedField.field;
        Int2ReferenceArrayMap<DexField> switchMap = new Int2ReferenceArrayMap<DexField>();
        InstructionIterator it = initializer.instructionIterator();
        Predicate<Instruction> predicate = i -> i.isStaticGet() && i.asStaticGet().getField() == field;
        while ((insn = it.nextUntil(predicate)) != null) {
            for (Instruction use : insn.outValue().uniqueUsers()) {
                if (use.isArrayPut()) {
                    Instruction index = use.asArrayPut().value().definition;
                    if (index == null || !index.isConstNumber()) {
                        return;
                    }
                    int integerIndex = index.asConstNumber().getIntValue();
                    Instruction value = use.asArrayPut().index().definition;
                    if (value == null || !value.isInvokeVirtual()) {
                        return;
                    }
                    InvokeVirtual invoke = value.asInvokeVirtual();
                    DexClass holder = this.appView.definitionFor(invoke.getInvokedMethod().holder);
                    if (holder == null || !holder.accessFlags.isEnum() && holder.type != this.appView.dexItemFactory().enumType) {
                        return;
                    }
                    Instruction enumGet = invoke.arguments().get((int)0).definition;
                    if (enumGet == null || !enumGet.isStaticGet()) {
                        return;
                    }
                    DexField enumField = enumGet.asStaticGet().getField();
                    if (!this.appView.definitionFor((DexType)enumField.holder).accessFlags.isEnum()) {
                        return;
                    }
                    if (switchMap.put(integerIndex, enumField) == null) continue;
                    return;
                }
                return;
            }
        }
        this.switchMaps.put(field, switchMap);
    }

    private boolean maybeIsSwitchMap(DexEncodedField dexEncodedField) {
        DexField field = dexEncodedField.field;
        return dexEncodedField.accessFlags.isSynthetic() && field.name.startsWith(this.switchMapPrefix) && field.type == this.intArrayType;
    }
}

