/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.ir.analysis.AbstractError;
import com.android.tools.r8.ir.analysis.TypeChecker;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ArgumentRemovalUtils;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class UninstantiatedTypeOptimization {
    private static final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
    private final AppView<AppInfoWithLiveness> appView;
    private final TypeChecker typeChecker;
    private int numberOfInstanceGetOrInstancePutWithNullReceiver = 0;
    private int numberOfArrayInstructionsWithNullArray = 0;
    private int numberOfInvokesWithNullArgument = 0;
    private int numberOfInvokesWithNullReceiver = 0;
    private int numberOfMonitorWithNullReceiver = 0;

    public UninstantiatedTypeOptimization(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.typeChecker = new TypeChecker(appView);
    }

    public GraphLense run(MethodPoolCollection methodPoolCollection, ExecutorService executorService, Timing timing) {
        try {
            methodPoolCollection.buildAll(executorService, timing);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap changedVirtualMethods = new HashMap();
        HashBiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
        IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod = new IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>();
        TopDownClassHierarchyTraversal.forProgramClasses(this.appView).visit((Iterable)this.appView.appInfo().classes(), clazz -> this.processClass((DexProgramClass)clazz, changedVirtualMethods, (BiMap<DexMethod, DexMethod>)methodMapping, methodPoolCollection, (Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>)removedArgumentsInfoPerMethod));
        if (!methodMapping.isEmpty()) {
            return new UninstantiatedTypeOptimizationGraphLense(methodMapping, removedArgumentsInfoPerMethod, this.appView);
        }
        return this.appView.graphLense();
    }

    private void processClass(DexProgramClass clazz, Map<Equivalence.Wrapper<DexMethod>, Set<DexType>> changedVirtualMethods, BiMap<DexMethod, DexMethod> methodMapping, MethodPoolCollection methodPoolCollection, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod) {
        Equivalence.Wrapper<DexMethod> wrapper;
        DexMethod newMethod;
        GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo;
        GraphLense.RewrittenPrototypeDescription prototypeChanges;
        DexMethod method;
        DexEncodedMethod encodedMethod;
        int i;
        MemberPoolCollection.MemberPool<DexMethod> methodPool = methodPoolCollection.get(clazz);
        if (clazz.isInterface()) {
            for (DexEncodedMethod virtualMethod : clazz.virtualMethods()) {
                DexMethod newMethod2;
                Equivalence.Wrapper<DexMethod> wrapper2;
                GraphLense.RewrittenPrototypeDescription rewrittenPrototypeDescription = new GraphLense.RewrittenPrototypeDescription(virtualMethod.method.proto.returnType.isAlwaysNull(this.appView), this.getRemovedArgumentsInfo(virtualMethod, Strategy.ALLOW_ARGUMENT_REMOVAL));
                if (rewrittenPrototypeDescription.isEmpty() || methodPool.hasSeenDirectly(wrapper2 = equivalence.wrap(newMethod2 = this.getNewMethodSignature(virtualMethod, rewrittenPrototypeDescription)))) continue;
                methodPool.seen(wrapper2);
            }
            return;
        }
        IdentityHashMap<DexEncodedMethod, GraphLense.RewrittenPrototypeDescription> prototypeChangesPerMethod = new IdentityHashMap<DexEncodedMethod, GraphLense.RewrittenPrototypeDescription>();
        for (DexEncodedMethod dexEncodedMethod : clazz.directMethods()) {
            GraphLense.RewrittenPrototypeDescription prototypeChanges3 = this.getPrototypeChanges(dexEncodedMethod, Strategy.ALLOW_ARGUMENT_REMOVAL);
            if (prototypeChanges3.isEmpty()) continue;
            prototypeChangesPerMethod.put(dexEncodedMethod, prototypeChanges3);
        }
        HashSet<Equivalence.Wrapper<DexMethod>> usedSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();
        for (DexEncodedMethod method2 : clazz.methods()) {
            if (prototypeChangesPerMethod.containsKey(method2)) continue;
            usedSignatures.add(equivalence.wrap(method2.method));
        }
        List<DexEncodedMethod> list = clazz.directMethods();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Equivalence.Wrapper<DexMethod> wrapper3;
            DexEncodedMethod encodedMethod2 = list.get(i2);
            DexMethod method3 = encodedMethod2.method;
            GraphLense.RewrittenPrototypeDescription prototypeChanges4 = prototypeChangesPerMethod.getOrDefault(encodedMethod2, GraphLense.RewrittenPrototypeDescription.none());
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo2 = prototypeChanges4.getRemovedArgumentsInfo();
            DexMethod newMethod3 = this.getNewMethodSignature(encodedMethod2, prototypeChanges4);
            if (newMethod3 == method3 || !usedSignatures.add(wrapper3 = equivalence.wrap(newMethod3))) continue;
            clazz.setDirectMethod(i2, encodedMethod2.toTypeSubstitutedMethod(newMethod3, removedArgumentsInfo2.createParameterAnnotationsRemover(encodedMethod2)));
            methodMapping.put(method3, newMethod3);
            if (!removedArgumentsInfo2.hasRemovedArguments()) continue;
            removedArgumentsInfoPerMethod.put(newMethod3, removedArgumentsInfo2);
        }
        List<DexEncodedMethod> virtualMethods = clazz.virtualMethods();
        for (i = 0; i < virtualMethods.size(); ++i) {
            encodedMethod = virtualMethods.get(i);
            method = encodedMethod.method;
            prototypeChanges = this.getPrototypeChanges(encodedMethod, Strategy.DISALLOW_ARGUMENT_REMOVAL);
            removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
            newMethod = this.getNewMethodSignature(encodedMethod, prototypeChanges);
            if (newMethod == method) continue;
            wrapper = equivalence.wrap(newMethod);
            boolean isOverrideOfPreviouslyChangedMethodInSuperClass = ((Set)changedVirtualMethods.getOrDefault(equivalence.wrap(method), ImmutableSet.of())).stream().anyMatch(other -> this.appView.appInfo().isSubtype(clazz.type, (DexType)other));
            if (!isOverrideOfPreviouslyChangedMethodInSuperClass) continue;
            assert (methodPool.hasSeen(wrapper));
            boolean signatureIsAvailable = usedSignatures.add(wrapper);
            assert (signatureIsAvailable);
            clazz.setVirtualMethod(i, encodedMethod.toTypeSubstitutedMethod(newMethod, removedArgumentsInfo.createParameterAnnotationsRemover(encodedMethod)));
            methodMapping.put(method, newMethod);
        }
        for (i = 0; i < virtualMethods.size(); ++i) {
            encodedMethod = virtualMethods.get(i);
            method = encodedMethod.method;
            prototypeChanges = this.getPrototypeChanges(encodedMethod, Strategy.DISALLOW_ARGUMENT_REMOVAL);
            removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
            newMethod = this.getNewMethodSignature(encodedMethod, prototypeChanges);
            if (newMethod == method || methodPool.hasSeen(wrapper = equivalence.wrap(newMethod)) || !usedSignatures.add(wrapper)) continue;
            methodPool.seen(wrapper);
            clazz.setVirtualMethod(i, encodedMethod.toTypeSubstitutedMethod(newMethod, removedArgumentsInfo.createParameterAnnotationsRemover(encodedMethod)));
            methodMapping.put(method, newMethod);
            boolean added = changedVirtualMethods.computeIfAbsent(equivalence.wrap(method), key -> Sets.newIdentityHashSet()).add(clazz.type);
            assert (added);
        }
    }

    private GraphLense.RewrittenPrototypeDescription getPrototypeChanges(DexEncodedMethod encodedMethod, Strategy strategy) {
        if (ArgumentRemovalUtils.isPinned(encodedMethod, this.appView) || this.appView.appInfo().keepConstantArguments.contains(encodedMethod.method)) {
            return GraphLense.RewrittenPrototypeDescription.none();
        }
        return new GraphLense.RewrittenPrototypeDescription(encodedMethod.method.proto.returnType.isAlwaysNull(this.appView), this.getRemovedArgumentsInfo(encodedMethod, strategy));
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo getRemovedArgumentsInfo(DexEncodedMethod encodedMethod, Strategy strategy) {
        if (strategy == Strategy.DISALLOW_ARGUMENT_REMOVAL) {
            return GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo.empty();
        }
        ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo> removedArgumentsInfo = null;
        DexProto proto = encodedMethod.method.proto;
        int offset = encodedMethod.isStatic() ? 0 : 1;
        for (int i = 0; i < proto.parameters.size(); ++i) {
            DexType type = proto.parameters.values[i];
            if (!type.isAlwaysNull(this.appView)) continue;
            if (removedArgumentsInfo == null) {
                removedArgumentsInfo = new ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo>();
            }
            removedArgumentsInfo.add(GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo.builder().setArgumentIndex(i + offset).setIsAlwaysNull().setType(type).build());
        }
        return removedArgumentsInfo != null ? new GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo(removedArgumentsInfo) : GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo.empty();
    }

    private DexMethod getNewMethodSignature(DexEncodedMethod encodedMethod, GraphLense.RewrittenPrototypeDescription prototypeChanges) {
        DexType[] newParameters;
        DexType newReturnType;
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexMethod method = encodedMethod.method;
        GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
        if (prototypeChanges.isEmpty()) {
            return method;
        }
        DexType dexType = newReturnType = prototypeChanges.hasBeenChangedToReturnVoid() ? dexItemFactory.voidType : method.proto.returnType;
        if (removedArgumentsInfo.hasRemovedArguments()) {
            assert (encodedMethod.isStatic() || !removedArgumentsInfo.isArgumentRemoved(0));
            newParameters = new DexType[method.proto.parameters.size() - removedArgumentsInfo.numberOfRemovedArguments()];
            int offset = encodedMethod.isStatic() ? 0 : 1;
            int newParametersIndex = 0;
            for (int argumentIndex = 0; argumentIndex < method.proto.parameters.size(); ++argumentIndex) {
                if (removedArgumentsInfo.isArgumentRemoved(argumentIndex + offset)) continue;
                newParameters[newParametersIndex] = method.proto.parameters.values[argumentIndex];
                ++newParametersIndex;
            }
        } else {
            newParameters = method.proto.parameters.values;
        }
        return dexItemFactory.createMethod(method.holder, dexItemFactory.createProto(newReturnType, newParameters), method.name);
    }

    public void rewrite(IRCode code) {
        Set<BasicBlock> blocksToBeRemoved = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocksToBeRemoved.contains(block)) continue;
            InstructionListIterator instructionIterator = block.listIterator();
            while (instructionIterator.hasNext()) {
                Value couldBeNullValue;
                Instruction instruction = (Instruction)instructionIterator.next();
                if (instruction.throwsOnNullInput() && UninstantiatedTypeOptimization.isThrowNullCandidate(couldBeNullValue = instruction.getNonNullInput(), instruction, this.appView, code.method.method.holder)) {
                    if (instruction.isInstanceGet() || instruction.isInstancePut()) {
                        ++this.numberOfInstanceGetOrInstancePutWithNullReceiver;
                    } else if (instruction.isInvokeMethodWithReceiver()) {
                        ++this.numberOfInvokesWithNullReceiver;
                    } else if (instruction.isArrayGet() || instruction.isArrayPut() || instruction.isArrayLength()) {
                        ++this.numberOfArrayInstructionsWithNullArray;
                    } else if (instruction.isMonitor()) {
                        ++this.numberOfMonitorWithNullReceiver;
                    } else assert (false);
                    instructionIterator.replaceCurrentInstructionWithThrowNull(this.appView, code, blockIterator, blocksToBeRemoved);
                    continue;
                }
                if (instruction.isFieldInstruction()) {
                    this.rewriteFieldInstruction(instruction.asFieldInstruction(), blockIterator, instructionIterator, code, blocksToBeRemoved);
                    continue;
                }
                if (!instruction.isInvokeMethod()) continue;
                this.rewriteInvoke(instruction.asInvokeMethod(), blockIterator, instructionIterator, code, blocksToBeRemoved);
            }
        }
        code.removeBlocks(blocksToBeRemoved);
        code.removeAllTrivialPhis();
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    private static boolean isThrowNullCandidate(Value couldBeNullValue, Instruction current, AppView<? extends AppInfoWithSubtyping> appView, DexType context) {
        AbstractError abstractError;
        if (!couldBeNullValue.isAlwaysNull(appView)) {
            return false;
        }
        return !current.isFieldInstruction() || !(abstractError = current.asFieldInstruction().instructionInstanceCanThrow(appView, context)).isThrowing() || abstractError.getSpecificError(appView.dexItemFactory()) == appView.dexItemFactory().npeType;
    }

    public void logResults() {
        assert (false);
        Log.info(this.getClass(), "Number of instance-get/instance-put with null receiver: %s", this.numberOfInstanceGetOrInstancePutWithNullReceiver);
        Log.info(this.getClass(), "Number of array instructions with null reference: %s", this.numberOfArrayInstructionsWithNullArray);
        Log.info(this.getClass(), "Number of invokes with null argument: %s", this.numberOfInvokesWithNullArgument);
        Log.info(this.getClass(), "Number of invokes with null receiver: %s", this.numberOfInvokesWithNullReceiver);
        Log.info(this.getClass(), "Number of monitor with null receiver: %s", this.numberOfMonitorWithNullReceiver);
    }

    private void rewriteFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        DexType fieldType = instruction.getField().type;
        if (fieldType.isAlwaysNull(this.appView)) {
            DexClass enclosingClass;
            AbstractError abstractError = instruction.instructionInstanceCanThrow(this.appView, code.method.method.holder);
            if (abstractError.isThrowing()) {
                return;
            }
            DexEncodedField field = this.appView.appInfo().resolveField(instruction.getField());
            if (field == null) {
                assert (false) : "Expected field-instruction with non-existent field to throw";
                return;
            }
            if (field.field.holder != code.method.method.holder && ((enclosingClass = this.appView.definitionFor(code.method.method.holder)) == null || enclosingClass.classInitializationMayHaveSideEffects(this.appView.appInfo()))) {
                return;
            }
            BasicBlock block = instruction.getBlock();
            if (instruction.isFieldPut()) {
                if (!this.typeChecker.checkFieldPut(instruction)) {
                    assert (this.appView.options().testing.allowTypeErrors);
                    return;
                }
                instructionIterator.removeOrReplaceByDebugLocalRead();
            } else {
                instructionIterator.replaceCurrentInstruction(code.createConstNull());
            }
            if (block.hasCatchHandlers()) {
                block.getCatchHandlers().getUniqueTargets().forEach(BasicBlock::unlinkCatchHandler);
            }
        }
    }

    private void rewriteInvoke(InvokeMethod invoke, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        DexEncodedMethod target = invoke.lookupSingleTarget(this.appView, code.method.method.holder);
        if (target == null) {
            return;
        }
        BitSet facts = target.getOptimizationInfo().getNonNullParamOrThrow();
        if (facts != null) {
            for (int i = 0; i < invoke.arguments().size(); ++i) {
                Value argument = invoke.arguments().get(i);
                if (!argument.isAlwaysNull(this.appView) || !facts.get(i)) continue;
                instructionIterator.replaceCurrentInstructionWithThrowNull(this.appView, code, blockIterator, blocksToBeRemoved);
                ++this.numberOfInvokesWithNullArgument;
                return;
            }
        }
    }

    static class UninstantiatedTypeOptimizationGraphLense
    extends GraphLense.NestedGraphLense {
        private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod;

        UninstantiatedTypeOptimizationGraphLense(BiMap<DexMethod, DexMethod> methodMap, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod, AppView<?> appView) {
            super(ImmutableMap.of(), methodMap, ImmutableMap.of(), null, methodMap.inverse(), appView.graphLense(), appView.dexItemFactory());
            this.removedArgumentsInfoPerMethod = removedArgumentsInfoPerMethod;
        }

        @Override
        public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures.getOrDefault(method, method);
            GraphLense.RewrittenPrototypeDescription result = this.previousLense.lookupPrototypeChanges(originalMethod);
            if (originalMethod != method) {
                GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo;
                if (method.proto.returnType.isVoidType() && !originalMethod.proto.returnType.isVoidType()) {
                    result = result.withConstantReturn();
                }
                if ((removedArgumentsInfo = this.removedArgumentsInfoPerMethod.get(method)) != null) {
                    result = result.withRemovedArguments(removedArgumentsInfo);
                }
            } else assert (!this.removedArgumentsInfoPerMethod.containsKey(method));
            return result;
        }
    }

    static enum Strategy {
        ALLOW_ARGUMENT_REMOVAL,
        DISALLOW_ARGUMENT_REMOVAL;

    }
}

