/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.optimize.ArgumentRemovalUtils;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.SymbolGenerationUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class UnusedArgumentsCollector {
    private static final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
    private final AppView<AppInfoWithLiveness> appView;
    private final MethodPoolCollection methodPoolCollection;
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments = new IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>();

    public UnusedArgumentsCollector(AppView<AppInfoWithLiveness> appView, MethodPoolCollection methodPoolCollection) {
        this.appView = appView;
        this.methodPoolCollection = methodPoolCollection;
    }

    public GraphLense run(ExecutorService executorService, Timing timing) throws ExecutionException {
        ThreadUtils.awaitFutures(Streams.stream(this.appView.appInfo().classes()).map(this::runnableForClass).map(executorService::submit).collect(Collectors.toList()));
        this.methodPoolCollection.buildAll(executorService, timing);
        this.appView.appInfo().classesWithDeterministicOrder().forEach(this::processVirtualMethods);
        if (!this.methodMapping.isEmpty()) {
            return new UnusedArgumentsGraphLense(ImmutableMap.of(), this.methodMapping, ImmutableMap.of(), ImmutableBiMap.of(), this.methodMapping.inverse(), this.appView.graphLense(), this.appView.dexItemFactory(), this.removedArguments);
        }
        return this.appView.graphLense();
    }

    private Runnable runnableForClass(DexProgramClass clazz) {
        return () -> this.processDirectMethods(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectMethods(DexProgramClass clazz) {
        UsedSignatures signatures = new UsedSignatures();
        for (DexEncodedMethod method : clazz.methods()) {
            signatures.markSignatureAsUsed(method.method);
        }
        List<DexEncodedMethod> directMethods = clazz.directMethods();
        for (int i = 0; i < directMethods.size(); ++i) {
            DexEncodedMethod method = directMethods.get(i);
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused = this.collectUnusedArguments(method);
            if (unused == null || !unused.hasRemovedArguments()) continue;
            DexProto newProto = this.createProtoWithRemovedArguments(method, unused);
            DexMethod newSignature = signatures.getNewSignature(method, newProto);
            if (newSignature == null) {
                assert (this.appView.dexItemFactory().isConstructor(method.method));
                continue;
            }
            DexEncodedMethod newMethod = signatures.removeArguments(method, newSignature, unused);
            clazz.setDirectMethod(i, newMethod);
            UnusedArgumentsCollector unusedArgumentsCollector = this;
            synchronized (unusedArgumentsCollector) {
                this.methodMapping.put(method.method, newMethod.method);
                this.removedArguments.put(newMethod.method, unused);
                continue;
            }
        }
    }

    private void processVirtualMethods(DexProgramClass clazz) {
        MemberPoolCollection.MemberPool<DexMethod> methodPool = this.methodPoolCollection.get(clazz);
        GloballyUsedSignatures signatures = new GloballyUsedSignatures(methodPool);
        List<DexEncodedMethod> virtualMethods = clazz.virtualMethods();
        for (int i = 0; i < virtualMethods.size(); ++i) {
            DexEncodedMethod method = virtualMethods.get(i);
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused = this.collectUnusedArguments(method, methodPool);
            if (unused == null || !unused.hasRemovedArguments()) continue;
            DexProto newProto = this.createProtoWithRemovedArguments(method, unused);
            DexMethod newSignature = signatures.getNewSignature(method, newProto);
            assert (!methodPool.hasSeenStrictlyAbove(equivalence.wrap(newSignature)));
            assert (!methodPool.hasSeenStrictlyBelow(equivalence.wrap(newSignature)));
            DexEncodedMethod newMethod = signatures.removeArguments(method, signatures.getNewSignature(method, newProto), unused);
            clazz.setVirtualMethod(i, newMethod);
            this.methodMapping.put(method.method, newMethod.method);
            this.removedArguments.put(newMethod.method, unused);
        }
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo collectUnusedArguments(DexEncodedMethod method) {
        return this.collectUnusedArguments(method, null);
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo collectUnusedArguments(DexEncodedMethod method, MemberPoolCollection.MemberPool<DexMethod> methodPool) {
        if (ArgumentRemovalUtils.isPinned(method, this.appView) || this.appView.appInfo().keepUnusedArguments.contains(method.method)) {
            return null;
        }
        if (method.getCode() == null || !method.getCode().isJarCode()) {
            return null;
        }
        if (method.isVirtualMethod()) {
            assert (methodPool != null);
            Equivalence.Wrapper<DexMethod> wrapper = equivalence.wrap(method.method);
            if (methodPool.hasSeenStrictlyAbove(wrapper) || methodPool.hasSeenStrictlyBelow(wrapper)) {
                return null;
            }
        }
        int offset = method.accessFlags.isStatic() ? 0 : 1;
        int argumentCount = method.method.proto.parameters.size() + offset;
        CollectUsedArguments collector = new CollectUsedArguments();
        if (!method.accessFlags.isStatic()) {
            collector.register(0);
        }
        method.getCode().registerArgumentReferences(method, collector);
        BitSet used = collector.getUsedArguments();
        if (used.cardinality() < argumentCount) {
            ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo> unused = new ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo>();
            for (int argumentIndex = 0; argumentIndex < argumentCount; ++argumentIndex) {
                if (used.get(argumentIndex)) continue;
                unused.add(GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo.builder().setArgumentIndex(argumentIndex).setType(method.method.proto.parameters.values[argumentIndex - offset]).build());
            }
            return new GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo(unused);
        }
        return null;
    }

    private DexProto createProtoWithRemovedArguments(DexEncodedMethod encodedMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
        DexMethod method = encodedMethod.method;
        int firstArgumentIndex = encodedMethod.isStatic() ? 0 : 1;
        int numberOfParameters = method.proto.parameters.size() - unused.numberOfRemovedArguments();
        if (!encodedMethod.isStatic() && unused.isArgumentRemoved(0)) {
            ++numberOfParameters;
        }
        DexType[] parameters = new DexType[numberOfParameters];
        if (numberOfParameters > 0) {
            int newIndex = 0;
            for (int oldIndex = 0; oldIndex < method.proto.parameters.size(); ++oldIndex) {
                if (unused.isArgumentRemoved(oldIndex + firstArgumentIndex)) continue;
                parameters[newIndex++] = method.proto.parameters.values[oldIndex];
            }
            assert (newIndex == parameters.length);
        }
        return this.appView.dexItemFactory().createProto(method.proto.returnType, parameters);
    }

    private static class CollectUsedArguments
    extends ArgumentUse {
        private final BitSet used = new BitSet();

        private CollectUsedArguments() {
        }

        BitSet getUsedArguments() {
            return this.used;
        }

        @Override
        public boolean register(int argument) {
            this.used.set(argument);
            return true;
        }
    }

    private class GloballyUsedSignatures {
        private final MemberPoolCollection.MemberPool<DexMethod> methodPool;

        GloballyUsedSignatures(MemberPoolCollection.MemberPool<DexMethod> methodPool) {
            this.methodPool = methodPool;
        }

        DexMethod getNewSignature(DexEncodedMethod method, DexProto newProto) {
            DexMethod newSignature;
            int count = 0;
            DexString newName = null;
            do {
                if (newName == null) {
                    newName = method.method.name;
                } else if (!UnusedArgumentsCollector.this.appView.dexItemFactory().isConstructor(method.method)) {
                    newName = UnusedArgumentsCollector.this.appView.dexItemFactory().createString(method.method.name.toSourceString() + count);
                } else {
                    return null;
                }
                newSignature = UnusedArgumentsCollector.this.appView.dexItemFactory().createMethod(method.method.holder, newProto, newName);
                ++count;
            } while (this.methodPool.hasSeen(equivalence.wrap(newSignature)));
            return newSignature;
        }

        DexEncodedMethod removeArguments(DexEncodedMethod method, DexMethod newSignature, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            this.methodPool.seen(equivalence.wrap(newSignature));
            return method.toTypeSubstitutedMethod(newSignature, unused.createParameterAnnotationsRemover(method));
        }
    }

    private class UsedSignatures {
        private final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        private final Set<Equivalence.Wrapper<DexMethod>> usedSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();

        private UsedSignatures() {
        }

        private boolean isMethodSignatureAvailable(DexMethod method) {
            return !this.usedSignatures.contains(this.equivalence.wrap(method));
        }

        private void markSignatureAsUsed(DexMethod method) {
            this.usedSignatures.add(this.equivalence.wrap(method));
        }

        DexMethod getNewSignature(DexEncodedMethod method, DexProto newProto) {
            DexMethod newSignature;
            int count = 0;
            DexString newName = null;
            do {
                if (newName == null) {
                    newName = method.method.name;
                } else if (!UnusedArgumentsCollector.this.appView.dexItemFactory().isConstructor(method.method)) {
                    newName = UnusedArgumentsCollector.this.appView.dexItemFactory().createString(SymbolGenerationUtils.numberToIdentifier(count, SymbolGenerationUtils.MixedCasing.USE_MIXED_CASE, method.method.name.toSourceString().toCharArray()));
                } else {
                    return null;
                }
                newSignature = UnusedArgumentsCollector.this.appView.dexItemFactory().createMethod(method.method.holder, newProto, newName);
                ++count;
            } while (!this.isMethodSignatureAvailable(newSignature));
            return newSignature;
        }

        DexEncodedMethod removeArguments(DexEncodedMethod method, DexMethod newSignature, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            boolean removed = this.usedSignatures.remove(this.equivalence.wrap(method.method));
            assert (removed);
            this.markSignatureAsUsed(newSignature);
            return method.toTypeSubstitutedMethod(newSignature, unused.createParameterAnnotationsRemover(method));
        }
    }

    static class UnusedArgumentsGraphLense
    extends GraphLense.NestedGraphLense {
        private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments;

        UnusedArgumentsGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments) {
            super(typeMap, methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, dexItemFactory);
            this.removedArguments = removedArguments;
        }

        @Override
        public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            GraphLense.RewrittenPrototypeDescription result = this.previousLense.lookupPrototypeChanges(originalMethod);
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArguments = this.removedArguments.get(method);
            return removedArguments != null ? result.withRemovedArguments(removedArguments) : result;
        }
    }
}

