/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import com.android.tools.r8.ir.optimize.string.StringOptimizer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ClassInliner {
    private final LambdaRewriter lambdaRewriter;
    private final ConcurrentHashMap<DexClass, Boolean> knownClasses = new ConcurrentHashMap();

    public ClassInliner(LambdaRewriter lambdaRewriter) {
        this.lambdaRewriter = lambdaRewriter;
    }

    public final void processMethodCode(AppView<AppInfoWithLiveness> appView, CodeRewriter codeRewriter, StringOptimizer stringOptimizer, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, Inliner inliner, Supplier<InliningOracle> defaultOracle) {
        boolean repeat;
        List roots = Streams.stream(code.instructionIterator()).filter(insn -> insn.isNewInstance() || insn.isStaticGet()).collect(Collectors.toList());
        boolean anyInlinedMethods = false;
        do {
            repeat = false;
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                Instruction root = (Instruction)rootsIterator.next();
                InlineCandidateProcessor processor = new InlineCandidateProcessor(appView, this.lambdaRewriter, inliner, clazz -> this.isClassEligible(appView, (DexClass)clazz), isProcessedConcurrently, method, root);
                if (!processor.isInstanceEligible() || !processor.isClassAndUsageEligible()) {
                    rootsIterator.remove();
                    continue;
                }
                InstructionOrPhi ineligibleUser = processor.areInstanceUsersEligible(defaultOracle);
                if (ineligibleUser != null || processor.getEstimatedCombinedSizeForInlining() >= appView.options().classInliningInstructionLimit) continue;
                anyInlinedMethods |= processor.processInlining(code, defaultOracle);
                code.removeAllTrivialPhis();
                assert (code.isConsistentSSA());
                rootsIterator.remove();
                repeat = true;
            }
        } while (repeat);
        if (anyInlinedMethods) {
            boolean isDebugMode;
            codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
            codeRewriter.simplifyIf(code);
            boolean bl = isDebugMode = appView.options().debug || method.getOptimizationInfo().isReachabilitySensitive();
            if (!isDebugMode) {
                stringOptimizer.computeTrivialOperationsOnConstString(code);
                stringOptimizer.removeTrivialConversions(code);
            }
        }
    }

    private boolean isClassEligible(AppView<AppInfoWithLiveness> appView, DexClass clazz) {
        Boolean eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            boolean computed = this.computeClassEligible(appView, clazz);
            Boolean existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private boolean computeClassEligible(AppView<AppInfoWithLiveness> appView, DexClass clazz) {
        if (clazz == null || clazz.isNotProgramClass() || clazz.accessFlags.isAbstract() || clazz.accessFlags.isInterface() || appView.appInfo().neverClassInline.contains(clazz.type)) {
            return false;
        }
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (method.method.name != dexItemFactory.finalizeMethodName || method.method.proto != dexItemFactory.objectMethods.finalize.proto) continue;
            return false;
        }
        return !clazz.initializationOfParentTypesMayHaveSideEffects(appView.appInfo());
    }
}

