/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class FieldValueHelper {
    private final DexField field;
    private final IRCode code;
    private final Instruction root;
    private final AppView<?> appView;
    private Value defaultValue = null;
    private final Map<BasicBlock, Value> ins = new IdentityHashMap<BasicBlock, Value>();
    private final Map<BasicBlock, Value> outs = new IdentityHashMap<BasicBlock, Value>();

    FieldValueHelper(DexField field, IRCode code, Instruction root, AppView<?> appView) {
        this.field = field;
        this.code = code;
        this.root = root;
        this.appView = appView;
    }

    void replaceValue(Value oldValue, Value newValue) {
        for (Map.Entry<BasicBlock, Value> entry : this.ins.entrySet()) {
            if (entry.getValue() != oldValue) continue;
            entry.setValue(newValue);
        }
        for (Map.Entry<BasicBlock, Value> entry : this.outs.entrySet()) {
            if (entry.getValue() != oldValue) continue;
            entry.setValue(newValue);
        }
    }

    Value getValueForFieldRead(BasicBlock block, Instruction valueUser) {
        assert (valueUser != null);
        Value value = this.getValueDefinedInTheBlock(block, valueUser);
        return value != null ? value : this.getOrCreateInValue(block);
    }

    private Value getOrCreateOutValue(BasicBlock block) {
        Value value = this.outs.get(block);
        if (value != null) {
            return value;
        }
        value = this.getValueDefinedInTheBlock(block, null);
        if (value == null) {
            value = this.getOrCreateInValue(block);
        }
        assert (value != null);
        this.outs.put(block, value);
        return value;
    }

    private Value getOrCreateInValue(BasicBlock block) {
        Value value = this.ins.get(block);
        if (value != null) {
            return value;
        }
        List<BasicBlock> predecessors = block.getPredecessors();
        if (predecessors.size() == 1) {
            value = this.getOrCreateOutValue(predecessors.get(0));
            this.ins.put(block, value);
        } else {
            Phi phi = new Phi(this.code.valueNumberGenerator.next(), block, TypeLatticeElement.fromDexType(this.field.type, Nullability.maybeNull(), this.appView), null, Phi.RegisterReadType.NORMAL);
            this.ins.put(block, phi);
            ArrayList<Value> operands = new ArrayList<Value>();
            for (BasicBlock predecessor : block.getPredecessors()) {
                operands.add(this.getOrCreateOutValue(predecessor));
            }
            phi.addOperands(operands, false);
            value = phi;
        }
        assert (value != null);
        return value;
    }

    private Value getValueDefinedInTheBlock(BasicBlock block, Instruction stopAt) {
        InstructionListIterator iterator2 = stopAt == null ? block.listIterator(block.getInstructions().size()) : block.listIterator(stopAt);
        Instruction valueProducingInsn = null;
        while (iterator2.hasPrevious()) {
            Instruction instruction = (Instruction)iterator2.previous();
            assert (instruction != null);
            if (instruction != this.root && (!instruction.isInstancePut() || instruction.asInstancePut().getField() != this.field || instruction.asInstancePut().object() != this.root.outValue())) continue;
            valueProducingInsn = instruction;
            break;
        }
        if (valueProducingInsn == null) {
            return null;
        }
        if (valueProducingInsn.isInstancePut()) {
            return valueProducingInsn.asInstancePut().value();
        }
        assert (this.root == valueProducingInsn);
        if (this.defaultValue == null) {
            this.defaultValue = this.code.createValue(TypeLatticeElement.fromDexType(this.field.type, Nullability.maybeNull(), this.appView));
            ConstNumber defaultValueInsn = new ConstNumber(this.defaultValue, 0L);
            defaultValueInsn.setPosition(this.root.getPosition());
            LinkedList<Instruction> instructions = block.getInstructions();
            instructions.add(instructions.indexOf(this.root) + 1, defaultValueInsn);
            defaultValueInsn.setBlock(block);
        }
        return this.defaultValue;
    }
}

