/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.ConstMethodType;
import com.android.tools.r8.ir.code.DefaultInstructionVisitor;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaTypeVisitor;
import com.android.tools.r8.kotlin.Kotlin;
import java.util.ListIterator;
import java.util.function.Function;

public abstract class CodeProcessor
extends DefaultInstructionVisitor<Void> {
    static final Strategy NoOp = new Strategy(){

        @Override
        public LambdaGroup group() {
            return null;
        }

        @Override
        public boolean isValidInstanceFieldWrite(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidInstanceFieldRead(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidStaticFieldWrite(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidStaticFieldRead(CodeProcessor context, DexField field) {
            return false;
        }

        @Override
        public boolean isValidInvoke(CodeProcessor context, InvokeMethod invoke) {
            return false;
        }

        @Override
        public boolean isValidNewInstance(CodeProcessor context, NewInstance invoke) {
            return false;
        }

        @Override
        public void patch(CodeProcessor context, NewInstance newInstance) {
            throw new Unreachable();
        }

        @Override
        public void patch(CodeProcessor context, InvokeMethod invoke) {
            throw new Unreachable();
        }

        @Override
        public void patch(CodeProcessor context, InstancePut instancePut) {
            throw new Unreachable();
        }

        @Override
        public void patch(CodeProcessor context, InstanceGet instanceGet) {
            throw new Unreachable();
        }

        @Override
        public void patch(CodeProcessor context, StaticPut staticPut) {
            throw new Unreachable();
        }

        @Override
        public void patch(CodeProcessor context, StaticGet staticGet) {
            throw new Unreachable();
        }
    };
    public final AppView<?> appView;
    public final DexItemFactory factory;
    public final Kotlin kotlin;
    private final Function<DexType, Strategy> strategyProvider;
    private final LambdaTypeVisitor lambdaChecker;
    public final DexEncodedMethod method;
    public final IRCode code;
    public final ListIterator<BasicBlock> blocks;
    private InstructionListIterator instructions;

    CodeProcessor(AppView<?> appView, Function<DexType, Strategy> strategyProvider, LambdaTypeVisitor lambdaChecker, DexEncodedMethod method, IRCode code) {
        this.appView = appView;
        this.strategyProvider = strategyProvider;
        this.factory = appView.dexItemFactory();
        this.kotlin = this.factory.kotlin;
        this.lambdaChecker = lambdaChecker;
        this.method = method;
        this.code = code;
        this.blocks = code.listIterator();
    }

    public final InstructionListIterator instructions() {
        assert (this.instructions != null);
        return this.instructions;
    }

    final void processCode() {
        while (this.blocks.hasNext()) {
            BasicBlock block = this.blocks.next();
            this.instructions = block.listIterator();
            while (this.instructions.hasNext()) {
                ((Instruction)this.instructions.next()).accept(this);
            }
        }
    }

    @Override
    public Void handleInvoke(Invoke invoke) {
        if (invoke.isInvokeNewArray()) {
            this.lambdaChecker.accept(invoke.asInvokeNewArray().getReturnType());
            return null;
        }
        if (invoke.isInvokeMultiNewArray()) {
            this.lambdaChecker.accept(invoke.asInvokeMultiNewArray().getReturnType());
            return null;
        }
        if (invoke.isInvokeCustom()) {
            this.lambdaChecker.accept(invoke.asInvokeCustom().getCallSite());
            return null;
        }
        InvokeMethod invokeMethod = invoke.asInvokeMethod();
        Strategy strategy = this.strategyProvider.apply(invokeMethod.getInvokedMethod().holder);
        if (strategy.isValidInvoke(this, invokeMethod)) {
            this.lambdaChecker.accept(invokeMethod.getInvokedMethod().proto);
            if (invokeMethod.getInvokedMethod().holder != this.method.method.holder) {
                this.process(strategy, invokeMethod);
            }
            return null;
        }
        if (invoke.isInvokePolymorphic()) {
            this.lambdaChecker.accept(invoke.asInvokePolymorphic().getProto());
        }
        this.lambdaChecker.accept(invokeMethod.getInvokedMethod(), null);
        return null;
    }

    @Override
    public Void visit(NewInstance newInstance) {
        Strategy strategy = this.strategyProvider.apply(newInstance.clazz);
        if (strategy.isValidNewInstance(this, newInstance) && newInstance.clazz != this.method.method.holder) {
            this.process(strategy, newInstance);
        }
        return null;
    }

    @Override
    public Void visit(CheckCast checkCast) {
        this.lambdaChecker.accept(checkCast.getType());
        return null;
    }

    @Override
    public Void visit(NewArrayEmpty newArrayEmpty) {
        this.lambdaChecker.accept(newArrayEmpty.type);
        return null;
    }

    @Override
    public Void visit(ConstClass constClass) {
        this.lambdaChecker.accept(constClass.getValue());
        return null;
    }

    @Override
    public Void visit(ConstMethodType constMethodType) {
        this.lambdaChecker.accept(constMethodType.getValue());
        return null;
    }

    @Override
    public Void visit(ConstMethodHandle constMethodHandle) {
        this.lambdaChecker.accept(constMethodHandle.getValue());
        return null;
    }

    @Override
    public Void visit(InstanceGet instanceGet) {
        DexField field = instanceGet.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidInstanceFieldRead(this, field)) {
            if (field.holder != this.method.method.holder) {
                this.process(strategy, instanceGet);
            }
        } else {
            this.lambdaChecker.accept(field.type);
        }
        this.lambdaChecker.accept(field.type);
        return null;
    }

    @Override
    public Void visit(InstancePut instancePut) {
        DexField field = instancePut.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidInstanceFieldWrite(this, field)) {
            if (field.holder != this.method.method.holder) {
                this.process(strategy, instancePut);
            }
        } else {
            this.lambdaChecker.accept(field.type);
        }
        this.lambdaChecker.accept(field.type);
        return null;
    }

    @Override
    public Void visit(StaticGet staticGet) {
        DexField field = staticGet.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidStaticFieldRead(this, field)) {
            if (field.holder != this.method.method.holder) {
                this.process(strategy, staticGet);
            }
        } else {
            this.lambdaChecker.accept(field.type);
            this.lambdaChecker.accept(field.holder);
        }
        return null;
    }

    @Override
    public Void visit(StaticPut staticPut) {
        DexField field = staticPut.getField();
        Strategy strategy = this.strategyProvider.apply(field.holder);
        if (strategy.isValidStaticFieldWrite(this, field)) {
            if (field.holder != this.method.method.holder) {
                this.process(strategy, staticPut);
            }
        } else {
            this.lambdaChecker.accept(field.type);
            this.lambdaChecker.accept(field.holder);
        }
        return null;
    }

    abstract void process(Strategy var1, InvokeMethod var2);

    abstract void process(Strategy var1, NewInstance var2);

    abstract void process(Strategy var1, InstancePut var2);

    abstract void process(Strategy var1, InstanceGet var2);

    abstract void process(Strategy var1, StaticPut var2);

    abstract void process(Strategy var1, StaticGet var2);

    public static interface Strategy {
        public LambdaGroup group();

        public boolean isValidStaticFieldWrite(CodeProcessor var1, DexField var2);

        public boolean isValidStaticFieldRead(CodeProcessor var1, DexField var2);

        public boolean isValidInstanceFieldWrite(CodeProcessor var1, DexField var2);

        public boolean isValidInstanceFieldRead(CodeProcessor var1, DexField var2);

        public boolean isValidInvoke(CodeProcessor var1, InvokeMethod var2);

        public boolean isValidNewInstance(CodeProcessor var1, NewInstance var2);

        public void patch(CodeProcessor var1, NewInstance var2);

        public void patch(CodeProcessor var1, InvokeMethod var2);

        public void patch(CodeProcessor var1, InstancePut var2);

        public void patch(CodeProcessor var1, InstanceGet var2);

        public void patch(CodeProcessor var1, StaticPut var2);

        public void patch(CodeProcessor var1, StaticGet var2);
    }
}

