/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.ir.optimize.lambda.CodeProcessor;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.LambdaTypeVisitor;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupIdFactory;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class LambdaMerger {
    private final Map<DexType, LambdaGroup> lambdas = new IdentityHashMap<DexType, LambdaGroup>();
    private final Map<LambdaGroupId, LambdaGroup> groups = new LinkedHashMap<LambdaGroupId, LambdaGroup>();
    private final Set<DexType> invalidatedLambdas = Sets.newConcurrentHashSet();
    private final Set<DexEncodedMethod> methodsToReprocess = Sets.newIdentityHashSet();
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final Kotlin kotlin;
    private final DiagnosticsHandler reporter;
    private BiFunction<DexEncodedMethod, IRCode, CodeProcessor> strategyFactory = null;
    private final LambdaTypeVisitor lambdaInvalidator;
    private final LambdaTypeVisitor lambdaChecker;

    public LambdaMerger(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.kotlin = this.factory.kotlin;
        this.reporter = appView.options().reporter;
        this.lambdaInvalidator = new LambdaTypeVisitor(this.factory, this::isMergeableLambda, this::invalidateLambda);
        this.lambdaChecker = new LambdaTypeVisitor(this.factory, this::isMergeableLambda, type -> {
            throw new Unreachable("Unexpected lambda " + type.toSourceString());
        });
    }

    private void invalidateLambda(DexType lambda2) {
        this.invalidatedLambdas.add(lambda2);
    }

    private synchronized boolean isMergeableLambda(DexType lambda2) {
        return this.lambdas.containsKey(lambda2);
    }

    private synchronized LambdaGroup getLambdaGroup(DexType lambda2) {
        return this.lambdas.get(lambda2);
    }

    private synchronized void queueForProcessing(DexEncodedMethod method) {
        this.methodsToReprocess.add(method);
    }

    public final void collectGroupCandidates(DexApplication app, AppView<AppInfoWithLiveness> appView) {
        app.classes().stream().filter(cls -> !((AppInfoWithLiveness)appView.appInfo()).isPinned(cls.type)).filter(cls -> cls.hasKotlinInfo() && cls.getKotlinInfo().isSyntheticClass() && cls.getKotlinInfo().asSyntheticClass().isLambda() && KotlinLambdaGroupIdFactory.hasValidAnnotations(this.kotlin, cls)).sorted((a, b) -> a.type.slowCompareTo(b.type)).forEachOrdered(lambda2 -> {
            block2: {
                try {
                    LambdaGroupId id = KotlinLambdaGroupIdFactory.create(this.kotlin, lambda2, appView.options());
                    LambdaGroup group = this.groups.computeIfAbsent(id, LambdaGroupId::createGroup);
                    group.add((DexProgramClass)lambda2);
                    this.lambdas.put(lambda2.type, group);
                }
                catch (LambdaGroup.LambdaStructureError error) {
                    if (!error.reportable) break block2;
                    this.reporter.info(new StringDiagnostic("Unrecognized Kotlin lambda [" + lambda2.type.toSourceString() + "]: " + error.getMessage()));
                }
            }
        });
        this.removeTrivialLambdaGroups();
        assert (this.strategyFactory == null);
        this.strategyFactory = (x$0, x$1) -> new AnalysisStrategy((DexEncodedMethod)x$0, (IRCode)x$1);
    }

    public final void processMethodCode(DexEncodedMethod method, IRCode code) {
        if (this.strategyFactory != null) {
            this.strategyFactory.apply(method, code).processCode();
        }
    }

    public final void applyLambdaClassMapping(DexApplication app, IRConverter converter, OptimizationFeedback feedback, DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdas.isEmpty()) {
            return;
        }
        this.analyzeReferencesInProgramClasses(app, executorService);
        assert (((AppInfo)this.appView.appInfo()).hasSubtyping());
        AppInfoWithSubtyping appInfoWithSubtyping = ((AppInfo)this.appView.appInfo()).withSubtyping();
        this.analyzeLambdaClassesStructure(appInfoWithSubtyping, executorService);
        Map<LambdaGroup, DexProgramClass> lambdaGroupsClasses = this.finalizeLambdaGroups(appInfoWithSubtyping);
        this.strategyFactory = (x$0, x$1) -> new ApplyStrategy((DexEncodedMethod)x$0, (IRCode)x$1);
        for (Map.Entry<LambdaGroup, DexProgramClass> entry : lambdaGroupsClasses.entrySet()) {
            DexProgramClass synthesizedClass = entry.getValue();
            ((AppInfo)this.appView.appInfo()).addSynthesizedClass(synthesizedClass);
            builder.addSynthesizedClass(synthesizedClass, entry.getKey().shouldAddToMainDex(this.appView));
            synthesizedClass.forEachMethod(encodedMethod -> encodedMethod.markProcessed(Inliner.ConstraintWithTarget.NEVER));
        }
        converter.optimizeSynthesizedClasses(lambdaGroupsClasses.values(), executorService);
        this.rewriteLambdaReferences(converter, executorService, feedback);
        this.strategyFactory = null;
    }

    private void analyzeReferencesInProgramClasses(DexApplication app, ExecutorService service) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (DexProgramClass clazz : app.classes()) {
            futures.add(service.submit(() -> this.analyzeClass(clazz)));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void analyzeLambdaClassesStructure(AppInfoWithSubtyping appInfo, ExecutorService service) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (LambdaGroup group : this.groups.values()) {
            ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> validator = group.lambdaClassValidator(this.kotlin, appInfo);
            group.forEachLambda(info -> futures.add(service.submit(() -> {
                try {
                    validator.accept(info.clazz);
                }
                catch (LambdaGroup.LambdaStructureError error) {
                    if (error.reportable) {
                        this.reporter.info(new StringDiagnostic("Unexpected Kotlin lambda structure [" + info.clazz.type.toSourceString() + "]: " + error.getMessage()));
                    }
                    this.invalidateLambda(info.clazz.type);
                }
            })));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private Map<LambdaGroup, DexProgramClass> finalizeLambdaGroups(AppInfoWithSubtyping appInfo) {
        for (DexType lambda2 : this.invalidatedLambdas) {
            LambdaGroup group = this.lambdas.get(lambda2);
            assert (group != null);
            this.lambdas.remove(lambda2);
            group.remove(lambda2);
        }
        this.invalidatedLambdas.clear();
        this.removeTrivialLambdaGroups();
        LinkedHashMap<LambdaGroup, DexProgramClass> result = new LinkedHashMap<LambdaGroup, DexProgramClass>();
        for (LambdaGroup group : this.groups.values()) {
            assert (!group.isTrivial()) : "No trivial group is expected here.";
            group.compact();
            DexProgramClass lambdaGroupClass = group.synthesizeClass(this.factory);
            result.put(group, lambdaGroupClass);
            appInfo.registerNewType(lambdaGroupClass.type, lambdaGroupClass.superType);
        }
        return result;
    }

    private void removeTrivialLambdaGroups() {
        Iterator<Map.Entry<LambdaGroupId, LambdaGroup>> iterator2 = this.groups.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<LambdaGroupId, LambdaGroup> group = iterator2.next();
            if (!group.getValue().isTrivial()) continue;
            iterator2.remove();
            assert (group.getValue().size() < 2);
            group.getValue().forEachLambda(info -> this.lambdas.remove(info.clazz.type));
        }
    }

    private void rewriteLambdaReferences(IRConverter converter, ExecutorService executorService, OptimizationFeedback feedback) throws ExecutionException {
        if (this.methodsToReprocess.isEmpty()) {
            return;
        }
        Set methods = this.methodsToReprocess.stream().map(method -> this.appView.graphLense().mapDexEncodedMethod((DexEncodedMethod)method, this.appView)).collect(Collectors.toSet());
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexEncodedMethod method2 : methods) {
            futures.add(executorService.submit(() -> {
                converter.processMethod(method2, feedback, methods::contains, CallSiteInformation.empty(), Outliner::noProcessing);
                assert (method2.isProcessed());
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void analyzeClass(DexProgramClass clazz) {
        this.lambdaInvalidator.accept(clazz.superType);
        this.lambdaInvalidator.accept(clazz.interfaces);
        this.lambdaInvalidator.accept(clazz.annotations);
        for (DexEncodedField field : clazz.staticFields()) {
            this.lambdaInvalidator.accept(field.annotations);
            if (field.field.type == clazz.type) continue;
            this.lambdaInvalidator.accept(field.field, clazz.type);
        }
        for (DexEncodedField field : clazz.instanceFields()) {
            this.lambdaInvalidator.accept(field.annotations);
            this.lambdaInvalidator.accept(field.field, clazz.type);
        }
        for (DexEncodedMethod method : clazz.directMethods()) {
            this.lambdaInvalidator.accept(method.annotations);
            this.lambdaInvalidator.accept(method.parameterAnnotationsList);
            this.lambdaInvalidator.accept(method.method, clazz.type);
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            this.lambdaInvalidator.accept(method.annotations);
            this.lambdaInvalidator.accept(method.parameterAnnotationsList);
            this.lambdaInvalidator.accept(method.method, clazz.type);
        }
    }

    private CodeProcessor.Strategy strategyProvider(DexType type) {
        LambdaGroup group = this.getLambdaGroup(type);
        return group != null ? group.getCodeStrategy() : CodeProcessor.NoOp;
    }

    private final class ApplyStrategy
    extends CodeProcessor {
        private ApplyStrategy(DexEncodedMethod method, IRCode code) {
            super(LambdaMerger.this.appView, x$0 -> LambdaMerger.this.strategyProvider(x$0), LambdaMerger.this.lambdaChecker, method, code);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InvokeMethod invokeMethod) {
            strategy.patch((CodeProcessor)this, invokeMethod);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, NewInstance newInstance) {
            strategy.patch((CodeProcessor)this, newInstance);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstancePut instancePut) {
            strategy.patch((CodeProcessor)this, instancePut);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstanceGet instanceGet) {
            strategy.patch((CodeProcessor)this, instanceGet);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticPut staticPut) {
            strategy.patch((CodeProcessor)this, staticPut);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticGet staticGet) {
            strategy.patch((CodeProcessor)this, staticGet);
        }
    }

    private final class AnalysisStrategy
    extends CodeProcessor {
        private AnalysisStrategy(DexEncodedMethod method, IRCode code) {
            super(LambdaMerger.this.appView, x$0 -> LambdaMerger.this.strategyProvider(x$0), LambdaMerger.this.lambdaInvalidator, method, code);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InvokeMethod invokeMethod) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, NewInstance newInstance) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstancePut instancePut) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, InstanceGet instanceGet) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticPut staticPut) {
            LambdaMerger.this.queueForProcessing(this.method);
        }

        @Override
        void process(CodeProcessor.Strategy strategy, StaticGet staticGet) {
            LambdaMerger.this.queueForProcessing(this.method);
        }
    }
}

