/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.LinearFlowInstructionIterator;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.DupDupDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.LoadLoadDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.MoveLoadUpPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreLoadPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreLoadToDupStorePeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreSequenceLoadPeephole;
import java.util.List;
import java.util.ListIterator;

public class BasicBlockMuncher {
    private static List<BasicBlockPeephole> nonDestructivePeepholes() {
        return ImmutableList.of(new MoveLoadUpPeephole(), new StoreLoadPeephole());
    }

    private static List<BasicBlockPeephole> destructivePeepholes() {
        return ImmutableList.of(new StoreSequenceLoadPeephole(), new StoreLoadPeephole(), new LoadLoadDupPeephole(), new DupDupDupPeephole(), new StoreLoadToDupStorePeephole());
    }

    public static void optimize(IRCode code) {
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.nonDestructivePeepholes());
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.destructivePeepholes());
    }

    private static void runPeepholes(IRCode code, List<BasicBlockPeephole> peepholes) {
        ListIterator<BasicBlock> blocksIterator = code.listIterator(code.blocks.size());
        while (blocksIterator.hasPrevious()) {
            BasicBlock currentBlock = blocksIterator.previous();
            LinearFlowInstructionIterator it = new LinearFlowInstructionIterator(currentBlock, currentBlock.getInstructions().size());
            boolean matched = false;
            while (matched || it.hasPrevious()) {
                if (!it.hasPrevious()) {
                    matched = false;
                    it = new LinearFlowInstructionIterator(currentBlock, currentBlock.getInstructions().size());
                }
                for (BasicBlockPeephole peepHole : peepholes) {
                    boolean localMatch = peepHole.match(it);
                    if (localMatch && peepHole.resetAfterMatch()) {
                        it = new LinearFlowInstructionIterator(currentBlock, currentBlock.getInstructions().size());
                        continue;
                    }
                    matched |= localMatch;
                }
                if (!it.hasPrevious()) continue;
                it.previous();
            }
        }
    }
}

