/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Dup2;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;

public class DupDupDupPeephole
implements BasicBlockPeephole {
    private final Point dup1Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final Point dup2Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final Point dup3Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final PeepholeLayout layout = PeepholeLayout.lookBackward(this.dup1Exp, this.dup2Exp, this.dup3Exp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Dup dupTop = this.dup3Exp.get(match).asDup();
        Dup dupMiddle = this.dup2Exp.get(match).asDup();
        Dup dupBottom = this.dup1Exp.get(match).asDup();
        int height = dupTop.src().getHeight();
        StackValue tv0Dup2 = dupTop.outBottom().duplicate(height);
        StackValue mv0Dup2 = dupMiddle.outBottom().duplicate(height + 1);
        StackValue bv0Dup2 = dupBottom.outBottom().duplicate(height + 2);
        StackValue bv1Dup2 = dupBottom.outTop().duplicate(height + 3);
        dupMiddle.src().removeUser(dupMiddle);
        dupBottom.src().removeUser(dupBottom);
        dupTop.outBottom().replaceUsers(tv0Dup2);
        dupMiddle.outBottom().replaceUsers(mv0Dup2);
        dupBottom.outBottom().replaceUsers(bv0Dup2);
        dupBottom.outTop().replaceUsers(bv1Dup2);
        Dup2 dup2 = new Dup2(tv0Dup2, mv0Dup2, bv0Dup2, bv1Dup2, dupTop.outBottom(), dupTop.outTop());
        it.removeOrReplaceByDebugLocalRead();
        it.previous();
        it.replaceCurrentInstruction(dup2);
        PeepholeHelper.resetPrevious(it, 1);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

