/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.EscapeAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StringOptimizer {
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public StringOptimizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
    }

    public void computeTrivialOperationsOnConstString(IRCode code) {
        if (!code.hasConstString) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            ConstNumber constNumber;
            Object rcvString;
            InvokeVirtual invoke;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !(invoke = instr.asInvokeVirtual()).hasOutValue()) continue;
            DexMethod invokedMethod = invoke.getInvokedMethod();
            if (invokedMethod.name == this.factory.substringName) {
                int endIndexValue;
                assert (invoke.inValues().size() == 2 || invoke.inValues().size() == 3);
                Value rcv2 = invoke.getReceiver().getAliasedValue();
                if (rcv2.definition == null || !rcv2.definition.isConstString() || rcv2.hasLocalInfo()) continue;
                Value beginIndex = invoke.inValues().get(1).getAliasedValue();
                if (beginIndex.definition == null || !beginIndex.definition.isConstNumber() || beginIndex.hasLocalInfo()) continue;
                int beginIndexValue = beginIndex.definition.asConstNumber().getIntValue();
                Value endIndex = null;
                if (invoke.inValues().size() == 3) {
                    endIndex = invoke.inValues().get(2).getAliasedValue();
                    if (endIndex.definition == null || !endIndex.definition.isConstNumber() || endIndex.hasLocalInfo()) continue;
                }
                rcvString = rcv2.definition.asConstString().getValue().toString();
                int n = endIndexValue = endIndex == null ? ((String)rcvString).length() : endIndex.definition.asConstNumber().getIntValue();
                if (beginIndexValue < 0 || endIndexValue > ((String)rcvString).length() || beginIndexValue > endIndexValue) continue;
                String sub = ((String)rcvString).substring(beginIndexValue, endIndexValue);
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                it.replaceCurrentInstruction(new ConstString(stringValue, this.factory.createString(sub), this.throwingInfo));
                continue;
            }
            Function<String, Integer> operatorWithNoArg = null;
            BiFunction<String, String, Integer> operatorWithString = null;
            BiFunction<String, Integer, Integer> operatorWithInt = null;
            if (invokedMethod == this.factory.stringMethods.length) {
                operatorWithNoArg = String::length;
            } else if (invokedMethod == this.factory.stringMethods.isEmpty) {
                operatorWithNoArg = rcv -> rcv.isEmpty() ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contains) {
                operatorWithString = (rcv, arg) -> rcv.contains((CharSequence)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.startsWith) {
                operatorWithString = (rcv, arg) -> rcv.startsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.endsWith) {
                operatorWithString = (rcv, arg) -> rcv.endsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equals) {
                operatorWithString = (rcv, arg) -> rcv.equals(arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equalsIgnoreCase) {
                operatorWithString = (rcv, arg) -> rcv.equalsIgnoreCase((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contentEqualsCharSequence) {
                operatorWithString = (rcv, arg) -> rcv.contentEquals((CharSequence)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.indexOfInt) {
                operatorWithInt = String::indexOf;
            } else if (invokedMethod == this.factory.stringMethods.indexOfString) {
                operatorWithString = String::indexOf;
            } else if (invokedMethod == this.factory.stringMethods.lastIndexOfInt) {
                operatorWithInt = String::lastIndexOf;
            } else if (invokedMethod == this.factory.stringMethods.lastIndexOfString) {
                operatorWithString = String::lastIndexOf;
            } else if (invokedMethod == this.factory.stringMethods.compareTo) {
                operatorWithString = String::compareTo;
            } else {
                if (invokedMethod != this.factory.stringMethods.compareToIgnoreCase) continue;
                operatorWithString = String::compareToIgnoreCase;
            }
            Value rcv3 = invoke.getReceiver().getAliasedValue();
            if (rcv3.definition == null || !rcv3.definition.isConstString() || rcv3.hasLocalInfo()) continue;
            rcvString = rcv3.definition.asConstString().getValue();
            if (operatorWithNoArg != null) {
                assert (invoke.inValues().size() == 1);
                int v = operatorWithNoArg.apply(((DexString)rcvString).toString());
                constNumber = code.createIntConstant(v);
            } else if (operatorWithString != null) {
                assert (invoke.inValues().size() == 2);
                Value arg2 = invoke.inValues().get(1).getAliasedValue();
                if (arg2.definition == null || !arg2.definition.isConstString() || arg2.hasLocalInfo()) continue;
                int v = operatorWithString.apply(((DexString)rcvString).toString(), arg2.definition.asConstString().getValue().toString());
                constNumber = code.createIntConstant(v);
            } else {
                assert (operatorWithInt != null);
                assert (invoke.inValues().size() == 2);
                Value arg3 = invoke.inValues().get(1).getAliasedValue();
                if (arg3.definition == null || !arg3.definition.isConstNumber() || arg3.hasLocalInfo()) continue;
                int v = operatorWithInt.apply(((DexString)rcvString).toString(), arg3.definition.asConstNumber().getIntValue());
                constNumber = code.createIntConstant(v);
            }
            it.replaceCurrentInstruction(constNumber);
        }
    }

    public void rewriteClassGetName(AppView<?> appView, IRCode code) {
        if (code.method.isClassInitializer()) {
            return;
        }
        boolean markUseIdentifierNameString = false;
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            DexClass holder;
            Value out;
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !this.factory.classMethods.isReflectiveNameLookup(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) || (out = invoke.outValue()) == null || out.numberOfAllUsers() == 0 || !appView.options().testing.forceNameReflectionOptimization && !StringOptimizer.hasPotentialReadOutside(appView.appInfo(), code.method, EscapeAnalysis.escape(code, out))) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.getReceiver().getAliasedValue();
            if (in.definition == null || !in.definition.isConstClass() || in.hasLocalInfo()) continue;
            ConstClass constClass = in.definition.asConstClass();
            DexType type = constClass.getValue();
            int arrayDepth = type.getNumberOfLeadingSquareBrackets();
            DexType baseType = type.toBaseType(this.factory);
            if (!baseType.isClassType() || (holder = appView.definitionFor(baseType)) == null) continue;
            String descriptor = baseType.toDescriptorString();
            boolean assumeTopLevel = descriptor.indexOf(36) < 0;
            DexItemBasedConstString deferred = null;
            DexString name = null;
            if (invokedMethod == this.factory.classMethods.getName) {
                if (appView.options().isMinifying() && appView.rootSet().mayBeMinified(holder.type, appView)) {
                    deferred = new DexItemBasedConstString(invoke.outValue(), baseType, this.throwingInfo, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, arrayDepth));
                } else {
                    name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, this.factory, arrayDepth);
                }
            } else {
                if (invokedMethod == this.factory.classMethods.getTypeName) continue;
                if (invokedMethod == this.factory.classMethods.getCanonicalName) {
                    if (holder.isLocalClass() || holder.isAnonymousClass()) {
                        ConstNumber constNull = code.createConstNull();
                        it.replaceCurrentInstruction(constNull);
                    } else {
                        if (!assumeTopLevel) continue;
                        if (appView.options().isMinifying() && appView.rootSet().mayBeMinified(holder.type, appView)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, this.throwingInfo, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, this.factory, arrayDepth);
                        }
                    }
                } else if (invokedMethod == this.factory.classMethods.getSimpleName) {
                    if (holder.isAnonymousClass()) {
                        name = this.factory.createString("");
                    } else {
                        if (!assumeTopLevel) continue;
                        if (appView.options().isMinifying() && appView.rootSet().mayBeMinified(holder.type, appView)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, this.throwingInfo, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, this.factory, arrayDepth);
                        }
                    }
                }
            }
            if (name != null) {
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                ConstString constString = new ConstString(stringValue, name, this.throwingInfo);
                it.replaceCurrentInstruction(constString);
                continue;
            }
            if (deferred == null) continue;
            it.replaceCurrentInstruction(deferred);
            markUseIdentifierNameString = true;
        }
        if (markUseIdentifierNameString) {
            code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
        }
    }

    @VisibleForTesting
    public static boolean hasPotentialReadOutside(AppInfo appInfo, DexEncodedMethod invocationContext, Set<Instruction> escapingInstructions) {
        for (Instruction instr : escapingInstructions) {
            if (instr.isReturn() || instr.isThrow() || instr.isStaticPut()) {
                return true;
            }
            if (instr.isInvokeMethod()) {
                DexMethod invokedMethod = instr.asInvokeMethod().getInvokedMethod();
                DexClass holder = appInfo.definitionFor(invokedMethod.holder);
                if (holder == null || holder.isNotProgramClass() || invokedMethod.name == invocationContext.method.name) continue;
                return true;
            }
            if (!instr.isArrayPut()) continue;
            return instr.asArrayPut().array().isArgument();
        }
        return false;
    }

    public void removeTrivialConversions(IRCode code) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Value out;
            TypeLatticeElement inType;
            Value in;
            DexMethod invokedMethod;
            InvokeMethod invoke;
            Instruction instr = (Instruction)it.next();
            if (instr.isInvokeStatic()) {
                invoke = instr.asInvokeStatic();
                invokedMethod = invoke.getInvokedMethod();
                if (invokedMethod != this.factory.stringMethods.valueOf) continue;
                assert (invoke.inValues().size() == 1);
                in = invoke.inValues().get(0);
                if (in.hasLocalInfo()) continue;
                inType = in.getTypeLattice();
                if (in.isAlwaysNull(this.appView)) {
                    Value nullStringValue = code.createValue(TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                    ConstString nullString = new ConstString(nullStringValue, this.factory.createString("null"), this.throwingInfo);
                    it.replaceCurrentInstruction(nullString);
                    continue;
                }
                if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
                out = invoke.outValue();
                if (out != null) {
                    CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                    continue;
                }
                it.removeOrReplaceByDebugLocalRead();
                continue;
            }
            if (!instr.isInvokeVirtual() || (invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) != this.factory.stringMethods.toString) continue;
            assert (invoke.inValues().size() == 1);
            in = ((InvokeMethodWithReceiver)invoke).getReceiver();
            inType = in.getTypeLattice();
            if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
            out = invoke.outValue();
            if (out != null) {
                CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                continue;
            }
            it.removeOrReplaceByDebugLocalRead();
        }
    }
}

