/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.FixedRegisterValue;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterMove;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RegisterMoveScheduler {
    private final Set<RegisterMove> moveSet = new TreeSet<RegisterMove>();
    private final Map<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
    private int usedTempRegisters = 0;
    private final InstructionListIterator insertAt;
    private final Position position;
    private final int tempRegister;

    public RegisterMoveScheduler(InstructionListIterator insertAt, int tempRegister, Position position) {
        this.insertAt = insertAt;
        this.tempRegister = tempRegister;
        this.position = position;
    }

    public RegisterMoveScheduler(InstructionListIterator insertAt, int tempRegister) {
        this(insertAt, tempRegister, Position.none());
    }

    public void addMove(RegisterMove move) {
        this.moveSet.add(move);
        if (move.src != Integer.MIN_VALUE) {
            this.valueMap.put(move.src, move.src);
        }
        this.valueMap.put(move.dst, move.dst);
    }

    public void schedule() {
        RegisterMove move;
        assert (this.everyDestinationOnlyWrittenOnce());
        LinkedList<RegisterMove> worklist = new LinkedList<RegisterMove>();
        Iterator<RegisterMove> iterator2 = this.moveSet.iterator();
        while (iterator2.hasNext()) {
            move = iterator2.next();
            if (move.isBlocked(this.moveSet, this.valueMap)) continue;
            worklist.addLast(move);
            iterator2.remove();
        }
        while (!worklist.isEmpty() || !this.moveSet.isEmpty()) {
            while (!worklist.isEmpty()) {
                move = (RegisterMove)worklist.removeFirst();
                assert (!move.isBlocked(this.moveSet, this.valueMap));
                Integer generatedDest = this.createMove(move);
                if (move.src != Integer.MIN_VALUE) {
                    this.valueMap.put(move.src, generatedDest);
                }
                iterator2 = this.moveSet.iterator();
                while (iterator2.hasNext()) {
                    RegisterMove other = iterator2.next();
                    if (other.isBlocked(this.moveSet, this.valueMap)) continue;
                    worklist.addLast(other);
                    iterator2.remove();
                }
            }
            if (this.moveSet.isEmpty()) continue;
            move = this.pickMoveToUnblock();
            this.createMoveDestToTemp(move);
            worklist.addLast(move);
        }
    }

    public int getUsedTempRegisters() {
        return this.usedTempRegisters;
    }

    private List<RegisterMove> findMovesWithSrc(int src, TypeLatticeElement type) {
        ArrayList<RegisterMove> result = new ArrayList<RegisterMove>();
        assert (src != Integer.MIN_VALUE);
        for (RegisterMove move : this.moveSet) {
            if (move.src == Integer.MIN_VALUE) continue;
            int moveSrc = this.valueMap.get(move.src);
            if (moveSrc == src) {
                result.add(move);
                continue;
            }
            if (move.type.isWide() && moveSrc + 1 == src) {
                result.add(move);
                continue;
            }
            if (!type.isWide() || moveSrc - 1 != src) continue;
            result.add(move);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer createMove(RegisterMove move) {
        void var2_13;
        if (move.definition != null) {
            if (move.definition.isArgument()) {
                Argument argument = move.definition.asArgument();
                int argumentRegister = argument.outValue().getLiveIntervals().getRegister();
                FixedRegisterValue to = new FixedRegisterValue(argument.outValue().getTypeLattice(), move.dst);
                FixedRegisterValue from = new FixedRegisterValue(argument.outValue().getTypeLattice(), argumentRegister);
                Move move2 = new Move((Value)to, from);
            } else {
                assert (move.definition.isOutConstant());
                ConstInstruction definition = move.definition.getOutConstantConstInstruction();
                if (!definition.isConstNumber()) throw new Unreachable("Unexpected definition");
                FixedRegisterValue to = new FixedRegisterValue(move.definition.outValue().getTypeLattice(), move.dst);
                ConstNumber constNumber = new ConstNumber((Value)to, definition.asConstNumber().getRawValue());
            }
        } else {
            FixedRegisterValue to = new FixedRegisterValue(move.type, move.dst);
            FixedRegisterValue from = new FixedRegisterValue(move.type, this.valueMap.get(move.src));
            Move move3 = new Move((Value)to, from);
        }
        var2_13.setPosition(this.position);
        this.insertAt.add(var2_13);
        return move.dst;
    }

    private void createMoveDestToTemp(RegisterMove move) {
        List<RegisterMove> movesWithSrc = this.findMovesWithSrc(move.dst, move.type);
        assert (movesWithSrc.size() > 0);
        for (RegisterMove moveWithSrc : movesWithSrc) {
            FixedRegisterValue to = new FixedRegisterValue(moveWithSrc.type, this.tempRegister + this.usedTempRegisters);
            FixedRegisterValue from = new FixedRegisterValue(moveWithSrc.type, this.valueMap.get(moveWithSrc.src));
            Move instruction = new Move((Value)to, from);
            instruction.setPosition(this.position);
            this.insertAt.add(instruction);
            this.valueMap.put(moveWithSrc.src, this.tempRegister + this.usedTempRegisters);
            this.usedTempRegisters += moveWithSrc.type.requiredRegisters();
        }
    }

    private RegisterMove pickMoveToUnblock() {
        Iterator<RegisterMove> iterator2 = this.moveSet.iterator();
        RegisterMove move = null;
        while (iterator2.hasNext()) {
            move = iterator2.next();
            if (move.type.isWide()) continue;
        }
        iterator2.remove();
        return move;
    }

    private boolean everyDestinationOnlyWrittenOnce() {
        IntArraySet destinations = new IntArraySet(this.moveSet.size());
        for (RegisterMove move : this.moveSet) {
            boolean changed = destinations.add(move.dst);
            assert (changed);
        }
        return true;
    }
}

