/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import com.android.tools.r8.kotlin.KotlinClassMetadataReader;
import com.android.tools.r8.kotlin.KotlinInfo;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Kotlin {
    public static final String NAME = String.join((CharSequence)"", ImmutableList.of("k", "o", "t", "l", "i", "n"));
    private static final String KOTLIN = String.join((CharSequence)"", ImmutableList.of("L", "k", "o", "t", "l", "i", "n", "/"));
    public final DexItemFactory factory;
    public final Functional functional;
    public final Intrinsics intrinsics;
    public final Metadata metadata;

    static String addKotlinPrefix(String str) {
        return KOTLIN + str;
    }

    public Kotlin(DexItemFactory factory) {
        this.factory = factory;
        this.functional = new Functional();
        this.intrinsics = new Intrinsics();
        this.metadata = new Metadata();
    }

    public KotlinInfo getKotlinInfo(DexClass clazz, DiagnosticsHandler reporter) {
        return KotlinClassMetadataReader.getKotlinInfo(this, clazz, reporter);
    }

    public final class Intrinsics {
        public final DexType type;
        public final DexMethod throwParameterIsNullException;
        public final DexMethod checkParameterIsNotNull;
        public final DexMethod throwNpe;

        public Intrinsics() {
            this.type = Kotlin.this.factory.createType(Kotlin.addKotlinPrefix("jvm/internal/Intrinsics;"));
            this.throwParameterIsNullException = Kotlin.this.factory.createMethod(this.type, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, Kotlin.this.factory.stringType), "throwParameterIsNullException");
            this.checkParameterIsNotNull = Kotlin.this.factory.createMethod(this.type, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, Kotlin.this.factory.objectType, Kotlin.this.factory.stringType), "checkParameterIsNotNull");
            this.throwNpe = Kotlin.this.factory.createMethod(this.type, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, new DexType[0]), "throwNpe");
        }
    }

    public final class Metadata {
        public final DexType kotlinMetadataType;
        public final DexString kind;
        public final DexString metadataVersion;
        public final DexString bytecodeVersion;
        public final DexString data1;
        public final DexString data2;
        public final DexString extraString;
        public final DexString packageName;
        public final DexString extraInt;

        public Metadata() {
            this.kotlinMetadataType = Kotlin.this.factory.createType(Kotlin.addKotlinPrefix("Metadata;"));
            this.kind = Kotlin.this.factory.createString("k");
            this.metadataVersion = Kotlin.this.factory.createString("mv");
            this.bytecodeVersion = Kotlin.this.factory.createString("bv");
            this.data1 = Kotlin.this.factory.createString("d1");
            this.data2 = Kotlin.this.factory.createString("d2");
            this.extraString = Kotlin.this.factory.createString("xs");
            this.packageName = Kotlin.this.factory.createString("pn");
            this.extraInt = Kotlin.this.factory.createString("xi");
        }
    }

    public final class Functional {
        private final Object2IntMap<DexType> functions = new Object2IntArrayMap<DexType>(IntStream.rangeClosed(0, 22).boxed().collect(Collectors.toMap(i -> Kotlin.this.factory.createType(Kotlin.addKotlinPrefix("jvm/functions/Function") + i + ";"), Function.identity())));
        public final DexString kotlinStyleLambdaInstanceName;
        public final DexType functionBase;
        public final DexType lambdaType;
        public final DexMethod lambdaInitializerMethod;

        private Functional() {
            this.kotlinStyleLambdaInstanceName = Kotlin.this.factory.createString("INSTANCE");
            this.functionBase = Kotlin.this.factory.createType(Kotlin.addKotlinPrefix("jvm/internal/FunctionBase;"));
            this.lambdaType = Kotlin.this.factory.createType(Kotlin.addKotlinPrefix("jvm/internal/Lambda;"));
            this.lambdaInitializerMethod = Kotlin.this.factory.createMethod(this.lambdaType, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, Kotlin.this.factory.intType), Kotlin.this.factory.constructorMethodName);
        }

        public boolean isFunctionInterface(DexType type) {
            return this.functions.containsKey(type);
        }

        public int getArity(DexType type) {
            assert (this.isFunctionInterface(type)) : "Request to retrieve the arity from non-Kotlin-Function: " + type.toSourceString();
            return this.functions.getInt(type);
        }
    }
}

