/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardPackageNameList;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ClassNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final ClassNamingStrategy classNamingStrategy;
    private final PackageNamingStrategy packageNamingStrategy;
    private final Iterable<? extends DexClass> classes;
    private final InternalOptions.PackageObfuscationMode packageObfuscationMode;
    private final boolean isAccessModificationAllowed;
    private final Set<String> noObfuscationPrefixes = Sets.newHashSet();
    private final Set<String> usedPackagePrefixes = Sets.newHashSet();
    private final Set<DexString> usedTypeNames = Sets.newIdentityHashSet();
    private final Map<DexType, DexString> renaming = Maps.newIdentityHashMap();
    private final Map<String, Namespace> states = new HashMap<String, Namespace>();
    private final boolean keepInnerClassStructure;
    private final Namespace topLevelState;

    ClassNameMinifier(AppView<AppInfoWithLiveness> appView, ClassNamingStrategy classNamingStrategy, PackageNamingStrategy packageNamingStrategy, Iterable<? extends DexClass> classes) {
        this.appView = appView;
        this.classNamingStrategy = classNamingStrategy;
        this.packageNamingStrategy = packageNamingStrategy;
        this.classes = classes;
        InternalOptions options = appView.options();
        this.packageObfuscationMode = options.getProguardConfiguration().getPackageObfuscationMode();
        this.isAccessModificationAllowed = options.getProguardConfiguration().isAccessModificationAllowed();
        this.keepInnerClassStructure = options.getProguardConfiguration().getKeepAttributes().signature || options.getProguardConfiguration().getKeepAttributes().innerClasses;
        this.topLevelState = new Namespace(DescriptorUtils.getPackageBinaryNameFromJavaType(options.getProguardConfiguration().getPackagePrefix()));
        this.states.put("", this.topLevelState);
    }

    ClassRenaming computeRenaming(Timing timing) {
        return this.computeRenaming(timing, Collections.emptyMap());
    }

    ClassRenaming computeRenaming(Timing timing, Map<DexType, DexString> syntheticClasses) {
        this.renaming.putAll(syntheticClasses);
        timing.begin("reserve");
        for (DexClass dexClass : this.classes) {
            if (!this.classNamingStrategy.noObfuscation(dexClass.type)) continue;
            assert (!this.renaming.containsKey(dexClass.type));
            this.registerClassAsUsed(dexClass.type);
        }
        timing.end();
        timing.begin("rename-classes");
        for (DexClass dexClass : this.classes) {
            if (this.renaming.containsKey(dexClass.type)) continue;
            dexClass.annotations = dexClass.annotations.keepIf(this::isNotKotlinMetadata);
            DexString renamed = this.computeName(dexClass.type);
            this.renaming.put(dexClass.type, renamed);
            assert (!this.keepInnerClassStructure || !dexClass.isMemberClass() || !dexClass.type.getInternalName().contains(String.valueOf('$')) || renamed.toString().contains(String.valueOf('$')));
        }
        timing.end();
        timing.begin("rename-dangling-types");
        for (DexClass dexClass : this.classes) {
            this.renameDanglingTypes(dexClass);
        }
        timing.end();
        timing.begin("rename-generic");
        new GenericSignatureRewriter(this.appView, this.renaming).run(this.classes);
        timing.end();
        timing.begin("rename-arrays");
        this.appView.dexItemFactory().forAllTypes(this::renameArrayTypeIfNeeded);
        timing.end();
        return new ClassRenaming(Collections.unmodifiableMap(this.renaming), this.getPackageRenaming());
    }

    private Map<String, String> getPackageRenaming() {
        ImmutableMap.Builder<String, String> packageRenaming = ImmutableMap.builder();
        for (Map.Entry<String, Namespace> entry : this.states.entrySet()) {
            String originalPackageName = entry.getKey();
            String minifiedPackageName = entry.getValue().getPackageName();
            if (minifiedPackageName.equals(originalPackageName)) continue;
            packageRenaming.put(originalPackageName, minifiedPackageName);
        }
        return packageRenaming.build();
    }

    private void renameDanglingTypes(DexClass clazz) {
        clazz.forEachMethod(this::renameDanglingTypesInMethod);
        clazz.forEachField(this::renameDanglingTypesInField);
    }

    private void renameDanglingTypesInField(DexEncodedField field) {
        this.renameDanglingType(field.field.type);
    }

    private void renameDanglingTypesInMethod(DexEncodedMethod method) {
        DexProto proto = method.method.proto;
        this.renameDanglingType(proto.returnType);
        for (DexType type : proto.parameters.values) {
            this.renameDanglingType(type);
        }
    }

    private void renameDanglingType(DexType type) {
        if (this.appView.appInfo().wasPruned(type) && !this.renaming.containsKey(type) && !this.classNamingStrategy.noObfuscation(type)) {
            assert (this.appView.definitionFor(type) == null);
            this.renaming.put(type, this.topLevelState.nextTypeName(type));
        }
    }

    private void registerClassAsUsed(DexType type) {
        DexType outerClass;
        this.renaming.put(type, type.descriptor);
        this.registerPackagePrefixesAsUsed(ClassNameMinifier.getParentPackagePrefix(DescriptorUtils.getClassBinaryNameFromDescriptor(type.descriptor.toSourceString())));
        this.usedTypeNames.add(type.descriptor);
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null && !this.renaming.containsKey(outerClass) && !this.classNamingStrategy.noObfuscation(outerClass)) {
            this.registerClassAsUsed(outerClass);
        }
    }

    private void registerPackagePrefixesAsUsed(String packagePrefix) {
        if (!this.isAccessModificationAllowed) {
            this.noObfuscationPrefixes.add(packagePrefix);
        }
        String usedPrefix = packagePrefix;
        while (usedPrefix.length() > 0) {
            this.usedPackagePrefixes.add(usedPrefix);
            usedPrefix = ClassNameMinifier.getParentPackagePrefix(usedPrefix);
        }
    }

    private DexType getOutClassForType(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        InnerClassAttribute attribute = clazz.getInnerClassAttributeForThisClass();
        if (attribute == null) {
            return null;
        }
        return attribute.getLiveContext(this.appView.appInfo());
    }

    private DexString computeName(DexType type) {
        DexType outerClass;
        Namespace state = null;
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null) {
            DexClass clazz = this.appView.definitionFor(type);
            assert (clazz != null);
            InnerClassAttribute attribute = clazz.getInnerClassAttributeForThisClass();
            assert (attribute != null);
            String separator = DescriptorUtils.computeInnerClassSeparator(attribute.getOuter(), type, attribute.getInnerName());
            if (separator == null) {
                separator = String.valueOf('$');
            }
            state = this.getStateForOuterClass(outerClass, separator);
        }
        if (state == null) {
            state = this.getStateForClass(type);
        }
        return state.nextTypeName(type);
    }

    private Namespace getStateForClass(DexType type) {
        String packageName = DescriptorUtils.getPackageBinaryNameFromJavaType(type.getPackageDescriptor());
        ProguardPackageNameList keepPackageNames = this.appView.options().getProguardConfiguration().getKeepPackageNamesPatterns();
        if (this.noObfuscationPrefixes.contains(packageName) || keepPackageNames.matches(type)) {
            return this.states.computeIfAbsent(packageName, x$0 -> new Namespace((String)x$0));
        }
        Namespace state = this.topLevelState;
        switch (this.packageObfuscationMode) {
            case NONE: {
                state = this.getStateForPackagePrefix(packageName);
                break;
            }
            case REPACKAGE: {
                state = this.topLevelState;
                break;
            }
            case FLATTEN: {
                state = this.states.computeIfAbsent(packageName, k -> {
                    String renamedPackagePrefix = this.topLevelState.nextPackagePrefix();
                    return new Namespace(renamedPackagePrefix);
                });
            }
        }
        return state;
    }

    private Namespace getStateForPackagePrefix(String prefix) {
        Namespace state = this.states.get(prefix);
        if (state == null) {
            String parentPackage = ClassNameMinifier.getParentPackagePrefix(prefix);
            Namespace superState = this.noObfuscationPrefixes.contains(parentPackage) ? this.states.computeIfAbsent(parentPackage, x$0 -> new Namespace((String)x$0)) : this.getStateForPackagePrefix(parentPackage);
            String renamedPackagePrefix = superState.nextPackagePrefix();
            state = new Namespace(renamedPackagePrefix);
            this.states.put(prefix, state);
        }
        return state;
    }

    private Namespace getStateForOuterClass(DexType outer, String innerClassSeparator) {
        String prefix = DescriptorUtils.getClassBinaryNameFromDescriptor(outer.toDescriptorString());
        Namespace state = this.states.get(prefix);
        if (state == null) {
            DexString renamed = this.renaming.get(outer);
            if (renamed == null) {
                renamed = this.computeName(outer);
                this.renaming.put(outer, renamed);
            }
            String binaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamed.toString());
            state = new Namespace(binaryName, innerClassSeparator);
            this.states.put(prefix, state);
        }
        return state;
    }

    private void renameArrayTypeIfNeeded(DexType type) {
        DexType base;
        DexString value;
        if (type.isArrayType() && (value = this.renaming.get(base = type.toBaseType(this.appView.dexItemFactory()))) != null) {
            int dimensions = type.descriptor.numberOfLeadingSquareBrackets();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                builder.append('[');
            }
            builder.append(value.toString());
            DexString descriptor = this.appView.dexItemFactory().createString(builder.toString());
            this.renaming.put(type, descriptor);
        }
    }

    static String getParentPackagePrefix(String packagePrefix) {
        int i = packagePrefix.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return packagePrefix.substring(0, i);
    }

    private boolean isNotKotlinMetadata(DexAnnotation annotation) {
        return annotation.annotation.type != this.appView.dexItemFactory().kotlin.metadata.kotlinMetadataType;
    }

    protected static interface PackageNamingStrategy {
        public String next(char[] var1, InternalNamingState var2);
    }

    protected static interface ClassNamingStrategy {
        public DexString next(DexType var1, char[] var2, InternalNamingState var3);

        public boolean noObfuscation(DexType var1);
    }

    protected class Namespace
    implements InternalNamingState {
        private final String packageName;
        private final char[] packagePrefix;
        private int dictionaryIndex = 0;
        private int nameIndex = 1;

        Namespace(String packageName) {
            this(packageName, String.valueOf('/'));
        }

        Namespace(String packageName, String separator) {
            this.packageName = packageName;
            this.packagePrefix = ("L" + packageName + (packageName.isEmpty() ? "" : separator)).toCharArray();
            StringBuilder rBuilder = new StringBuilder().append(this.packagePrefix).append("R;");
            ClassNameMinifier.this.usedTypeNames.add(ClassNameMinifier.this.appView.dexItemFactory().createString(rBuilder.toString()));
        }

        public String getPackageName() {
            return this.packageName;
        }

        DexString nextTypeName(DexType type) {
            DexString candidate;
            do {
                candidate = ClassNameMinifier.this.classNamingStrategy.next(type, this.packagePrefix, this);
            } while (ClassNameMinifier.this.usedTypeNames.contains(candidate));
            ClassNameMinifier.this.usedTypeNames.add(candidate);
            return candidate;
        }

        String nextPackagePrefix() {
            String candidate;
            do {
                candidate = ClassNameMinifier.this.packageNamingStrategy.next(this.packagePrefix, this);
            } while (ClassNameMinifier.this.usedPackagePrefixes.contains(candidate));
            ClassNameMinifier.this.usedPackagePrefixes.add(candidate);
            return candidate;
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        @Override
        public int incrementNameIndex(boolean isDirectMethodCall) {
            assert (!isDirectMethodCall);
            return this.nameIndex++;
        }
    }

    static class ClassRenaming {
        protected final Map<String, String> packageRenaming;
        protected final Map<DexType, DexString> classRenaming;

        private ClassRenaming(Map<DexType, DexString> classRenaming, Map<String, String> packageRenaming) {
            this.classRenaming = classRenaming;
            this.packageRenaming = packageRenaming;
        }
    }
}

