/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.BottomUpClassHierarchyTraversal;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.naming.FieldNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.ReservedFieldNamingState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class FieldNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexField, DexString> renaming = new IdentityHashMap<DexField, DexString>();
    private Map<DexType, ReservedFieldNamingState> reservedNamingStates = new IdentityHashMap<DexType, ReservedFieldNamingState>();
    private final MemberNamingStrategy strategy;

    FieldNameMinifier(AppView<AppInfoWithLiveness> appView, MemberNamingStrategy strategy) {
        this.appView = appView;
        this.strategy = strategy;
    }

    FieldRenaming computeRenaming(Collection<DexClass> interfaces, Timing timing) {
        timing.begin("reserve-names");
        this.reserveFieldNames();
        timing.end();
        timing.begin("rename-definitions");
        this.renameFieldsInInterfaces(interfaces);
        this.propagateReservedFieldNamesUpwards();
        this.renameFieldsInClasses();
        timing.end();
        timing.begin("rename-references");
        this.renameNonReboundReferences();
        timing.end();
        return new FieldRenaming(this.renaming);
    }

    private ReservedFieldNamingState getReservedFieldNamingState(DexType type) {
        return this.reservedNamingStates.get(type);
    }

    private ReservedFieldNamingState getOrCreateReservedFieldNamingState(DexType type) {
        return this.reservedNamingStates.computeIfAbsent(type, ignore -> new ReservedFieldNamingState(this.appView));
    }

    private void reserveFieldNames() {
        for (DexClass clazz : this.appView.appInfo().app().asDirect().allClasses()) {
            ReservedFieldNamingState reservedNames = null;
            for (DexEncodedField field : clazz.fields()) {
                DexString reservedName = this.strategy.getReservedNameOrDefault(field, clazz, null);
                if (reservedName == null) continue;
                if (reservedNames == null) {
                    reservedNames = this.getOrCreateReservedFieldNamingState(clazz.type);
                }
                reservedNames.markReservedDirectly(reservedName, field.field.type);
                if (reservedName == field.field.name) continue;
                this.renaming.put(field.field, reservedName);
            }
            if (!clazz.isInterface() || reservedNames == null) continue;
            for (DexType implementationType : this.appView.appInfo().allImplementsSubtypes(clazz.type)) {
                DexClass implementation = this.appView.definitionFor(implementationType);
                if (implementation == null) continue;
                assert (!implementation.isInterface());
                this.getOrCreateReservedFieldNamingState(implementationType).includeReservations(reservedNames);
            }
        }
        this.propagateReservedFieldNamesUpwards();
    }

    private void propagateReservedFieldNamesUpwards() {
        BottomUpClassHierarchyTraversal.forProgramClasses(this.appView).visit((Iterable)this.appView.appInfo().classes(), clazz -> {
            ReservedFieldNamingState reservedNames = this.getReservedFieldNamingState(clazz.type);
            if (reservedNames != null) {
                for (DexType supertype : clazz.allImmediateSupertypes()) {
                    if (!supertype.isProgramType(this.appView)) continue;
                    this.getOrCreateReservedFieldNamingState(supertype).includeReservationsFromBelow(reservedNames);
                }
            }
        });
    }

    private void renameFieldsInClasses() {
        IdentityHashMap states = new IdentityHashMap();
        ((TopDownClassHierarchyTraversal)TopDownClassHierarchyTraversal.forAllClasses(this.appView).excludeInterfaces()).visit((Iterable)this.appView.appInfo().classes(), clazz -> {
            assert (!clazz.isInterface());
            FieldNamingState parentState = clazz.superType == null ? new FieldNamingState(this.appView, this.strategy) : states.computeIfAbsent(clazz.superType, key -> new FieldNamingState(this.appView, this.strategy)).clone();
            ReservedFieldNamingState reservedNames = this.getOrCreateReservedFieldNamingState(clazz.type);
            FieldNamingState state = parentState.createChildState(reservedNames);
            if (clazz.isProgramClass()) {
                for (DexEncodedField field : clazz.fields()) {
                    this.renameField(field, state);
                }
            }
            assert (!states.containsKey(clazz.type));
            states.put(clazz.type, state);
        });
    }

    private void renameFieldsInInterfaces(Collection<DexClass> interfaces) {
        InterfacePartitioning partioning = new InterfacePartitioning(this.appView);
        for (Set partition : partioning.sortedPartitions(interfaces)) {
            this.renameFieldsInInterfacePartition(partition);
        }
    }

    private void renameFieldsInInterfacePartition(Set<DexClass> partition) {
        ReservedFieldNamingState reservedNamesInPartition = new ReservedFieldNamingState(this.appView);
        for (DexClass clazz : partition) {
            ReservedFieldNamingState reservedNamesInInterface = this.getReservedFieldNamingState(clazz.type);
            if (reservedNamesInInterface == null) continue;
            reservedNamesInPartition.includeReservations(reservedNamesInInterface);
            reservedNamesInPartition.includeReservationsFromBelow(reservedNamesInInterface);
        }
        ReservedFieldNamingState namesToBeReservedInImplementsSubclasses = new ReservedFieldNamingState(this.appView);
        FieldNamingState state = new FieldNamingState(this.appView, this.strategy, reservedNamesInPartition);
        for (DexClass clazz : partition) {
            if (!clazz.isProgramClass()) continue;
            assert (clazz.isInterface());
            for (DexEncodedField field : clazz.fields()) {
                DexString newName = this.renameField(field, state);
                namesToBeReservedInImplementsSubclasses.markReservedDirectly(newName, field.field.type);
            }
        }
        Set<DexType> visited = Sets.newIdentityHashSet();
        for (DexClass clazz : partition) {
            for (DexType implementationType : this.appView.appInfo().allImplementsSubtypes(clazz.type)) {
                DexClass implementation;
                if (!visited.add(implementationType) || (implementation = this.appView.definitionFor(implementationType)) == null) continue;
                this.getOrCreateReservedFieldNamingState(implementationType).includeReservations(namesToBeReservedInImplementsSubclasses);
            }
        }
    }

    private DexString renameField(DexEncodedField encodedField, FieldNamingState state) {
        DexField field = encodedField.field;
        DexString newName = state.getOrCreateNameFor(field);
        if (newName != field.name) {
            this.renaming.put(field, newName);
        }
        return newName;
    }

    private void renameNonReboundReferences() {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        Sets.union(Sets.union(appInfo.staticFieldReads.keySet(), appInfo.staticFieldWrites.keySet()), Sets.union(appInfo.instanceFieldReads.keySet(), appInfo.instanceFieldWrites.keySet())).forEach(this::renameNonReboundReference);
    }

    private void renameNonReboundReference(DexField field) {
        if (this.renaming.containsKey(field)) {
            return;
        }
        DexEncodedField definition = this.appView.definitionFor(field);
        if (definition != null) {
            assert (definition.field == field);
            return;
        }
        DexClass holder = this.appView.definitionFor(field.holder);
        if (holder == null || holder.isNotProgramClass()) {
            return;
        }
        definition = this.appView.appInfo().resolveField(field);
        if (definition == null) {
            return;
        }
        assert (definition.field != field);
        assert (definition.field.holder != field.holder);
        if (this.renaming.containsKey(definition.field)) {
            this.renaming.put(field, this.renaming.get(definition.field));
        }
    }

    static class InterfacePartitioning {
        private final AppView<AppInfoWithLiveness> appView;
        private final Set<DexType> visited = Sets.newIdentityHashSet();

        InterfacePartitioning(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
        }

        private List<Set<DexClass>> sortedPartitions(Collection<DexClass> interfaces) {
            ArrayList<Set<DexClass>> partitions = new ArrayList<Set<DexClass>>();
            for (DexClass clazz : interfaces) {
                if (clazz == null || !this.visited.add(clazz.type)) continue;
                Set<DexClass> partition = this.buildSortedPartition(clazz);
                assert (!partition.isEmpty());
                assert (partition.stream().allMatch(DexClass::isInterface));
                assert (partition.stream().map(DexClass::getType).allMatch(this.visited::contains));
                partitions.add(partition);
            }
            return partitions;
        }

        private Set<DexClass> buildSortedPartition(DexClass src) {
            TreeSet<DexClass> partition = new TreeSet<DexClass>((x, y) -> x.type.slowCompareTo(y.type));
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            worklist.add(src.type);
            while (!worklist.isEmpty()) {
                DexType type = (DexType)worklist.removeFirst();
                DexClass clazz = this.appView.definitionFor(type);
                if (clazz == null) continue;
                for (DexType superinterface : clazz.interfaces.values) {
                    if (!this.visited.add(superinterface)) continue;
                    worklist.add(superinterface);
                }
                if (clazz.isInterface()) {
                    partition.add(clazz);
                    for (DexType subtype : this.appView.appInfo().allImmediateSubtypes(type)) {
                        if (!this.visited.add(subtype)) continue;
                        worklist.add(subtype);
                    }
                    continue;
                }
                if (clazz.type == this.appView.dexItemFactory().objectType) continue;
                if (this.visited.add(clazz.superType)) {
                    worklist.add(clazz.superType);
                }
                for (DexType subclass : this.appView.appInfo().allExtendsSubtypes(type)) {
                    if (!this.visited.add(subclass)) continue;
                    worklist.add(subclass);
                }
            }
            return partition;
        }
    }

    static class FieldRenaming {
        final Map<DexField, DexString> renaming;

        private FieldRenaming(Map<DexField, DexString> renaming) {
            this.renaming = renaming;
        }

        public static FieldRenaming empty() {
            return new FieldRenaming(ImmutableMap.of());
        }
    }
}

