/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.FieldNamingStateBase;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.ReservedFieldNamingState;
import java.util.IdentityHashMap;
import java.util.Map;

public class FieldNamingState
extends FieldNamingStateBase<InternalState>
implements Cloneable {
    private final ReservedFieldNamingState reservedNames;
    private final MemberNamingStrategy strategy;

    public FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy) {
        this(appView, strategy, new ReservedFieldNamingState(appView));
    }

    public FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames) {
        this(appView, strategy, reservedNames, new IdentityHashMap<DexType, InternalState>());
    }

    private FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames, Map<DexType, InternalState> internalStates) {
        super(appView, internalStates);
        this.reservedNames = reservedNames;
        this.strategy = strategy;
    }

    public FieldNamingState createChildState(ReservedFieldNamingState reservedNames) {
        FieldNamingState childState = new FieldNamingState(this.appView, this.strategy, reservedNames, this.internalStates);
        childState.includeReservations(this.reservedNames);
        return childState;
    }

    public DexString getOrCreateNameFor(DexField field) {
        DexEncodedField encodedField = ((AppInfo)this.appView.appInfo()).resolveField(field);
        if (encodedField != null) {
            DexClass clazz = this.appView.definitionFor(encodedField.field.holder);
            if (clazz == null) {
                return field.name;
            }
            DexString reservedName = this.strategy.getReservedNameOrDefault(encodedField, clazz, null);
            if (reservedName != null) {
                return reservedName;
            }
        }
        return ((InternalState)this.getOrCreateInternalState(field)).createNewName(field);
    }

    public void includeReservations(ReservedFieldNamingState reservedNames) {
        this.reservedNames.includeReservations(reservedNames);
    }

    @Override
    public InternalState createInternalState() {
        return new InternalState();
    }

    public FieldNamingState clone() {
        IdentityHashMap<DexType, InternalState> internalStatesClone = new IdentityHashMap<DexType, InternalState>();
        for (Map.Entry entry : this.internalStates.entrySet()) {
            internalStatesClone.put((DexType)entry.getKey(), ((InternalState)entry.getValue()).clone());
        }
        return new FieldNamingState(this.appView, this.strategy, this.reservedNames, internalStatesClone);
    }

    class InternalState
    implements InternalNamingState,
    Cloneable {
        private int dictionaryIndex;
        private int nextNameIndex;

        public InternalState() {
            this(1, 0);
        }

        public InternalState(int nextNameIndex, int dictionaryIndex) {
            this.dictionaryIndex = dictionaryIndex;
            this.nextNameIndex = nextNameIndex;
        }

        public DexString createNewName(DexField field) {
            DexString name;
            do {
                name = FieldNamingState.this.strategy.next(field, (InternalNamingState)this);
            } while (FieldNamingState.this.reservedNames.isReserved(name, field.type));
            return name;
        }

        public InternalState clone() {
            return new InternalState(this.nextNameIndex, this.dictionaryIndex);
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        @Override
        public int incrementNameIndex(boolean isDirectMethodCall) {
            assert (!isDirectMethodCall);
            return this.nextNameIndex++;
        }
    }
}

