/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public class IdentifierNameStringMarker {
    private final AppView<AppInfoWithLiveness> appView;
    private final Object2BooleanMap<DexReference> identifierNameStrings;

    public IdentifierNameStringMarker(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.identifierNameStrings = appView.appInfo().identifierNameStrings;
    }

    public void decoupleIdentifierNameStringsInFields() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            for (DexEncodedField field : clazz.staticFields()) {
                this.decoupleIdentifierNameStringInStaticField(field);
            }
        }
    }

    private void decoupleIdentifierNameStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        if (!this.identifierNameStrings.containsKey(encodedField.field)) {
            return;
        }
        DexValue staticValue = encodedField.getStaticValue();
        if (!(staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = (DexString)((DexValue.DexValueString)staticValue).getValue();
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
        if (itemBasedString != null) {
            encodedField.setStaticValue(new DexValue.DexItemBasedValueString(itemBasedString));
        }
    }

    public void decoupleIdentifierNameStringsInMethod(DexEncodedMethod encodedMethod, IRCode code) {
        if (!code.hasConstString) {
            return;
        }
        BasicBlock.ThrowingInfo throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(this.appView.options());
        DexType originHolder = code.method.method.holder;
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                InvokeMethod invoke;
                DexMethod invokedMethod;
                DexReference itemBasedString;
                Instruction instruction = (Instruction)iterator2.next();
                if (instruction.isStaticPut() || instruction.isInstancePut()) {
                    BasicBlock blockWithFieldInstruction;
                    Value in2;
                    FieldInstruction fieldPut = instruction.asFieldInstruction();
                    DexField field = fieldPut.getField();
                    if (!this.identifierNameStrings.containsKey(field)) continue;
                    Value value = in2 = instruction.isStaticPut() ? instruction.asStaticPut().inValue() : instruction.asInstancePut().value();
                    if (!in2.isConstString()) {
                        this.warnUndeterminedIdentifierIfNecessary(field, originHolder, instruction, null);
                        continue;
                    }
                    DexString original = in2.getConstInstruction().asConstString().getValue();
                    itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
                    if (itemBasedString == null) {
                        this.warnUndeterminedIdentifierIfNecessary(field, originHolder, instruction, original);
                        continue;
                    }
                    assert (iterator2.peekPrevious() == fieldPut);
                    iterator2.previous();
                    Value newIn = code.createValue(in2.getTypeLattice(), in2.getLocalInfo());
                    DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, throwingInfo);
                    decoupled.setPosition(fieldPut.getPosition());
                    BasicBlock basicBlock = blockWithFieldInstruction = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                    if (blockWithFieldInstruction != block) {
                        iterator2 = block.listIterator(block.getInstructions().size());
                        iterator2.previous();
                        iterator2.add(decoupled);
                        iterator2 = blockWithFieldInstruction.listIterator();
                        assert (iterator2.peekNext() == fieldPut);
                        iterator2.next();
                        block = blockWithFieldInstruction;
                    } else {
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == fieldPut);
                        iterator2.next();
                    }
                    if (instruction.isStaticPut()) {
                        StaticPut staticPut = instruction.asStaticPut();
                        iterator2.replaceCurrentInstruction(new StaticPut(newIn, field));
                    } else {
                        assert (instruction.isInstancePut());
                        InstancePut instancePut = instruction.asInstancePut();
                        iterator2.replaceCurrentInstruction(new InstancePut(field, instancePut.object(), newIn));
                    }
                    encodedMethod.getMutableOptimizationInfo().markUseIdentifierNameString();
                    continue;
                }
                if (!instruction.isInvokeMethod() || !this.identifierNameStrings.containsKey(invokedMethod = (invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
                List<Value> ins = invoke.arguments();
                Value[] changes = new Value[ins.size()];
                if (IdentifierNameStringUtils.isReflectionMethod(this.appView.dexItemFactory(), invokedMethod)) {
                    BasicBlock blockWithInvoke;
                    boolean isReferenceFieldUpdater;
                    itemBasedString = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView);
                    if (itemBasedString == null) {
                        this.warnUndeterminedIdentifierIfNecessary(invokedMethod, originHolder, instruction, null);
                        continue;
                    }
                    DexType returnType = invoke.getReturnType();
                    boolean isClassForName = returnType.descriptor == this.appView.dexItemFactory().classDescriptor;
                    boolean bl = isReferenceFieldUpdater = returnType.descriptor == this.appView.dexItemFactory().referenceFieldUpdaterDescriptor;
                    int positionOfIdentifier = isClassForName ? 0 : (isReferenceFieldUpdater ? 2 : 1);
                    Value in3 = invoke.arguments().get(positionOfIdentifier);
                    assert (iterator2.peekPrevious() == invoke);
                    iterator2.previous();
                    Value newIn = code.createValue(in3.getTypeLattice(), in3.getLocalInfo());
                    DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, throwingInfo);
                    decoupled.setPosition(invoke.getPosition());
                    changes[positionOfIdentifier] = newIn;
                    BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                    if (blockWithInvoke != block) {
                        iterator2 = block.listIterator(block.getInstructions().size());
                        iterator2.previous();
                        iterator2.add(decoupled);
                        iterator2 = blockWithInvoke.listIterator();
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                        block = blockWithInvoke;
                    } else {
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                    }
                } else {
                    for (int i = 0; i < ins.size(); ++i) {
                        BasicBlock blockWithInvoke;
                        Value in4 = ins.get(i);
                        if (!in4.isConstString()) {
                            this.warnUndeterminedIdentifierIfNecessary(invokedMethod, originHolder, instruction, null);
                            continue;
                        }
                        DexString original = in4.getConstInstruction().asConstString().getValue();
                        DexReference itemBasedString2 = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
                        if (itemBasedString2 == null) {
                            this.warnUndeterminedIdentifierIfNecessary(invokedMethod, originHolder, instruction, original);
                            continue;
                        }
                        assert (iterator2.peekPrevious() == invoke);
                        iterator2.previous();
                        Value newIn = code.createValue(in4.getTypeLattice(), in4.getLocalInfo());
                        DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString2, throwingInfo);
                        decoupled.setPosition(invoke.getPosition());
                        changes[i] = newIn;
                        BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                        if (blockWithInvoke != block) {
                            iterator2 = block.listIterator(block.getInstructions().size());
                            iterator2.previous();
                            iterator2.add(decoupled);
                            iterator2 = blockWithInvoke.listIterator();
                            assert (iterator2.peekNext() == invoke);
                            iterator2.next();
                            block = blockWithInvoke;
                            continue;
                        }
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                    }
                }
                if (Arrays.stream(changes).allMatch(Objects::isNull)) continue;
                List<Value> newIns = Streams.mapWithIndex(ins.stream(), (in, index) -> changes[(int)index] != null ? changes[(int)index] : in).collect(Collectors.toList());
                iterator2.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
                encodedMethod.getMutableOptimizationInfo().markUseIdentifierNameString();
            }
        }
    }

    private void warnUndeterminedIdentifierIfNecessary(DexReference member, DexType originHolder, Instruction instruction, DexString original) {
        assert (member.isDexField() || member.isDexMethod());
        boolean matchedByExplicitRule = this.identifierNameStrings.getBoolean(member);
        if (!matchedByExplicitRule) {
            return;
        }
        DexClass originClass = this.appView.definitionFor(originHolder);
        if (originClass != null && originClass.isNotProgramClass()) {
            return;
        }
        if (!this.appView.options().getProguardConfiguration().isObfuscating()) {
            return;
        }
        Origin origin = this.appView.appInfo().originFor(originHolder);
        String kind = member instanceof DexField ? "field" : "method";
        String originalMessage = original == null ? "what identifier string flows to " : "what '" + original.toString() + "' refers to, which flows to ";
        String message = "Cannot determine " + originalMessage + member.toSourceString() + " that is specified in -identifiernamestring rules. Thus, not all identifier strings flowing to that " + kind + " are renamed, which can cause resolution failures at runtime.";
        StringDiagnostic diagnostic = instruction.getPosition().line >= 1 ? new StringDiagnostic(message, origin, new TextPosition(0L, instruction.getPosition().line, 1)) : new StringDiagnostic(message, origin);
        this.appView.options().reporter.warning(diagnostic);
    }
}

