/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MethodNamingState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InterfaceMethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Set<DexCallSite> desugaredCallSites;
    private final Equivalence<DexMethod> equivalence;
    private final MethodNameMinifier.FrontierState frontierState;
    private final MethodNameMinifier.State minifierState;
    private final Map<DexCallSite, DexString> callSiteRenamings = new IdentityHashMap<DexCallSite, DexString>();
    private final Map<Equivalence.Wrapper<DexMethod>, Set<MethodNamingState<?>>> globalStateMap = new HashMap();
    private final Map<Equivalence.Wrapper<DexMethod>, MethodNamingState<?>> originStates = new HashMap();
    private final Map<Equivalence.Wrapper<DexMethod>, Set<DexMethod>> sourceMethodsMap = new HashMap<Equivalence.Wrapper<DexMethod>, Set<DexMethod>>();

    InterfaceMethodNameMinifier(AppView<AppInfoWithLiveness> appView, Set<DexCallSite> desugaredCallSites, Equivalence<DexMethod> equivalence, MethodNameMinifier.FrontierState frontierState, MethodNameMinifier.State minifierState) {
        this.appView = appView;
        this.desugaredCallSites = desugaredCallSites;
        this.equivalence = equivalence;
        this.frontierState = frontierState;
        this.minifierState = minifierState;
    }

    public Comparator<Equivalence.Wrapper<DexMethod>> createDefaultInterfaceMethodOrdering() {
        return (a, b) -> this.globalStateMap.get(b).size() - this.globalStateMap.get(a).size();
    }

    Map<DexCallSite, DexString> getCallSiteRenamings() {
        return this.callSiteRenamings;
    }

    private void reserveNamesInInterfaces(Collection<DexClass> interfaces) {
        for (DexClass iface : interfaces) {
            assert (iface.isInterface());
            this.frontierState.allocateNamingStateAndReserve(iface.type, iface.type, null);
        }
    }

    void assignNamesToInterfaceMethods(Timing timing, Collection<DexClass> interfaces) {
        this.reserveNamesInInterfaces(interfaces);
        timing.begin("Compute map");
        HashSet<DexType> allInterfaceTypes = new HashSet<DexType>(interfaces.size());
        for (DexClass iface : interfaces) {
            allInterfaceTypes.add(iface.type);
        }
        for (DexClass iface : interfaces) {
            Set<MethodNamingState<?>> collectedStates = this.getReachableStates(iface.type, allInterfaceTypes);
            for (DexEncodedMethod dexEncodedMethod : MethodNameMinifier.shuffleMethods(iface.methods(), this.appView.options())) {
                this.addStatesToGlobalMapForMethod(dexEncodedMethod.method, collectedStates, iface.type);
            }
        }
        Sets.SetView<DexCallSite> liveCallSites = Sets.union(this.desugaredCallSites, this.appView.appInfo().callSites);
        IdentityHashMap callSites = new IdentityHashMap();
        HashMap<Equivalence.Wrapper, Equivalence.Wrapper> unificationParent = new HashMap<Equivalence.Wrapper, Equivalence.Wrapper>();
        liveCallSites.forEach(callSite -> {
            HashSet<Equivalence.Wrapper<DexMethod>> callSiteMethods = new HashSet<Equivalence.Wrapper<DexMethod>>();
            Set<DexEncodedMethod> implementedMethods = this.appView.appInfo().lookupLambdaImplementedMethods((DexCallSite)callSite);
            if (implementedMethods.isEmpty()) {
                return;
            }
            callSites.put(callSite, implementedMethods.iterator().next().method);
            for (DexEncodedMethod method : implementedMethods) {
                DexType dexType = method.method.holder;
                Set<MethodNamingState<?>> collectedStates = this.getReachableStates(dexType, allInterfaceTypes);
                this.addStatesToGlobalMapForMethod(method.method, collectedStates, dexType);
                callSiteMethods.add(this.equivalence.wrap(method.method));
            }
            if (callSiteMethods.size() > 1) {
                Equivalence.Wrapper mainKey = (Equivalence.Wrapper)callSiteMethods.iterator().next();
                mainKey = unificationParent.getOrDefault(mainKey, mainKey);
                for (Equivalence.Wrapper wrapper : callSiteMethods) {
                    unificationParent.put(wrapper, mainKey);
                }
            }
        });
        HashMap<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification = new HashMap<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>();
        for (Equivalence.Wrapper key2 : unificationParent.keySet()) {
            Equivalence.Wrapper root = (Equivalence.Wrapper)unificationParent.get(key2);
            while (unificationParent.get(root) != root) {
                Equivalence.Wrapper wrapper2 = (Equivalence.Wrapper)unificationParent.get(unificationParent.get(root));
                unificationParent.put(root, wrapper2);
                root = wrapper2;
            }
            unification.computeIfAbsent(root, k -> new HashSet()).add(key2);
        }
        timing.end();
        timing.begin("Allocate names");
        timing.begin("sort");
        List list = this.globalStateMap.keySet().stream().filter(wrapper -> unificationParent.getOrDefault(wrapper, (Equivalence.Wrapper)wrapper).equals(wrapper)).sorted(this.appView.options().testing.minifier.createInterfaceMethodOrdering(this)).collect(Collectors.toList());
        timing.end();
        timing.begin("propogate");
        List reservedInterfaceMethods = list.stream().filter(wrapper -> this.anyIsReserved((Equivalence.Wrapper<DexMethod>)wrapper, (Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>)unification)).collect(Collectors.toList());
        for (Equivalence.Wrapper wrapper3 : reservedInterfaceMethods) {
            this.propagateReservedNames(wrapper3, unification);
        }
        timing.end();
        timing.begin("assert");
        assert (reservedInterfaceMethods.stream().noneMatch(key -> this.propagateReservedNames((Equivalence.Wrapper<DexMethod>)key, (Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>)unification)));
        timing.end();
        timing.begin("assing interface");
        for (Equivalence.Wrapper wrapper4 : list) {
            if (reservedInterfaceMethods.contains(wrapper4)) continue;
            this.assignNameToInterfaceMethod(wrapper4, unification);
        }
        timing.end();
        timing.begin("callsites");
        for (Map.Entry entry : callSites.entrySet()) {
            DexMethod method = (DexMethod)entry.getValue();
            DexString renamed = this.minifierState.getRenaming(method);
            if (this.originStates.get(this.equivalence.wrap(method)).isReserved(method.name, method.proto)) {
                assert (renamed == null);
                this.callSiteRenamings.put((DexCallSite)entry.getKey(), method.name);
                continue;
            }
            assert (renamed != null);
            this.callSiteRenamings.put((DexCallSite)entry.getKey(), renamed);
        }
        timing.end();
        timing.end();
    }

    private boolean propagateReservedNames(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        Set<Equivalence.Wrapper<DexMethod>> unifiedMethods = unification.getOrDefault(key, Collections.singleton(key));
        boolean changed = false;
        for (Equivalence.Wrapper<DexMethod> wrapper : unifiedMethods) {
            DexMethod unifiedMethod = wrapper.get();
            assert (unifiedMethod != null);
            assert (this.globalStateMap.containsKey(wrapper)) : "Expected globalStateMap to contain " + unifiedMethod.toSourceStringWithoutHolder();
            assert (this.globalStateMap.get(wrapper) != null) : "Expected globalStateMap to map " + unifiedMethod.toSourceStringWithoutHolder() + " to a non-null MethodNamingState.";
            for (MethodNamingState<?> namingState : this.globalStateMap.get(wrapper)) {
                if (namingState.isReserved(unifiedMethod.name, unifiedMethod.proto)) continue;
                namingState.reserveName(unifiedMethod.name, unifiedMethod.proto, unifiedMethod.name);
                changed = true;
            }
        }
        return changed;
    }

    private void assignNameToInterfaceMethod(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        ArrayList<InterfaceMethodNamingState> collectedStates = new ArrayList<InterfaceMethodNamingState>();
        Set<DexMethod> sourceMethods = Sets.newIdentityHashSet();
        for (Equivalence.Wrapper<DexMethod> k : unification.getOrDefault(key, Collections.singleton(key))) {
            DexMethod unifiedMethod = k.get();
            assert (unifiedMethod != null);
            sourceMethods.addAll((Collection)this.sourceMethodsMap.get(k));
            for (MethodNamingState<?> namingState : this.globalStateMap.get(k)) {
                collectedStates.add(new InterfaceMethodNamingState(namingState, unifiedMethod, unifiedMethod.name, unifiedMethod.proto));
            }
        }
        DexMethod method = key.get();
        assert (method != null);
        Set<String> loggingFilter = this.appView.options().extensiveInterfaceMethodMinifierLoggingFilter;
        if (!loggingFilter.isEmpty()) {
            if (sourceMethods.stream().map(DexMethod::toSourceString).anyMatch(loggingFilter::contains)) {
                this.print(method, sourceMethods, collectedStates, System.out);
            }
        }
        InterfaceMethodNamingState originState = new InterfaceMethodNamingState(this.originStates.get(key), method, method.name, method.proto);
        this.assignNameForInterfaceMethodInAllStates(collectedStates, sourceMethods, originState);
    }

    private void assignNameForInterfaceMethodInAllStates(List<InterfaceMethodNamingState> collectedStates, Set<DexMethod> sourceMethods, InterfaceMethodNamingState originState) {
        DexString candidate;
        assert (!this.anyIsReserved(collectedStates));
        block0: do {
            candidate = originState.assignNewName();
            for (InterfaceMethodNamingState state : collectedStates) {
                if (state.isAvailable(candidate)) continue;
                candidate = null;
                continue block0;
            }
        } while (candidate == null);
        for (InterfaceMethodNamingState state : collectedStates) {
            state.addRenaming(candidate);
        }
        for (DexMethod sourceMethod : sourceMethods) {
            this.minifierState.putRenaming(sourceMethod, candidate);
        }
    }

    private void addStatesToGlobalMapForMethod(DexMethod method, Set<MethodNamingState<?>> collectedStates, DexType originInterface) {
        assert (collectedStates.stream().noneMatch(Objects::isNull));
        Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(method);
        this.globalStateMap.computeIfAbsent(key, k -> new HashSet()).addAll(collectedStates);
        this.sourceMethodsMap.computeIfAbsent(key, k -> new HashSet()).add(method);
        this.originStates.putIfAbsent(key, this.minifierState.getState(originInterface));
    }

    private boolean anyIsReserved(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        Set<Equivalence.Wrapper<DexMethod>> unifiedMethods = unification.getOrDefault(key, Collections.singleton(key));
        for (Equivalence.Wrapper<DexMethod> wrapper : unifiedMethods) {
            DexMethod unifiedMethod = wrapper.get();
            assert (unifiedMethod != null);
            assert (this.globalStateMap.containsKey(wrapper)) : "Expected globalStateMap to contain " + unifiedMethod.toSourceStringWithoutHolder();
            assert (this.globalStateMap.get(wrapper) != null) : "Expected globalStateMap to map " + unifiedMethod.toSourceStringWithoutHolder() + " to a non-null MethodNamingState.";
            for (MethodNamingState<?> namingState : this.globalStateMap.get(wrapper)) {
                if (!namingState.isReserved(unifiedMethod.name, unifiedMethod.proto)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean anyIsReserved(List<InterfaceMethodNamingState> collectedStates) {
        DexString name = collectedStates.get(0).getName();
        IdentityHashMap<DexProto, Boolean> globalStateCache = new IdentityHashMap<DexProto, Boolean>();
        for (InterfaceMethodNamingState state : collectedStates) {
            assert (state.getName() == name);
            boolean isReservedInGlobalState = globalStateCache.computeIfAbsent(state.getProto(), proto -> this.minifierState.isReservedInGlobalState(name, (DexProto)proto));
            if (!isReservedInGlobalState || !state.isReserved()) continue;
            return true;
        }
        return false;
    }

    private Set<MethodNamingState<?>> getReachableStates(DexType type, Set<DexType> allInterfaces) {
        Set<DexType> reachableInterfaces = this.getReachableInterfaces(type, allInterfaces);
        HashSet reachableStates = new HashSet();
        for (DexType reachableInterface : reachableInterfaces) {
            MethodNamingState<?> ifaceState = this.minifierState.getState(reachableInterface);
            assert (ifaceState != null);
            reachableStates.add(ifaceState);
            for (DexType frontier : this.appView.appInfo().allImplementsSubtypes(reachableInterface)) {
                MethodNamingState<?> state = this.minifierState.getState(this.frontierState.get(frontier));
                assert (state != null);
                reachableStates.add(state);
            }
        }
        return reachableStates;
    }

    private Set<DexType> getReachableInterfaces(DexType type, Set<DexType> allInterfaces) {
        if (!allInterfaces.contains(type)) {
            return Collections.emptySet();
        }
        Set<DexType> reachableInterfaces = Sets.newIdentityHashSet();
        reachableInterfaces.add(type);
        this.collectSuperInterfaces(type, reachableInterfaces, allInterfaces);
        this.collectSubInterfaces(type, reachableInterfaces, allInterfaces);
        return reachableInterfaces;
    }

    private void collectSuperInterfaces(DexType iface, Set<DexType> reachable, Set<DexType> allInterfaces) {
        DexClass clazz = this.appView.definitionFor(iface);
        if (clazz != null) {
            for (DexType type : clazz.interfaces.values) {
                if (!allInterfaces.contains(type) || !reachable.add(type)) continue;
                this.collectSuperInterfaces(type, reachable, allInterfaces);
            }
        }
    }

    private void collectSubInterfaces(DexType iface, Set<DexType> reachableInterfaces, Set<DexType> allInterfaces) {
        for (DexType subtype : this.appView.appInfo().allExtendsSubtypes(iface)) {
            if (!allInterfaces.contains(subtype) || !reachableInterfaces.add(subtype)) continue;
            this.collectSubInterfaces(subtype, reachableInterfaces, allInterfaces);
        }
    }

    private void print(DexMethod method, Set<DexMethod> sourceMethods, List<InterfaceMethodNamingState> collectedStates, PrintStream out) {
        out.println("-----------------------------------------------------------------------");
        out.println("assignNameToInterfaceMethod(`" + method.toSourceString() + "`)");
        out.println("-----------------------------------------------------------------------");
        out.println("Source methods:");
        for (DexMethod sourceMethod : sourceMethods) {
            out.println("  " + sourceMethod.toSourceString());
        }
        out.println("States:");
        collectedStates.forEach(state -> state.print("  ", this.minifierState::getStateKey, out));
        out.println();
    }

    static class InterfaceMethodNamingState {
        private final MethodNamingState<?> parent;
        private final DexString name;
        private final DexProto proto;
        private final DexMethod method;

        InterfaceMethodNamingState(MethodNamingState<?> parent, DexMethod method, DexString name, DexProto proto) {
            this.method = method;
            assert (parent != null);
            this.parent = parent;
            this.name = name;
            this.proto = proto;
        }

        DexString assignNewName() {
            return this.parent.assignNewNameFor(this.method, this.name, this.proto);
        }

        boolean isReserved() {
            return this.parent.isReserved(this.name, this.proto);
        }

        boolean isAvailable(DexString candidate) {
            return this.parent.isAvailable(this.proto, candidate);
        }

        void addRenaming(DexString newName) {
            this.parent.addRenaming(this.name, this.proto, newName);
        }

        DexString getName() {
            return this.name;
        }

        DexProto getProto() {
            return this.proto;
        }

        void print(String indentation, Function<MethodNamingState<?>, DexType> stateKeyGetter, PrintStream out) {
            DexType stateKey = stateKeyGetter.apply(this.parent);
            out.print(indentation);
            out.print(stateKey != null ? stateKey.toSourceString() : "<?>");
            out.print(".");
            out.print(this.name.toSourceString());
            out.println(this.proto.toSmaliString());
            this.parent.printState(this.proto, stateKeyGetter, indentation + "  ", out);
        }
    }
}

