/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.InterfaceMethodNameMinifier;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.MethodNamingState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Equivalence<DexMethod> equivalence;
    private final MemberNamingStrategy strategy;
    private final Map<DexMethod, DexString> renaming = new IdentityHashMap<DexMethod, DexString>();
    private final MethodNamingState<?> globalState;
    private final State minifierState = new State();
    private final FrontierState frontierState = new FrontierState();
    private final BiMap<DexType, MethodNamingState<?>> states = HashBiMap.create();

    MethodNameMinifier(AppView<AppInfoWithLiveness> appView, MemberNamingStrategy strategy) {
        this.appView = appView;
        this.equivalence = appView.options().getProguardConfiguration().isOverloadAggressively() ? MethodSignatureEquivalence.get() : MethodJavaSignatureEquivalence.get();
        this.globalState = MethodNamingState.createRoot(this.getKeyTransform(), strategy);
        this.strategy = strategy;
    }

    private MethodNamingState<?> computeStateIfAbsent(DexType type, Function<DexType, MethodNamingState<?>> f) {
        return this.states.computeIfAbsent(type, f);
    }

    private Function<DexProto, ?> getKeyTransform() {
        if (this.appView.options().getProguardConfiguration().isOverloadAggressively()) {
            return a -> a;
        }
        return proto -> proto.parameters;
    }

    MethodRenaming computeRenaming(Collection<DexClass> interfaces, Set<DexCallSite> desugaredCallSites, Timing timing) {
        timing.begin("Phase 1");
        this.reserveNamesInClasses();
        timing.end();
        timing.begin("Phase 2");
        InterfaceMethodNameMinifier interfaceMethodNameMinifier = new InterfaceMethodNameMinifier(this.appView, desugaredCallSites, this.equivalence, this.frontierState, this.minifierState);
        timing.end();
        timing.begin("Phase 3");
        interfaceMethodNameMinifier.assignNamesToInterfaceMethods(timing, interfaces);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appView.dexItemFactory().objectType);
        timing.end();
        return new MethodRenaming(this.renaming, interfaceMethodNameMinifier.getCallSiteRenamings());
    }

    private void assignNamesToClassesMethods(DexType type) {
        boolean shouldAssignName;
        DexClass holder = this.appView.definitionFor(type);
        boolean bl = shouldAssignName = holder != null && this.strategy.allowMemberRenaming(holder);
        if (shouldAssignName) {
            MethodNamingState<?> state = this.computeStateIfAbsent(type, k -> this.minifierState.getState(holder.superType).createChild());
            for (DexEncodedMethod method : holder.virtualMethodsSorted()) {
                this.assignNameToMethod(method, state, holder);
            }
            for (DexEncodedMethod method : holder.directMethodsSorted()) {
                this.assignNameToMethod(method, state, holder);
            }
        }
        this.appView.appInfo().forAllExtendsSubtypes(type, this::assignNamesToClassesMethods);
    }

    private void assignNameToMethod(DexEncodedMethod encodedMethod, MethodNamingState<?> state, DexClass holder) {
        if (encodedMethod.accessFlags.isConstructor()) {
            return;
        }
        DexMethod method = encodedMethod.method;
        DexString reservedName = this.strategy.getReservedNameOrDefault(encodedMethod, holder, method.name);
        if (state.isReserved(reservedName, method.proto)) {
            return;
        }
        DexString newName = state.assignNewNameFor(method, method.name, method.proto);
        if (newName != method.name) {
            this.addRenaming(encodedMethod, state, newName);
        }
    }

    private void addRenaming(DexEncodedMethod encodedMethod, MethodNamingState<?> state, DexString renamedName) {
        this.renaming.put(encodedMethod.method, renamedName);
        if (!encodedMethod.accessFlags.isPrivate()) {
            state.addRenaming(encodedMethod.method.name, encodedMethod.method.proto, renamedName);
        }
    }

    private void reserveNamesInClasses() {
        this.reserveNamesInClasses(this.appView.dexItemFactory().objectType, this.appView.dexItemFactory().objectType, null);
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, MethodNamingState<?> parent) {
        assert (this.appView.isInterface(type).isFalse());
        MethodNamingState<?> state = this.frontierState.allocateNamingStateAndReserve(type, libraryFrontier, parent);
        DexClass holder = this.appView.definitionFor(type);
        for (DexType subtype : this.appView.appInfo().allExtendsSubtypes(type)) {
            this.reserveNamesInClasses(subtype, holder == null || holder.isNotProgramClass() ? subtype : libraryFrontier, state);
        }
    }

    static Iterable<DexEncodedMethod> shuffleMethods(Iterable<DexEncodedMethod> methods, InternalOptions options) {
        return options.testing.irOrdering.order(methods);
    }

    class FrontierState {
        private final Map<DexType, DexType> frontiers = new IdentityHashMap<DexType, DexType>();

        FrontierState() {
        }

        MethodNamingState<?> allocateNamingStateAndReserve(DexType type, DexType frontier, MethodNamingState<?> parent) {
            if (frontier != type) {
                this.frontiers.put(type, frontier);
            }
            MethodNamingState state = MethodNameMinifier.this.computeStateIfAbsent(frontier, ignore -> parent == null ? MethodNamingState.createRoot(MethodNameMinifier.this.getKeyTransform(), MethodNameMinifier.this.strategy) : parent.createChild());
            DexClass holder = MethodNameMinifier.this.appView.definitionFor(type);
            if (holder != null) {
                for (DexEncodedMethod method : MethodNameMinifier.shuffleMethods(holder.methods(), MethodNameMinifier.this.appView.options())) {
                    DexString reservedName = MethodNameMinifier.this.strategy.getReservedNameOrDefault(method, holder, null);
                    if (reservedName == null) continue;
                    DexString previouslyReservedOriginalName = state.getReservedOriginalName(reservedName, method.method.proto);
                    if (previouslyReservedOriginalName != null && previouslyReservedOriginalName != method.method.name) {
                        MethodNameMinifier.this.strategy.reportReservationError(method.method, reservedName);
                    }
                    state.reserveName(reservedName, method.method.proto, method.method.name);
                    MethodNameMinifier.this.globalState.reserveName(reservedName, method.method.proto, method.method.name);
                    if (reservedName == method.method.name) continue;
                    MethodNameMinifier.this.addRenaming(method, state, reservedName);
                }
            }
            return state;
        }

        public DexType get(DexType type) {
            return this.frontiers.getOrDefault(type, type);
        }

        public DexType put(DexType type, DexType frontier) {
            assert (frontier != type);
            return this.frontiers.put(type, frontier);
        }
    }

    static class MethodRenaming {
        final Map<DexMethod, DexString> renaming;
        final Map<DexCallSite, DexString> callSiteRenaming;

        private MethodRenaming(Map<DexMethod, DexString> renaming, Map<DexCallSite, DexString> callSiteRenaming) {
            this.renaming = renaming;
            this.callSiteRenaming = callSiteRenaming;
        }

        public static MethodRenaming empty() {
            return new MethodRenaming(ImmutableMap.of(), ImmutableMap.of());
        }
    }

    class State {
        State() {
        }

        DexString getRenaming(DexMethod key) {
            return (DexString)MethodNameMinifier.this.renaming.get(key);
        }

        void putRenaming(DexMethod key, DexString value) {
            MethodNameMinifier.this.renaming.put(key, value);
        }

        MethodNamingState<?> getState(DexType type) {
            return (MethodNamingState)MethodNameMinifier.this.states.get(type);
        }

        DexType getStateKey(MethodNamingState<?> state) {
            return (DexType)MethodNameMinifier.this.states.inverse().get(state);
        }

        boolean isReservedInGlobalState(DexString name, DexProto state) {
            return MethodNameMinifier.this.globalState.isReserved(name, state);
        }
    }
}

