/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class MethodNamingState<KeyType> {
    private final MethodNamingState<KeyType> parent;
    private final Map<KeyType, InternalReservationState> usedNames = new HashMap<KeyType, InternalReservationState>();
    private final Map<KeyType, InternalNewNameState> newNameStates = new HashMap<KeyType, InternalNewNameState>();
    private final Function<DexProto, KeyType> keyTransform;
    private final MemberNamingStrategy strategy;

    static <S> MethodNamingState<S> createRoot(Function<DexProto, S> keyTransform, MemberNamingStrategy strategy) {
        return new MethodNamingState<S>(null, keyTransform, strategy);
    }

    private MethodNamingState(MethodNamingState<KeyType> parent, Function<DexProto, KeyType> keyTransform, MemberNamingStrategy strategy) {
        this.parent = parent;
        this.keyTransform = keyTransform;
        this.strategy = strategy;
    }

    MethodNamingState<KeyType> createChild() {
        return new MethodNamingState<KeyType>(this, this.keyTransform, this.strategy);
    }

    private InternalReservationState findInternalReservationStateFor(KeyType key) {
        InternalReservationState result = this.usedNames.get(key);
        if (result == null && this.parent != null) {
            result = super.findInternalReservationStateFor(key);
        }
        return result;
    }

    private InternalReservationState getOrCreateInternalReservationStateFor(KeyType key) {
        InternalReservationState result = this.usedNames.get(key);
        if (result == null) {
            InternalReservationState parentState = this.parent != null ? super.getOrCreateInternalReservationStateFor(key) : null;
            result = new InternalReservationState(parentState);
            this.usedNames.put(key, result);
        }
        return result;
    }

    private InternalNewNameState findInternalNewNameStateFor(KeyType key) {
        InternalNewNameState result = this.newNameStates.get(key);
        if (result == null && this.parent != null) {
            result = super.findInternalNewNameStateFor(key);
        }
        return result;
    }

    private InternalNewNameState getOrCreateNewNameStateFor(KeyType key) {
        InternalNewNameState result = this.newNameStates.get(key);
        if (result == null) {
            InternalReservationState reservationState = this.getOrCreateInternalReservationStateFor(key);
            assert (reservationState != null);
            InternalNewNameState parentState = this.parent != null ? super.getOrCreateNewNameStateFor(key) : null;
            result = new InternalNewNameState(parentState, reservationState);
            this.newNameStates.put(key, result);
        }
        return result;
    }

    private DexString getAssignedNameFor(DexString name, KeyType key) {
        InternalReservationState state = this.findInternalReservationStateFor(key);
        if (state == null) {
            return null;
        }
        return state.getAssignedNameFor(name);
    }

    DexString assignNewNameFor(DexMethod source, DexString original, DexProto proto) {
        KeyType key = this.keyTransform.apply(proto);
        DexString result = this.getAssignedNameFor(original, key);
        if (result == null) {
            InternalNewNameState state = this.getOrCreateNewNameStateFor(key);
            result = state.getNewNameFor(source);
        }
        return result;
    }

    void reserveName(DexString name, DexProto proto, DexString originalName) {
        KeyType key = this.keyTransform.apply(proto);
        InternalReservationState state = this.getOrCreateInternalReservationStateFor(key);
        state.reserveName(name, originalName);
    }

    boolean isReserved(DexString name, DexProto proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalReservationState state = this.findInternalReservationStateFor(key);
        if (state == null) {
            return false;
        }
        return state.isReserved(name);
    }

    DexString getReservedOriginalName(DexString name, DexProto proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalReservationState state = this.findInternalReservationStateFor(key);
        if (state == null) {
            return null;
        }
        return state.getReservedOriginalName(name);
    }

    boolean isAvailable(DexProto proto, DexString candidate) {
        KeyType key = this.keyTransform.apply(proto);
        InternalReservationState state = this.findInternalReservationStateFor(key);
        if (state == null) {
            return true;
        }
        return state.isAvailable(candidate);
    }

    void addRenaming(DexString original, DexProto proto, DexString newName) {
        KeyType key = this.keyTransform.apply(proto);
        InternalReservationState state = this.getOrCreateInternalReservationStateFor(key);
        state.addRenaming(original, newName);
    }

    void printState(DexProto proto, Function<MethodNamingState<?>, DexType> stateKeyGetter, String indentation, PrintStream out) {
        KeyType key = this.keyTransform.apply(proto);
        InternalNewNameState state = this.getOrCreateNewNameStateFor(key);
        out.print(indentation);
        out.print("NamingState(node=`");
        out.print(stateKeyGetter.apply(this).toSourceString());
        out.print("`, proto=`");
        out.print(proto.toSourceString());
        out.print("`, key=`");
        out.print(key.toString());
        out.println("`)");
        if (state != null) {
            state.printInternalState(this, stateKeyGetter, indentation + "  ", out);
        } else {
            out.print(indentation);
            out.println("<NO STATE>");
        }
    }

    class InternalNewNameState
    implements InternalNamingState {
        private final InternalNewNameState parentInternalState;
        private final InternalReservationState reservationState;
        private static final int INITIAL_NAME_COUNT = 1;
        private static final int INITIAL_DICTIONARY_INDEX = 0;
        private int virtualNameCount;
        private int directNameCount = 0;
        private int dictionaryIndex;

        private InternalNewNameState(InternalNewNameState parentInternalState, InternalReservationState reservationState) {
            this.parentInternalState = parentInternalState;
            this.reservationState = reservationState;
            this.dictionaryIndex = parentInternalState == null ? 0 : parentInternalState.dictionaryIndex;
            int n = this.virtualNameCount = parentInternalState == null ? 1 : parentInternalState.virtualNameCount;
            assert (reservationState != null);
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        private boolean checkParentPublicNameCountIsLessThanOrEqual() {
            int maxParentCount = 0;
            InternalNewNameState tmp = this.parentInternalState;
            while (tmp != null) {
                maxParentCount = Math.max(tmp.virtualNameCount, maxParentCount);
                tmp = tmp.parentInternalState;
            }
            assert (maxParentCount <= this.virtualNameCount);
            return true;
        }

        @Override
        public int incrementNameIndex(boolean isDirectMethodCall) {
            assert (this.checkParentPublicNameCountIsLessThanOrEqual());
            if (isDirectMethodCall) {
                return this.virtualNameCount + this.directNameCount++;
            }
            assert (this.directNameCount == 0);
            return this.virtualNameCount++;
        }

        private DexString getNewNameFor(DexMethod source) {
            DexString name;
            while (!this.reservationState.isAvailable(name = MethodNamingState.this.strategy.next(source, (InternalNamingState)this))) {
            }
            return name;
        }

        void printInternalState(MethodNamingState<?> expectedNamingState, Function<MethodNamingState<?>, DexType> stateKeyGetter, String indentation, PrintStream out) {
            assert (expectedNamingState == MethodNamingState.this);
            DexType stateKey = stateKeyGetter.apply(expectedNamingState);
            out.print(indentation);
            out.print("InternalState(node=`");
            out.print(stateKey != null ? stateKey.toSourceString() : "<GLOBAL>");
            out.println("`)");
            this.printLastName(indentation + "  ", out);
            this.reservationState.printReservedNames(indentation + "  ", out);
            this.reservationState.printRenamings(indentation + "  ", out);
            if (this.parentInternalState != null) {
                this.parentInternalState.printInternalState(((MethodNamingState)expectedNamingState).parent, stateKeyGetter, indentation + "  ", out);
            }
        }

        void printLastName(String indentation, PrintStream out) {
            out.print(indentation);
            out.print("public name count: ");
            out.print(this.virtualNameCount);
            out.print(", ");
            out.print("direct name count: ");
            out.println(this.directNameCount);
        }
    }

    class InternalReservationState {
        private final InternalReservationState parentInternalState;
        private Map<DexString, DexString> reservedNames = null;
        private Map<DexString, DexString> renamings = null;

        private InternalReservationState(InternalReservationState parentInternalState) {
            this.parentInternalState = parentInternalState;
        }

        boolean isReserved(DexString name) {
            return this.reservedNames != null && this.reservedNames.containsKey(name) || this.parentInternalState != null && this.parentInternalState.isReserved(name);
        }

        DexString getReservedOriginalName(DexString name) {
            DexString result = null;
            if (this.reservedNames != null) {
                result = this.reservedNames.get(name);
            }
            if (result == null && this.parentInternalState != null) {
                result = this.parentInternalState.getReservedOriginalName(name);
            }
            return result;
        }

        DexString getAssignedNameFor(DexString original) {
            DexString result = null;
            if (this.renamings != null) {
                result = this.renamings.get(original);
            }
            if (result == null && this.parentInternalState != null) {
                result = this.parentInternalState.getAssignedNameFor(original);
            }
            return result;
        }

        private boolean isAvailable(DexString name) {
            return !(this.renamings != null && this.renamings.containsValue(name) || this.reservedNames != null && this.reservedNames.containsKey(name) || this.parentInternalState != null && !this.parentInternalState.isAvailable(name));
        }

        void reserveName(DexString name, DexString originalName) {
            if (this.reservedNames == null) {
                this.reservedNames = new HashMap<DexString, DexString>();
            }
            this.reservedNames.put(name, originalName);
        }

        void addRenaming(DexString original, DexString newName) {
            if (this.renamings == null) {
                this.renamings = new HashMap<DexString, DexString>();
            }
            this.renamings.put(original, newName);
        }

        void printReservedNames(String indentation, PrintStream out) {
            out.print(indentation);
            out.print("Reserved names:");
            if (this.reservedNames == null || this.reservedNames.isEmpty()) {
                out.print(" <NO RESERVED NAMES>");
            } else {
                for (DexString reservedName : this.reservedNames.keySet()) {
                    out.print(System.lineSeparator());
                    out.print(indentation);
                    out.print("  ");
                    out.print(reservedName.toSourceString() + "(by " + this.reservedNames.get(reservedName) + ")");
                }
            }
            out.println();
        }

        void printRenamings(String indentation, PrintStream out) {
            out.print(indentation);
            out.print("Renamings:");
            if (this.renamings == null || this.renamings.isEmpty()) {
                out.print(" <NO RENAMINGS>");
            } else {
                for (DexString original : this.renamings.keySet()) {
                    out.print(System.lineSeparator());
                    out.print(indentation);
                    out.print("  ");
                    out.print(original.toSourceString());
                    out.print(" -> ");
                    out.print(this.renamings.get(original).toSourceString());
                }
            }
            out.println();
        }
    }
}

