/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

class MinifiedRenaming
extends NamingLens {
    private final AppView<?> appView;
    private final Map<String, String> packageRenaming;
    private final Map<DexItem, DexString> renaming = new IdentityHashMap<DexItem, DexString>();

    MinifiedRenaming(AppView<?> appView, ClassNameMinifier.ClassRenaming classRenaming, MethodNameMinifier.MethodRenaming methodRenaming, FieldNameMinifier.FieldRenaming fieldRenaming) {
        this.appView = appView;
        this.packageRenaming = classRenaming.packageRenaming;
        this.renaming.putAll(classRenaming.classRenaming);
        this.renaming.putAll(methodRenaming.renaming);
        this.renaming.putAll(methodRenaming.callSiteRenaming);
        this.renaming.putAll(fieldRenaming.renaming);
    }

    @Override
    public String lookupPackageName(String packageName) {
        return this.packageRenaming.getOrDefault(packageName, packageName);
    }

    @Override
    public DexString lookupDescriptor(DexType type) {
        return this.renaming.getOrDefault(type, type.descriptor);
    }

    @Override
    public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
        int index;
        String innerTypeMapped;
        if (attribute.getInnerName() == null) {
            return null;
        }
        DexType innerType = attribute.getInner();
        String inner = DescriptorUtils.descriptorToInternalName(innerType.descriptor.toString());
        if (inner.equals(innerTypeMapped = DescriptorUtils.descriptorToInternalName(this.lookupDescriptor(innerType).toString()))) {
            return attribute.getInnerName();
        }
        String separator = DescriptorUtils.computeInnerClassSeparator(attribute.getOuter(), innerType, attribute.getInnerName());
        if (separator == null) {
            separator = String.valueOf('$');
        }
        if ((index = innerTypeMapped.lastIndexOf(separator)) < 0) {
            assert (false) : innerType + " -> " + innerTypeMapped;
            String descriptor = this.lookupDescriptor(innerType).toString();
            return options.itemFactory.createString(DescriptorUtils.getUnqualifiedClassNameFromDescriptor(descriptor));
        }
        return options.itemFactory.createString(innerTypeMapped.substring(index + separator.length()));
    }

    @Override
    public DexString lookupName(DexMethod method) {
        return this.renaming.getOrDefault(method, method.name);
    }

    @Override
    public DexString lookupMethodName(DexCallSite callSite) {
        return this.renaming.getOrDefault(callSite, callSite.methodName);
    }

    @Override
    public DexString lookupName(DexField field) {
        return this.renaming.getOrDefault(field, field.name);
    }

    @Override
    void forAllRenamedTypes(Consumer<DexType> consumer) {
        DexReference.filterDexType(DexReference.filterDexReference(this.renaming.keySet().stream())).forEach(consumer);
    }

    @Override
    <T extends DexItem> Map<String, T> getRenamedItems(Class<T> clazz, Predicate<T> predicate, Function<T, String> namer) {
        return this.renaming.keySet().stream().filter(item -> clazz.isInstance(item) && predicate.test((DexItem)clazz.cast(item))).map(clazz::cast).collect(ImmutableMap.toImmutableMap(namer, i -> i));
    }

    @Override
    public boolean checkTargetCanBeTranslated(DexMethod item) {
        if (item.holder.isArrayType()) {
            return true;
        }
        DexClass holder = this.appView.definitionFor(item.holder);
        if (holder == null || holder.isNotProgramClass()) {
            return true;
        }
        DexEncodedMethod staticTarget = ((AppInfo)this.appView.appInfo()).lookupStaticTarget(item);
        DexEncodedMethod directTarget = ((AppInfo)this.appView.appInfo()).lookupDirectTarget(item);
        DexEncodedMethod virtualTarget = ((AppInfo)this.appView.appInfo()).lookupVirtualTarget(item.holder, item);
        DexClass staticTargetHolder = staticTarget != null ? this.appView.definitionFor(staticTarget.method.holder) : null;
        DexClass directTargetHolder = directTarget != null ? this.appView.definitionFor(directTarget.method.holder) : null;
        DexClass virtualTargetHolder = virtualTarget != null ? this.appView.definitionFor(virtualTarget.method.holder) : null;
        return directTarget == null && staticTarget == null && virtualTarget == null || virtualTarget != null && virtualTarget.method == item || directTarget != null && directTarget.method == item || staticTarget != null && staticTarget.method == item || directTargetHolder != null && directTargetHolder.isNotProgramClass() || virtualTargetHolder != null && virtualTargetHolder.isNotProgramClass() || staticTargetHolder != null && staticTargetHolder.isNotProgramClass() || this.appView.unneededVisibilityBridgeMethods().contains(item);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.renaming.forEach((item, str) -> {
            if (item instanceof DexType) {
                builder.append("[c] ");
            } else if (item instanceof DexMethod) {
                builder.append("[m] ");
            } else if (item instanceof DexField) {
                builder.append("[f] ");
            }
            builder.append(item.toSourceString());
            builder.append(" -> ");
            builder.append(str.toSourceString());
            builder.append('\n');
        });
        return builder.toString();
    }
}

