/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.IdentifierMinifier;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MinifiedRenaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.SymbolGenerationUtils;
import com.android.tools.r8.utils.Timing;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Minifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Set<DexCallSite> desugaredCallSites;

    public Minifier(AppView<AppInfoWithLiveness> appView, Set<DexCallSite> desugaredCallSites) {
        this.appView = appView;
        this.desugaredCallSites = desugaredCallSites;
    }

    public NamingLens run(Timing timing) {
        assert (this.appView.options().isMinifying());
        timing.begin("ComputeInterfaces");
        TreeSet<DexClass> interfaces = new TreeSet<DexClass>((a, b) -> a.type.slowCompareTo(b.type));
        interfaces.addAll(this.appView.appInfo().computeReachableInterfaces(this.desugaredCallSites));
        timing.end();
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new MinificationClassNamingStrategy(this.appView), new MinificationPackageNamingStrategy(this.appView), this.appView.appInfo().classesWithDeterministicOrder());
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, MethodNameMinifier.MethodRenaming.empty(), FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        MinifierMemberNamingStrategy minifyMembers = new MinifierMemberNamingStrategy(this.appView);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, minifyMembers).computeRenaming(interfaces, this.desugaredCallSites, timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, methodRenaming, FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, minifyMembers).computeRenaming(interfaces, timing);
        timing.end();
        MinifiedRenaming lens = new MinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming);
        assert (lens.verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run();
        timing.end();
        return lens;
    }

    static class MinifierMemberNamingStrategy
    extends BaseMinificationNamingStrategy
    implements MemberNamingStrategy {
        final AppView<?> appView;
        private final DexItemFactory factory;

        public MinifierMemberNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getObfuscationDictionary(), false);
            this.appView = appView;
            this.factory = appView.dexItemFactory();
        }

        @Override
        public DexString next(DexMethod method, InternalNamingState internalState) {
            assert (this.checkAllowMemberRenaming(method.holder));
            DexEncodedMethod encodedMethod = this.appView.definitionFor(method);
            boolean isDirectOrStatic = encodedMethod.isDirectMethod() || encodedMethod.isStatic();
            return this.getNextName(internalState, isDirectOrStatic);
        }

        @Override
        public DexString next(DexField field, InternalNamingState internalState) {
            assert (this.checkAllowMemberRenaming(field.holder));
            return this.getNextName(internalState, false);
        }

        private DexString getNextName(InternalNamingState internalState, boolean isDirectOrStatic) {
            return this.factory.createString(this.nextName(StringUtils.EMPTY_CHAR_ARRAY, internalState, isDirectOrStatic));
        }

        @Override
        public DexString getReservedNameOrDefault(DexEncodedMethod method, DexClass holder, DexString defaultValue) {
            if (!this.allowMemberRenaming(holder) || holder.accessFlags.isAnnotation() || method.accessFlags.isConstructor() || this.appView.rootSet().mayNotBeMinified(method.method, this.appView)) {
                return method.method.name;
            }
            return defaultValue;
        }

        @Override
        public DexString getReservedNameOrDefault(DexEncodedField field, DexClass holder, DexString defaultValue) {
            if (holder.isLibraryClass() || this.appView.rootSet().mayNotBeMinified(field.field, this.appView)) {
                return field.field.name;
            }
            return defaultValue;
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return holder.isProgramClass();
        }

        public boolean checkAllowMemberRenaming(DexType holder) {
            DexClass clazz = this.appView.definitionFor(holder);
            assert (clazz != null && this.allowMemberRenaming(clazz));
            return true;
        }

        @Override
        public void reportReservationError(DexReference source, DexString name) {
            assert (false);
        }
    }

    static class MinificationPackageNamingStrategy
    extends BaseMinificationNamingStrategy
    implements ClassNameMinifier.PackageNamingStrategy {
        MinificationPackageNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getPackageObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
        }

        @Override
        public String next(char[] packagePrefix, InternalNamingState state) {
            return this.nextName(packagePrefix, state, false).substring(1);
        }
    }

    static class MinificationClassNamingStrategy
    extends BaseMinificationNamingStrategy
    implements ClassNameMinifier.ClassNamingStrategy {
        final AppView<?> appView;
        private final DexItemFactory factory;

        MinificationClassNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getClassObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
            this.appView = appView;
            this.factory = appView.dexItemFactory();
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state) {
            return this.factory.createString(this.nextName(packagePrefix, state, false) + ";");
        }

        @Override
        public boolean noObfuscation(DexType type) {
            return this.appView.rootSet().mayNotBeMinified(type, this.appView);
        }
    }

    static abstract class BaseMinificationNamingStrategy {
        private final List<String> obfuscationDictionary;
        private final Set<String> obfuscationDictionaryForLookup;
        private final SymbolGenerationUtils.MixedCasing mixedCasing;

        BaseMinificationNamingStrategy(List<String> obfuscationDictionary, boolean dontUseMixedCasing) {
            this.obfuscationDictionary = obfuscationDictionary;
            this.obfuscationDictionaryForLookup = new HashSet<String>(this.obfuscationDictionary);
            SymbolGenerationUtils.MixedCasing mixedCasing = this.mixedCasing = dontUseMixedCasing ? SymbolGenerationUtils.MixedCasing.DONT_USE_MIXED_CASE : SymbolGenerationUtils.MixedCasing.USE_MIXED_CASE;
            assert (obfuscationDictionary != null);
        }

        String nextName(char[] packagePrefix, InternalNamingState state, boolean isDirectMethodCall) {
            StringBuilder nextName = new StringBuilder();
            nextName.append(packagePrefix);
            if (state.getDictionaryIndex() < this.obfuscationDictionary.size()) {
                nextName.append(this.obfuscationDictionary.get(state.incrementDictionaryIndex()));
            } else {
                String nextString;
                while (this.obfuscationDictionaryForLookup.contains(nextString = SymbolGenerationUtils.numberToIdentifier(state.incrementNameIndex(isDirectMethodCall), this.mixedCasing))) {
                }
                nextName.append(nextString);
            }
            return nextName.toString();
        }
    }
}

