/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class NamingLens {
    public abstract String lookupPackageName(String var1);

    public abstract DexString lookupDescriptor(DexType var1);

    public abstract DexString lookupInnerName(InnerClassAttribute var1, InternalOptions var2);

    public abstract DexString lookupName(DexMethod var1);

    public abstract DexString lookupMethodName(DexCallSite var1);

    public abstract DexString lookupName(DexField var1);

    public final DexString lookupName(DexReference reference, DexItemFactory dexItemFactory) {
        if (reference.isDexType()) {
            DexString renamed = this.lookupDescriptor(reference.asDexType());
            return dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        if (reference.isDexMethod()) {
            return this.lookupName(reference.asDexMethod());
        }
        assert (reference.isDexField());
        return this.lookupName(reference.asDexField());
    }

    public final DexField lookupField(DexField field, DexItemFactory dexItemFactory) {
        return dexItemFactory.createField(this.lookupType(field.holder, dexItemFactory), this.lookupType(field.type, dexItemFactory), this.lookupName(field));
    }

    public final DexMethod lookupMethod(DexMethod method, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(this.lookupType(method.holder, dexItemFactory), this.lookupProto(method.proto, dexItemFactory), this.lookupName(method));
    }

    private DexProto lookupProto(DexProto proto, DexItemFactory dexItemFactory) {
        return dexItemFactory.createProto(this.lookupType(proto.returnType, dexItemFactory), (DexType[])Arrays.stream(proto.parameters.values).map(type -> this.lookupType((DexType)type, dexItemFactory)).toArray(DexType[]::new));
    }

    public final DexType lookupType(DexType type, DexItemFactory dexItemFactory) {
        if (type.isPrimitiveType() || type.isVoidType()) {
            return type;
        }
        if (type.isArrayType()) {
            DexType newBaseType = this.lookupType(type.toBaseType(dexItemFactory), dexItemFactory);
            return type.replaceBaseType(newBaseType, dexItemFactory);
        }
        assert (type.isClassType());
        return dexItemFactory.createType(this.lookupDescriptor(type));
    }

    public static NamingLens getIdentityLens() {
        return new IdentityLens();
    }

    public final boolean isIdentityLens() {
        return this instanceof IdentityLens;
    }

    public String lookupInternalName(DexType type) {
        assert (type.isClassType() || type.isArrayType());
        return DescriptorUtils.descriptorToInternalName(this.lookupDescriptor(type).toString());
    }

    abstract void forAllRenamedTypes(Consumer<DexType> var1);

    abstract <T extends DexItem> Map<String, T> getRenamedItems(Class<T> var1, Predicate<T> var2, Function<T, String> var3);

    public abstract boolean checkTargetCanBeTranslated(DexMethod var1);

    public final boolean verifyNoCollisions(Iterable<DexProgramClass> classes, DexItemFactory dexItemFactory) {
        Set<DexReference> references = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : classes) {
            boolean referencesChanged;
            DexType newType = this.lookupType(clazz.type, dexItemFactory);
            boolean referencesChanged2 = references.add(newType);
            assert (referencesChanged2) : "Duplicate definition of type `" + newType.toSourceString() + "`";
            for (DexEncodedField field : clazz.fields()) {
                DexField newField = this.lookupField(field.field, dexItemFactory);
                referencesChanged = references.add(newField);
                assert (referencesChanged) : "Duplicate definition of field `" + newField.toSourceString() + "`";
            }
            for (DexEncodedMethod method : clazz.methods()) {
                DexMethod newMethod = this.lookupMethod(method.method, dexItemFactory);
                referencesChanged = references.add(newMethod);
                assert (referencesChanged) : "Duplicate definition of method `" + newMethod.toSourceString() + "`";
            }
        }
        return true;
    }

    private static class IdentityLens
    extends NamingLens {
        private IdentityLens() {
        }

        @Override
        public DexString lookupDescriptor(DexType type) {
            return type.descriptor;
        }

        @Override
        public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
            return attribute.getInnerName();
        }

        @Override
        public DexString lookupName(DexMethod method) {
            return method.name;
        }

        @Override
        public DexString lookupMethodName(DexCallSite callSite) {
            return callSite.methodName;
        }

        @Override
        public DexString lookupName(DexField field) {
            return field.name;
        }

        @Override
        public String lookupPackageName(String packageName) {
            return packageName;
        }

        @Override
        void forAllRenamedTypes(Consumer<DexType> consumer) {
        }

        @Override
        <T extends DexItem> Map<String, T> getRenamedItems(Class<T> clazz, Predicate<T> predicate, Function<T, String> namer) {
            return ImmutableMap.of();
        }

        @Override
        public boolean checkTargetCanBeTranslated(DexMethod item) {
            return true;
        }
    }
}

