/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.naming.ApplyMappingError;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.ClassNamingForMapApplier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.IdentifierMinifier;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MinifiedRenaming;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProguardMapMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final SeedMapper seedMapper;
    private final Set<DexCallSite> desugaredCallSites;
    private final BiMap<DexType, DexString> mappedNames = HashBiMap.create();
    private final List<DexClass> mappedClasses = new ArrayList<DexClass>();
    private final Map<DexReference, MemberNaming> memberNames = new IdentityHashMap<DexReference, MemberNaming>();
    private final Map<DexType, DexString> syntheticCompanionClasses = new IdentityHashMap<DexType, DexString>();
    private final Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames = new IdentityHashMap<DexMethod, DexString>();
    private final Map<DexMethod, DexString> additionalMethodNamings = new IdentityHashMap<DexMethod, DexString>();
    private final Map<DexField, DexString> additionalFieldNamings = new IdentityHashMap<DexField, DexString>();

    public ProguardMapMinifier(AppView<AppInfoWithLiveness> appView, SeedMapper seedMapper, Set<DexCallSite> desugaredCallSites) {
        this.appView = appView;
        this.seedMapper = seedMapper;
        this.desugaredCallSites = desugaredCallSites;
    }

    public NamingLens run(Timing timing) {
        timing.begin("MappingClasses");
        this.computeMapping(this.appView.dexItemFactory().objectType, new ArrayDeque<Map<DexReference, MemberNaming>>());
        timing.end();
        timing.begin("MappingDefaultInterfaceMethods");
        this.computeDefaultInterfaceMethodMethods();
        timing.end();
        timing.begin("ComputeInterfaces");
        TreeSet<DexClass> interfaces = new TreeSet<DexClass>((a, b) -> a.type.slowCompareTo(b.type));
        for (DexClass dexClass : this.appView.appInfo().computeReachableInterfaces(this.desugaredCallSites)) {
            ClassNamingForMapApplier classNaming = this.seedMapper.getClassNaming(dexClass.type);
            if (classNaming != null) {
                DexString mappedName = this.appView.dexItemFactory().createString(classNaming.renamedName);
                this.checkAndAddMappedNames(dexClass.type, mappedName, classNaming.position);
            }
            this.mappedClasses.add(dexClass);
            interfaces.add(dexClass);
        }
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        this.mappedClasses.sort((a, b) -> a.type.slowCompareTo(b.type));
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new ApplyMappingClassNamingStrategy(this.appView, this.mappedNames), new Minifier.MinificationPackageNamingStrategy(this.appView), this.mappedClasses);
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing, this.syntheticCompanionClasses);
        timing.end();
        ApplyMappingMemberNamingStrategy nameStrategy = new ApplyMappingMemberNamingStrategy(this.appView, this.memberNames);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, nameStrategy).computeRenaming(interfaces, this.desugaredCallSites, timing);
        methodRenaming.renaming.putAll(this.defaultInterfaceMethodImplementationNames);
        methodRenaming.renaming.putAll(this.additionalMethodNamings);
        timing.end();
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, nameStrategy).computeRenaming(interfaces, timing);
        fieldRenaming.renaming.putAll(this.additionalFieldNamings);
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        MinifiedRenaming lens = new MinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming);
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run();
        timing.end();
        return lens;
    }

    private void computeMapping(DexType type, Deque<Map<DexReference, MemberNaming>> buildUpNames) {
        ClassNamingForMapApplier classNaming = this.seedMapper.getClassNaming(type);
        DexClass dexClass = this.appView.definitionFor(type);
        if (dexClass != null && (classNaming != null || dexClass.isProgramClass())) {
            this.mappedClasses.add(dexClass);
        }
        IdentityHashMap nonPrivateMembers = new IdentityHashMap();
        if (classNaming != null) {
            DexString mappedName = this.appView.dexItemFactory().createString(classNaming.renamedName);
            this.checkAndAddMappedNames(type, mappedName, classNaming.position);
            classNaming.forAllMethodNaming(memberNaming -> {
                MemberNaming.Signature signature = memberNaming.getOriginalSignature();
                assert (!signature.isQualified());
                DexMethod originalMethod = ((MemberNaming.MethodSignature)signature).toDexMethod(this.appView.dexItemFactory(), type);
                assert (!this.memberNames.containsKey(originalMethod));
                this.memberNames.put(originalMethod, (MemberNaming)memberNaming);
                DexEncodedMethod encodedMethod = this.appView.definitionFor(originalMethod);
                if (encodedMethod == null || !encodedMethod.accessFlags.isPrivate()) {
                    nonPrivateMembers.put(originalMethod, memberNaming);
                }
            });
            classNaming.forAllFieldNaming(memberNaming -> {
                MemberNaming.Signature signature = memberNaming.getOriginalSignature();
                assert (!signature.isQualified());
                DexField originalField = ((MemberNaming.FieldSignature)signature).toDexField(this.appView.dexItemFactory(), type);
                assert (!this.memberNames.containsKey(originalField));
                this.memberNames.put(originalField, (MemberNaming)memberNaming);
                DexEncodedField encodedField = this.appView.definitionFor(originalField);
                if (encodedField == null || !encodedField.accessFlags.isPrivate()) {
                    nonPrivateMembers.put(originalField, memberNaming);
                }
            });
        } else if (dexClass == null || !this.appView.options().isMinifying()) {
            this.checkAndAddMappedNames(type, type.descriptor, Position.UNKNOWN);
        } else if (this.appView.options().isMinifying() && this.appView.rootSet().mayNotBeMinified(type, this.appView)) {
            this.checkAndAddMappedNames(type, type.descriptor, Position.UNKNOWN);
        }
        for (Map<DexReference, MemberNaming> parentMembers : buildUpNames) {
            for (DexReference key : parentMembers.keySet()) {
                Descriptor parentReferenceOnCurrentType;
                Descriptor parentReference;
                if (key.isDexMethod()) {
                    parentReference = key.asDexMethod();
                    parentReferenceOnCurrentType = this.appView.dexItemFactory().createMethod(type, parentReference.proto, parentReference.name);
                    this.addMemberNaming(key, parentReferenceOnCurrentType, parentMembers, this.additionalMethodNamings);
                    continue;
                }
                parentReference = key.asDexField();
                parentReferenceOnCurrentType = this.appView.dexItemFactory().createField(type, ((DexField)parentReference).type, ((DexField)parentReference).name);
                this.addMemberNaming(key, parentReferenceOnCurrentType, parentMembers, this.additionalFieldNamings);
            }
        }
        if (nonPrivateMembers.size() > 0) {
            buildUpNames.addLast(nonPrivateMembers);
            this.appView.appInfo().forAllExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames));
            buildUpNames.removeLast();
        } else {
            this.appView.appInfo().forAllExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames));
        }
    }

    private <T extends DexReference> void addMemberNaming(DexReference key, T member, Map<DexReference, MemberNaming> parentMembers, Map<T, DexString> additionalMemberNamings) {
        if (!this.memberNames.containsKey(member)) {
            DexString renamedName = this.appView.dexItemFactory().createString(parentMembers.get(key).getRenamedName());
            this.memberNames.put(member, parentMembers.get(key));
            additionalMemberNamings.put(member, renamedName);
        }
    }

    private void checkAndAddMappedNames(DexType type, DexString mappedName, Position position) {
        if (this.mappedNames.inverse().containsKey(mappedName)) {
            this.appView.options().reporter.error(ApplyMappingError.mapToExistingClass(type.toString(), mappedName.toString(), position));
        } else {
            this.mappedNames.put(type, mappedName);
        }
    }

    private void computeDefaultInterfaceMethodMethods() {
        for (String key : this.seedMapper.getKeyset()) {
            DexClass dexClass;
            ClassNamingForMapApplier classNaming = this.seedMapper.getMapping(key);
            DexType type = this.appView.dexItemFactory().lookupType(this.appView.dexItemFactory().createString(key));
            if (type == null || (dexClass = this.appView.definitionFor(type)) != null) continue;
            this.computeDefaultInterfaceMethodMappingsForType(type, classNaming, this.syntheticCompanionClasses, this.defaultInterfaceMethodImplementationNames);
        }
    }

    private void computeDefaultInterfaceMethodMappingsForType(DexType type, ClassNamingForMapApplier classNaming, Map<DexType, DexString> syntheticCompanionClasses, Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames) {
        if (!InterfaceMethodRewriter.isCompanionClassType(type)) {
            return;
        }
        DexClass interfaceType = this.appView.definitionFor(InterfaceMethodRewriter.getInterfaceClassType(type, this.appView.dexItemFactory()));
        if (interfaceType == null || !interfaceType.isClasspathClass()) {
            return;
        }
        syntheticCompanionClasses.put(type, this.appView.dexItemFactory().createString(classNaming.renamedName));
        for (List namings : classNaming.getQualifiedMethodMembers().values()) {
            if (namings.size() != 1) continue;
            MemberNaming naming = (MemberNaming)namings.get(0);
            MemberNaming.MethodSignature signature = (MemberNaming.MethodSignature)naming.getOriginalSignature();
            if (!signature.name.startsWith(interfaceType.type.toSourceString())) continue;
            DexMethod defaultMethod = InterfaceMethodRewriter.defaultAsMethodOfCompanionClass(signature.toUnqualified().toDexMethod(this.appView.dexItemFactory(), interfaceType.type), this.appView.dexItemFactory());
            assert (defaultMethod.holder == type);
            defaultInterfaceMethodImplementationNames.put(defaultMethod, this.appView.dexItemFactory().createString(naming.getRenamedName()));
        }
    }

    static class ApplyMappingMemberNamingStrategy
    extends Minifier.MinifierMemberNamingStrategy {
        private final Map<DexReference, MemberNaming> mappedNames;
        private final DexItemFactory factory;
        private final Reporter reporter;

        public ApplyMappingMemberNamingStrategy(AppView<?> appView, Map<DexReference, MemberNaming> mappedNames) {
            super(appView);
            this.mappedNames = mappedNames;
            this.factory = appView.dexItemFactory();
            this.reporter = appView.options().reporter;
        }

        @Override
        public DexString next(DexMethod method, InternalNamingState internalState) {
            assert (!this.mappedNames.containsKey(method));
            return this.canMinify(method, method.holder) ? super.next(method, internalState) : method.name;
        }

        @Override
        public DexString next(DexField field, InternalNamingState internalState) {
            assert (!this.mappedNames.containsKey(field));
            return this.canMinify(field, field.holder) ? super.next(field, internalState) : field.name;
        }

        private boolean canMinify(DexReference reference, DexType type) {
            if (!this.appView.options().isMinifying()) {
                return false;
            }
            DexClass dexClass = this.appView.definitionFor(type);
            if (dexClass == null || dexClass.isNotProgramClass()) {
                return false;
            }
            return this.appView.rootSet().mayBeMinified(reference, this.appView);
        }

        @Override
        public DexString getReservedNameOrDefault(DexEncodedMethod method, DexClass holder, DexString nullValue) {
            if (this.mappedNames.containsKey(method.method)) {
                return this.factory.createString(this.mappedNames.get(method.method).getRenamedName());
            }
            return nullValue;
        }

        @Override
        public DexString getReservedNameOrDefault(DexEncodedField field, DexClass holder, DexString nullValue) {
            if (this.mappedNames.containsKey(field.field)) {
                return this.factory.createString(this.mappedNames.get(field.field).getRenamedName());
            }
            return nullValue;
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return true;
        }

        @Override
        public void reportReservationError(DexReference source, DexString name) {
            MemberNaming memberNaming = this.mappedNames.get(source);
            assert (source.isDexMethod() || source.isDexField());
            ApplyMappingError applyMappingError = ApplyMappingError.mapToExistingMember(source.toSourceString(), name.toString(), memberNaming == null ? Position.UNKNOWN : memberNaming.position);
            this.reporter.error(applyMappingError);
        }
    }

    static class ApplyMappingClassNamingStrategy
    extends Minifier.MinificationClassNamingStrategy {
        private final Map<DexType, DexString> mappings;
        private final boolean isMinifying;

        ApplyMappingClassNamingStrategy(AppView<?> appView, Map<DexType, DexString> mappings) {
            super(appView);
            this.mappings = mappings;
            this.isMinifying = appView.options().isMinifying();
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state) {
            DexString nextName = this.mappings.get(type);
            if (nextName != null) {
                return nextName;
            }
            assert (!this.isMinifying || !this.noObfuscation(type));
            return this.isMinifying ? super.next(type, packagePrefix, state) : type.descriptor;
        }

        @Override
        public boolean noObfuscation(DexType type) {
            if (this.mappings.containsKey(type)) {
                return false;
            }
            DexClass dexClass = this.appView.definitionFor(type);
            if (dexClass == null || dexClass.isNotProgramClass()) {
                return true;
            }
            return super.noObfuscation(type);
        }
    }
}

