/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.hash.Hasher;
import com.android.tools.r8.com.google.common.hash.Hashing;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MinifiedNameMapPrinter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.VersionProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ProguardMapSupplier {
    public static final String MARKER_KEY_COMPILER = "compiler";
    public static final String MARKER_VALUE_COMPILER = "R8";
    public static final String MARKER_KEY_COMPILER_VERSION = "compiler_version";
    public static final String MARKER_KEY_COMPILER_HASH = "compiler_hash";
    public static final String MARKER_KEY_MIN_API = "min_api";
    public static final String MARKER_KEY_PG_MAP_ID = "pg_map_id";
    public static int PG_MAP_ID_LENGTH = 7;
    private final boolean useClassNameMapper;
    private final ClassNameMapper classNameMapper;
    private final NamingLens namingLens;
    private final DexApplication application;
    private final Integer minApiLevel;

    public static ProguardMapSupplier fromClassNameMapper(ClassNameMapper classNameMapper, InternalOptions options) {
        return new ProguardMapSupplier(true, classNameMapper, null, null, options);
    }

    public static ProguardMapSupplier fromNamingLens(NamingLens namingLens, DexApplication dexApplication, InternalOptions options) {
        return new ProguardMapSupplier(false, null, namingLens, dexApplication, options);
    }

    public ProguardMapSupplier(boolean useClassNameMapper, ClassNameMapper classNameMapper, NamingLens namingLens, DexApplication application, InternalOptions options) {
        this.useClassNameMapper = useClassNameMapper;
        this.classNameMapper = classNameMapper;
        this.namingLens = namingLens;
        this.application = application;
        this.minApiLevel = options.isGeneratingClassFiles() ? null : Integer.valueOf(options.minApiLevel);
    }

    public ProguardMapAndId getProguardMapAndId() {
        String body = this.getBody();
        if (body == null || body.trim().length() == 0) {
            return null;
        }
        Hasher hasher = Hashing.murmur3_32().newHasher();
        body.codePoints().filter(c -> !Character.isWhitespace(c)).forEach(hasher::putInt);
        String proguardMapId = hasher.hash().toString().substring(0, PG_MAP_ID_LENGTH);
        StringBuilder builder = new StringBuilder();
        builder.append("# compiler: R8\n# compiler_version: 1.5.37\n");
        if (this.minApiLevel != null) {
            builder.append("# min_api: " + this.minApiLevel + "\n");
        }
        if (Version.isDev()) {
            builder.append("# compiler_hash: " + VersionProperties.INSTANCE.getSha() + "\n");
        }
        builder.append("# pg_map_id: " + proguardMapId + "\n");
        builder.append(body);
        return new ProguardMapAndId(builder.toString(), proguardMapId);
    }

    private String getBody() {
        if (this.useClassNameMapper) {
            assert (this.classNameMapper != null);
            return this.classNameMapper.toString();
        }
        assert (this.namingLens != null && this.application != null);
        if (!this.namingLens.isIdentityLens()) {
            StringBuilder map2 = new StringBuilder();
            new MinifiedNameMapPrinter(this.application, this.namingLens).write(map2);
            return map2.toString();
        }
        if (this.application.getProguardMap() != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes);
            try {
                this.application.getProguardMap().write(writer);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while creating Proguard-map output: " + e);
            }
            return bytes.toString();
        }
        return null;
    }

    public static class ProguardMapAndId {
        public final String map;
        public final String id;

        ProguardMapAndId(String map2, String id) {
            assert (map2 != null && id != null);
            this.map = map2;
            this.id = id;
        }
    }
}

