/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.FieldNamingStateBase;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ReservedFieldNamingState
extends FieldNamingStateBase<InternalState> {
    public ReservedFieldNamingState(AppView<?> appView) {
        super(appView, new IdentityHashMap());
    }

    public boolean isReserved(DexString name, DexType type) {
        InternalState internalState = (InternalState)this.getInternalState(type);
        return internalState != null && internalState.isReserved(name);
    }

    public void markReservedDirectly(DexString name, DexType type) {
        ((InternalState)this.getOrCreateInternalState(type)).markReservedDirectly(name);
    }

    public void includeReservations(ReservedFieldNamingState reservedNames) {
        for (Map.Entry entry : reservedNames.internalStates.entrySet()) {
            ((InternalState)this.getOrCreateInternalState((DexType)entry.getKey())).includeReservations((InternalState)entry.getValue());
        }
    }

    public void includeReservationsFromBelow(ReservedFieldNamingState reservedNames) {
        for (Map.Entry entry : reservedNames.internalStates.entrySet()) {
            ((InternalState)this.getOrCreateInternalState((DexType)entry.getKey())).includeReservationsFromBelow((InternalState)entry.getValue());
        }
    }

    @Override
    InternalState createInternalState() {
        return new InternalState();
    }

    static class InternalState {
        private Set<DexString> reservedNamesDirect = Sets.newIdentityHashSet();
        private Set<DexString> reservedNamesBelow = Sets.newIdentityHashSet();

        InternalState() {
        }

        public boolean isReserved(DexString name) {
            return this.reservedNamesDirect.contains(name) || this.reservedNamesBelow.contains(name);
        }

        public void markReservedDirectly(DexString name) {
            this.reservedNamesDirect.add(name);
        }

        public void includeReservations(InternalState state) {
            this.reservedNamesDirect.addAll(state.reservedNamesDirect);
        }

        public void includeReservationsFromBelow(InternalState state) {
            this.reservedNamesBelow.addAll(state.reservedNamesDirect);
            this.reservedNamesBelow.addAll(state.reservedNamesBelow);
        }
    }
}

