/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.shaking.ProguardConfiguration;
import java.util.Arrays;

public class SourceFileRewriter {
    private final AppView<?> appView;

    public SourceFileRewriter(AppView<?> appView) {
        this.appView = appView;
    }

    public void run() {
        ProguardConfiguration proguardConfiguration = this.appView.options().getProguardConfiguration();
        String renameSourceFile = proguardConfiguration.getRenameSourceFileAttribute();
        if (renameSourceFile == null && proguardConfiguration.getKeepAttributes().sourceFile) {
            return;
        }
        DexString dexRenameSourceFile = renameSourceFile == null ? this.appView.dexItemFactory().createString("") : this.appView.dexItemFactory().createString(renameSourceFile);
        for (DexClass dexClass : ((AppInfo)this.appView.appInfo()).classes()) {
            dexClass.sourceFile = dexRenameSourceFile;
            dexClass.forEachMethod(encodedMethod -> {
                if (encodedMethod.shouldNotHaveCode()) {
                    return;
                }
                Code code = encodedMethod.getCode();
                if (code == null) {
                    return;
                }
                if (code.isDexCode()) {
                    DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
                    if (dexDebugInfo == null) {
                        return;
                    }
                    dexDebugInfo.events = (DexDebugEvent[])Arrays.stream(dexDebugInfo.events).filter(dexDebugEvent -> !(dexDebugEvent instanceof DexDebugEvent.SetFile)).toArray(DexDebugEvent[]::new);
                } else assert (code.isCfCode());
            });
        }
    }
}

