/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.optimize.MemberRebindingLense;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MemberRebindingAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final GraphLense lense;
    private final InternalOptions options;
    private final MemberRebindingLense.Builder builder;

    public MemberRebindingAnalysis(AppView<AppInfoWithLiveness> appView) {
        assert (appView.graphLense().isContextFreeForMethods());
        this.appView = appView;
        this.lense = appView.graphLense();
        this.options = appView.options();
        this.builder = MemberRebindingLense.builder(appView);
    }

    private DexMethod validTargetFor(DexMethod target, DexMethod original) {
        DexClass clazz = this.appView.definitionFor(target.holder);
        assert (clazz != null);
        if (clazz.isProgramClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.holder, DexClass::lookupMethod) : this.firstLibraryClass(target.holder, original.holder);
        return this.appView.dexItemFactory().createMethod(newHolder, original.proto, original.name);
    }

    private DexField validTargetFor(DexField target, DexField original, BiFunction<DexClass, DexField, DexEncodedField> lookup) {
        DexClass clazz = this.appView.definitionFor(target.holder);
        assert (clazz != null);
        if (clazz.isProgramClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.holder, lookup) : this.firstLibraryClass(target.holder, original.holder);
        return this.appView.dexItemFactory().createField(newHolder, original.type, original.name);
    }

    private <T> DexType firstLibraryClassForInterfaceTarget(T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        DexType matchingSuper;
        DexClass clazz = this.appView.definitionFor(current);
        Object potential = lookup.apply(clazz, (DexClass)target);
        if (potential != null) {
            return current;
        }
        if (clazz.superType != null && (matchingSuper = this.firstLibraryClassForInterfaceTarget(target, clazz.superType, lookup)) != null) {
            return clazz.isNotProgramClass() ? current : matchingSuper;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexType matchingIface = this.firstLibraryClassForInterfaceTarget(target, iface, lookup);
            if (matchingIface == null) continue;
            return clazz.isNotProgramClass() ? current : matchingIface;
        }
        return null;
    }

    private DexType firstLibraryClass(DexType top, DexType bottom) {
        assert (this.appView.definitionFor(top).isNotProgramClass());
        DexClass searchClass = this.appView.definitionFor(bottom);
        while (searchClass.isProgramClass()) {
            searchClass = this.appView.definitionFor(searchClass.superType);
        }
        return searchClass.type;
    }

    private DexEncodedMethod classLookup(DexMethod method) {
        return this.appView.appInfo().resolveMethodOnClass(method.holder, method).asResultOfResolve();
    }

    private DexEncodedMethod interfaceLookup(DexMethod method) {
        return this.appView.appInfo().resolveMethodOnInterface(method.holder, method).asResultOfResolve();
    }

    private DexEncodedMethod anyLookup(DexMethod method) {
        return this.appView.appInfo().resolveMethod(method.holder, method).asResultOfResolve();
    }

    private void computeMethodRebinding(Map<DexMethod, Set<DexEncodedMethod>> methodsWithContexts, Function<DexMethod, DexEncodedMethod> lookupTarget, Invoke.Type invokeType) {
        for (DexMethod method : methodsWithContexts.keySet()) {
            DexEncodedMethod target;
            DexClass originalClass;
            if (!method.holder.isClassType() || (originalClass = this.appView.definitionFor(method.holder)) == null || originalClass.isNotProgramClass() || (target = lookupTarget.apply(method)) == null || target.method == method) continue;
            DexClass targetClass = this.appView.definitionFor(target.method.holder);
            if (originalClass.isProgramClass()) {
                if (this.needsBridgeForInterfaceMethod(originalClass, targetClass, invokeType)) {
                    target = this.insertBridgeForInterfaceMethod(method, target, originalClass.asProgramClass(), targetClass, lookupTarget);
                }
                DexEncodedMethod finalTarget = target;
                Set<DexEncodedMethod> contexts = methodsWithContexts.get(method);
                if (contexts.stream().anyMatch(context -> this.mayNeedBridgeForVisibility(context.method.holder, finalTarget))) {
                    target = this.insertBridgeForVisibilityIfNeeded(method, target, originalClass, targetClass, lookupTarget);
                }
            }
            this.builder.map(method, this.lense.lookupMethod(this.validTargetFor(target.method, method)));
        }
    }

    private boolean needsBridgeForInterfaceMethod(DexClass originalClass, DexClass targetClass, Invoke.Type invokeType) {
        return this.options.isGeneratingClassFiles() && invokeType == Invoke.Type.SUPER && targetClass != originalClass && targetClass.accessFlags.isInterface();
    }

    private DexEncodedMethod insertBridgeForInterfaceMethod(DexMethod method, DexEncodedMethod target, DexProgramClass originalClass, DexClass targetClass, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        DexProgramClass bridgeHolder = this.findHolderForInterfaceMethodBridge(originalClass, targetClass.type);
        assert (bridgeHolder != null);
        assert (bridgeHolder != targetClass);
        DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appView);
        bridgeHolder.addMethod(bridgeMethod);
        assert (lookupTarget.apply(method) == bridgeMethod);
        return bridgeMethod;
    }

    private DexProgramClass findHolderForInterfaceMethodBridge(DexProgramClass clazz, DexType iface) {
        if (clazz.accessFlags.isInterface()) {
            return clazz;
        }
        DexClass superClass = this.appView.definitionFor(clazz.superType);
        if (superClass == null || superClass.isNotProgramClass() || !this.appView.appInfo().isSubtype(superClass.type, iface)) {
            return clazz;
        }
        return this.findHolderForInterfaceMethodBridge(superClass.asProgramClass(), iface);
    }

    private boolean mayNeedBridgeForVisibility(DexType context, DexEncodedMethod method) {
        DexType holderType = method.method.holder;
        DexClass holder = this.appView.definitionFor(holderType);
        if (holder == null) {
            return false;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, holder.accessFlags, this.appView);
        Inliner.ConstraintWithTarget methodVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, method.accessFlags, this.appView);
        return classVisibility == Inliner.ConstraintWithTarget.NEVER && methodVisibility != Inliner.ConstraintWithTarget.NEVER;
    }

    private DexEncodedMethod insertBridgeForVisibilityIfNeeded(DexMethod method, DexEncodedMethod target, DexClass originalClass, DexClass targetClass, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        String packageDescriptor;
        String string = packageDescriptor = originalClass.accessFlags.isPublic() ? null : method.holder.getPackageDescriptor();
        if (packageDescriptor == null || !packageDescriptor.equals(targetClass.type.getPackageDescriptor())) {
            DexProgramClass bridgeHolder = this.findHolderForVisibilityBridge(originalClass, targetClass, packageDescriptor);
            assert (bridgeHolder != null);
            DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appView);
            bridgeHolder.addMethod(bridgeMethod);
            assert (lookupTarget.apply(method) == bridgeMethod);
            return bridgeMethod;
        }
        return target;
    }

    private DexProgramClass findHolderForVisibilityBridge(DexClass originalClass, DexClass targetClass, String packageDescriptor) {
        if (originalClass == targetClass || originalClass.isNotProgramClass()) {
            return null;
        }
        DexProgramClass newHolder = null;
        if (this.appView.appInfo().isSubtype(originalClass.superType, targetClass.type)) {
            DexClass superClass = this.appView.definitionFor(originalClass.superType);
            newHolder = this.findHolderForVisibilityBridge(superClass, targetClass, packageDescriptor);
        } else {
            for (DexType iface : originalClass.interfaces.values) {
                if (!this.appView.appInfo().isSubtype(iface, targetClass.type)) continue;
                DexClass interfaceClass = this.appView.definitionFor(iface);
                newHolder = this.findHolderForVisibilityBridge(interfaceClass, targetClass, packageDescriptor);
            }
        }
        if (newHolder != null) {
            return newHolder;
        }
        if (originalClass.accessFlags.isPublic() || originalClass.type.getPackageDescriptor().equals(packageDescriptor)) {
            return originalClass.asProgramClass();
        }
        return null;
    }

    private void computeFieldRebinding(Map<DexField, Set<DexEncodedMethod>> fieldsWithContexts, BiFunction<DexType, DexField, DexEncodedField> lookup, BiFunction<DexClass, DexField, DexEncodedField> lookupTargetOnClass) {
        for (DexField field : fieldsWithContexts.keySet()) {
            DexEncodedField target = lookup.apply(field.holder, field);
            Set<DexEncodedMethod> contexts = fieldsWithContexts.get(field);
            if (target == null || target.field == field || !contexts.stream().allMatch(context -> MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(this.appView, context.method.holder, target.field.holder, target.accessFlags))) continue;
            this.builder.map(field, this.lense.lookupField(this.validTargetFor(target.field, field, lookupTargetOnClass)));
        }
    }

    public static boolean isMemberVisibleFromOriginalContext(AppView<?> appView, DexType context, DexType holder, AccessFlags<?> memberAccessFlags) {
        DexClass clazz = appView.definitionFor(holder);
        if (clazz == null) {
            return false;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holder, clazz.accessFlags, appView);
        if (classVisibility == Inliner.ConstraintWithTarget.NEVER) {
            return false;
        }
        Inliner.ConstraintWithTarget memberVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holder, memberAccessFlags, appView);
        return memberVisibility != Inliner.ConstraintWithTarget.NEVER;
    }

    private Map<DexField, Set<DexEncodedMethod>> mergeFieldAccessContexts(Map<DexField, Set<DexEncodedMethod>> reads, Map<DexField, Set<DexEncodedMethod>> writes) {
        IdentityHashMap result = new IdentityHashMap();
        Sets.SetView<DexField> fields = Sets.union(reads.keySet(), writes.keySet());
        for (DexField field : fields) {
            Set contexts = Sets.newIdentityHashSet();
            contexts.addAll(reads.getOrDefault(field, ImmutableSet.of()));
            contexts.addAll(writes.getOrDefault(field, ImmutableSet.of()));
            result.put(field, contexts);
        }
        return Collections.unmodifiableMap(result);
    }

    public GraphLense run() {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        this.computeMethodRebinding(appInfo.virtualInvokes, this::classLookup, Invoke.Type.VIRTUAL);
        this.computeMethodRebinding(appInfo.interfaceInvokes, this::interfaceLookup, Invoke.Type.INTERFACE);
        this.computeMethodRebinding(appInfo.superInvokes, this::anyLookup, Invoke.Type.SUPER);
        this.computeMethodRebinding(appInfo.directInvokes, this::anyLookup, Invoke.Type.DIRECT);
        this.computeMethodRebinding(appInfo.staticInvokes, this::anyLookup, Invoke.Type.STATIC);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(appInfo.staticFieldReads, appInfo.staticFieldWrites), appInfo::resolveFieldOn, DexClass::lookupField);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(appInfo.instanceFieldReads, appInfo.instanceFieldWrites), appInfo::resolveFieldOn, DexClass::lookupField);
        return this.builder.build(this.lense);
    }
}

