/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import java.util.ArrayList;
import java.util.List;

public class AbstractMethodRemover {
    private final AppInfoWithLiveness appInfo;
    private ScopedDexMethodSet scope = new ScopedDexMethodSet();

    public AbstractMethodRemover(AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
    }

    public void run() {
        assert (this.scope.getParent() == null);
        this.processClass(this.appInfo.dexItemFactory().objectType);
    }

    private void processClass(DexType type) {
        DexEncodedMethod[] newVirtualMethods;
        DexClass holder = this.appInfo.definitionFor(type);
        this.scope = this.scope.newNestedScope();
        if (holder != null && holder.isProgramClass() && (newVirtualMethods = this.processMethods(holder.virtualMethods())) != null) {
            holder.setVirtualMethods(newVirtualMethods);
        }
        this.appInfo.forAllExtendsSubtypes(type, this::processClass);
        this.scope = this.scope.getParent();
    }

    private DexEncodedMethod[] processMethods(List<DexEncodedMethod> virtualMethods) {
        if (virtualMethods == null) {
            return null;
        }
        ArrayList<DexEncodedMethod> methods = null;
        for (int i = 0; i < virtualMethods.size(); ++i) {
            DexEncodedMethod method = virtualMethods.get(i);
            if (this.scope.addMethodIfMoreVisible(method) || !method.accessFlags.isAbstract() || this.appInfo.isPinned(method.method)) {
                if (methods == null) continue;
                methods.add(method);
                continue;
            }
            if (methods != null) continue;
            methods = new ArrayList<DexEncodedMethod>(virtualMethods.size() - 1);
            for (int j = 0; j < i; ++j) {
                methods.add(virtualMethods.get(j));
            }
        }
        if (methods != null) {
            return methods.toArray(DexEncodedMethod.EMPTY_ARRAY);
        }
        return null;
    }
}

